/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.Resources;
import org.springframework.util.Assert;

@XmlRootElement(name="pagedEntities")
public class PagedResources<T>
extends Resources<T> {
    public static PagedResources<?> NO_PAGE = new PagedResources();
    private PageMetadata metadata;

    protected PagedResources() {
        this(new ArrayList(), (PageMetadata)null, new Link[0]);
    }

    public PagedResources(Collection<T> content, PageMetadata metadata, Link ... links) {
        this(content, metadata, Arrays.asList(links));
    }

    public PagedResources(Collection<T> content, PageMetadata metadata, Iterable<Link> links) {
        super(content, links);
        this.metadata = metadata;
    }

    @JsonProperty(value="page")
    public PageMetadata getMetadata() {
        return this.metadata;
    }

    public static <T extends Resource<S>, S> PagedResources<T> wrap(Iterable<S> content, PageMetadata metadata) {
        Assert.notNull(content);
        ArrayList<Resource<S>> resources = new ArrayList<Resource<S>>();
        for (S element : content) {
            resources.add(new Resource<S>(element, new Link[0]));
        }
        return new PagedResources(resources, metadata, new Link[0]);
    }

    @JsonIgnore
    public Link getNextLink() {
        return this.getLink("next");
    }

    @JsonIgnore
    public Link getPreviousLink() {
        return this.getLink("prev");
    }

    @Override
    public String toString() {
        return String.format("PagedResource { content: %s, metadata: %s, links: %s }", this.getContent(), this.metadata, this.getLinks());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        PagedResources that = (PagedResources)obj;
        boolean metadataEquals = this.metadata == null ? that.metadata == null : this.metadata.equals(that.metadata);
        return metadataEquals ? super.equals(obj) : false;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result += this.metadata == null ? 0 : 31 * this.metadata.hashCode();
    }

    public static class PageMetadata {
        @XmlAttribute
        @JsonProperty
        private long size;
        @XmlAttribute
        @JsonProperty
        private long totalElements;
        @XmlAttribute
        @JsonProperty
        private long totalPages;
        @XmlAttribute
        @JsonProperty
        private long number;

        protected PageMetadata() {
        }

        public PageMetadata(long size, long number, long totalElements, long totalPages) {
            Assert.isTrue((size > -1L ? 1 : 0) != 0, (String)"Size must not be negative!");
            Assert.isTrue((number > -1L ? 1 : 0) != 0, (String)"Number must not be negative!");
            Assert.isTrue((totalElements > -1L ? 1 : 0) != 0, (String)"Total elements must not be negative!");
            Assert.isTrue((totalPages > -1L ? 1 : 0) != 0, (String)"Total pages must not be negative!");
            this.size = size;
            this.number = number;
            this.totalElements = totalElements;
            this.totalPages = totalPages;
        }

        public PageMetadata(long size, long number, long totalElements) {
            this(size, number, totalElements, size == 0L ? 0L : totalElements / size);
        }

        public long getSize() {
            return this.size;
        }

        public long getTotalElements() {
            return this.totalElements;
        }

        public long getTotalPages() {
            return this.totalPages;
        }

        public long getNumber() {
            return this.number;
        }

        public String toString() {
            return String.format("Metadata { number: %d, total pages: %d, total elements: %d, size: %d }", this.number, this.totalPages, this.totalElements, this.size);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !obj.getClass().equals(this.getClass())) {
                return false;
            }
            PageMetadata that = (PageMetadata)obj;
            return this.number == that.number && this.size == that.size && this.totalElements == that.totalElements && this.totalPages == that.totalPages;
        }

        public int hashCode() {
            int result = 17;
            result += 31 * (int)(this.number ^ this.number >>> 32);
            result += 31 * (int)(this.size ^ this.size >>> 32);
            result += 31 * (int)(this.totalElements ^ this.totalElements >>> 32);
            return result += 31 * (int)(this.totalPages ^ this.totalPages >>> 32);
        }
    }
}

