/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas;

import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.hateoas.TemplateVariable;
import org.springframework.hateoas.TemplateVariables;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

public class UriTemplate
implements Iterable<TemplateVariable>,
Serializable {
    private static final Pattern VARIABLE_REGEX = Pattern.compile("\\{([\\?\\&#/]?)([\\w\\,]+)\\}");
    private static final long serialVersionUID = -1007874653930162262L;
    private final TemplateVariables variables;
    private String baseUri;

    public UriTemplate(String template) {
        Assert.hasText((String)template, (String)"Template must not be null or empty!");
        Matcher matcher = VARIABLE_REGEX.matcher(template);
        int baseUriEndIndex = template.length();
        ArrayList<TemplateVariable> variables = new ArrayList<TemplateVariable>();
        while (matcher.find()) {
            String[] names;
            int start = matcher.start(0);
            TemplateVariable.VariableType type = TemplateVariable.VariableType.from(matcher.group(1));
            for (String name : names = matcher.group(2).split(",")) {
                TemplateVariable variable = new TemplateVariable(name, type);
                if (!variable.isRequired() && start < baseUriEndIndex) {
                    baseUriEndIndex = start;
                }
                variables.add(variable);
            }
        }
        this.variables = variables.isEmpty() ? TemplateVariables.NONE : new TemplateVariables(variables);
        this.baseUri = template.substring(0, baseUriEndIndex);
    }

    public UriTemplate(String baseUri, TemplateVariables variables) {
        Assert.hasText((String)"Base URI must not be null or empty!");
        this.baseUri = baseUri;
        this.variables = variables == null ? TemplateVariables.NONE : variables;
    }

    public UriTemplate with(TemplateVariables variables) {
        if (variables == null) {
            return this;
        }
        return new UriTemplate(this.baseUri, this.variables.concat(variables));
    }

    public static boolean isTemplate(String candidate) {
        if (!StringUtils.hasText((String)candidate)) {
            return false;
        }
        return VARIABLE_REGEX.matcher(candidate).find();
    }

    public List<TemplateVariable> getVariables() {
        return this.variables.asList();
    }

    public List<String> getVariableNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (TemplateVariable variable : this.variables) {
            names.add(variable.getName());
        }
        return names;
    }

    public URI expand(Object ... parameters) {
        if (TemplateVariables.NONE.equals(this.variables)) {
            return URI.create(this.baseUri);
        }
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)this.baseUri);
        Iterator<Object> iterator = Arrays.asList(parameters).iterator();
        for (TemplateVariable variable : this.variables) {
            Object value = iterator.hasNext() ? iterator.next() : null;
            UriTemplate.appendToBuilder(builder, variable, value);
        }
        return builder.build().toUri();
    }

    public URI expand(Map<String, ? extends Object> parameters) {
        if (TemplateVariables.NONE.equals(this.variables)) {
            return URI.create(this.baseUri);
        }
        Assert.notNull(parameters, (String)"Parameters must not be null!");
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)this.baseUri);
        for (TemplateVariable variable : this.variables) {
            UriTemplate.appendToBuilder(builder, variable, parameters.get(variable.getName()));
        }
        return builder.build().toUri();
    }

    @Override
    public Iterator<TemplateVariable> iterator() {
        return this.variables.iterator();
    }

    public String toString() {
        return this.baseUri + this.getOptionalVariables().toString();
    }

    private TemplateVariables getOptionalVariables() {
        ArrayList<TemplateVariable> result = new ArrayList<TemplateVariable>();
        for (TemplateVariable variable : this) {
            if (variable.isRequired()) continue;
            result.add(variable);
        }
        return new TemplateVariables(result);
    }

    private static void appendToBuilder(UriComponentsBuilder builder, TemplateVariable variable, Object value) {
        if (value == null) {
            if (variable.isRequired()) {
                throw new IllegalArgumentException(String.format("Template variable %s is required but no value was given!", variable.getName()));
            }
            return;
        }
        switch (variable.getType()) {
            case REQUEST_PARAM: 
            case REQUEST_PARAM_CONTINUED: {
                builder.queryParam(variable.getName(), new Object[]{value});
                break;
            }
            case PATH_VARIABLE: 
            case SEGMENT: {
                builder.pathSegment(new String[]{value.toString()});
                break;
            }
            case FRAGMENT: {
                builder.fragment(value.toString());
            }
        }
    }
}

