/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.hal;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.ContainerSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.std.MapSerializer;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.ResourceSupport;
import org.springframework.hateoas.hal.LinkMixin;
import org.springframework.hateoas.hal.ResourceSupportMixin;

public class Jackson2HalModule
extends SimpleModule {
    private static final long serialVersionUID = 7806951456457932384L;

    public Jackson2HalModule() {
        super("json-hal-module", new Version(1, 0, 0, null));
        this.setMixInAnnotation(Link.class, LinkMixin.class);
        this.setMixInAnnotation(ResourceSupport.class, ResourceSupportMixin.class);
    }

    public static class OptionalListJackson2Serializer
    extends ContainerSerializer<Object>
    implements ContextualSerializer {
        private final BeanProperty property;
        private JsonSerializer<Object> serializer;

        public OptionalListJackson2Serializer() {
            this(null);
        }

        public OptionalListJackson2Serializer(BeanProperty property) {
            super(List.class, false);
            this.property = property;
        }

        public ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
            throw new UnsupportedOperationException("not implemented");
        }

        public void serialize(Object value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            List list = (List)value;
            if (list.size() == 1) {
                this.serializeContents(list.iterator(), jgen, provider);
                return;
            }
            jgen.writeStartArray();
            this.serializeContents(list.iterator(), jgen, provider);
            jgen.writeEndArray();
        }

        private void serializeContents(Iterator<?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            while (value.hasNext()) {
                Object elem = value.next();
                if (elem == null) {
                    provider.defaultSerializeNull(jgen);
                    continue;
                }
                if (this.serializer == null) {
                    this.serializer = provider.findValueSerializer(elem.getClass(), this.property);
                }
                this.serializer.serialize(elem, jgen, provider);
            }
        }

        public JsonSerializer<?> getContentSerializer() {
            return this.serializer;
        }

        public JavaType getContentType() {
            return null;
        }

        public boolean hasSingleElement(Object arg0) {
            return false;
        }

        public boolean isEmpty(Object arg0) {
            return false;
        }

        public JsonSerializer<?> createContextual(SerializerProvider provider, BeanProperty property) throws JsonMappingException {
            return new OptionalListJackson2Serializer(property);
        }
    }

    public static class HalLinkListSerializer
    extends ContainerSerializer<List<Link>>
    implements ContextualSerializer {
        private final BeanProperty property;

        public HalLinkListSerializer() {
            this(null);
        }

        public HalLinkListSerializer(BeanProperty property) {
            super(List.class, false);
            this.property = property;
        }

        public void serialize(List<Link> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            HashMap sortedLinks = new HashMap();
            for (Link link : value) {
                if (sortedLinks.get(link.getRel()) == null) {
                    sortedLinks.put(link.getRel(), new ArrayList());
                }
                ((List)sortedLinks.get(link.getRel())).add(link);
            }
            TypeFactory typeFactory = provider.getConfig().getTypeFactory();
            JavaType keyType = typeFactory.uncheckedSimpleType(String.class);
            CollectionType valueType = typeFactory.constructCollectionType(ArrayList.class, Link.class);
            MapType mapType = typeFactory.constructMapType(HashMap.class, keyType, (JavaType)valueType);
            MapSerializer serializer = MapSerializer.construct((String[])new String[0], (JavaType)mapType, (boolean)true, null, (JsonSerializer)provider.findKeySerializer(keyType, null), (JsonSerializer)new OptionalListJackson2Serializer(this.property));
            serializer.serialize(sortedLinks, jgen, provider);
        }

        public JsonSerializer<?> createContextual(SerializerProvider provider, BeanProperty property) throws JsonMappingException {
            return new HalLinkListSerializer(property);
        }

        public JavaType getContentType() {
            return null;
        }

        public JsonSerializer<?> getContentSerializer() {
            return null;
        }

        public boolean isEmpty(List<Link> value) {
            return false;
        }

        public boolean hasSingleElement(List<Link> value) {
            return false;
        }

        protected ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
            return null;
        }
    }
}

