/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.springframework.hateoas.Identifiable;
import org.springframework.hateoas.Link;
import org.springframework.util.Assert;

public class ResourceSupport
implements Identifiable<Link> {
    @XmlElement(name="link", namespace="http://www.w3.org/2005/Atom")
    @org.codehaus.jackson.annotate.JsonProperty(value="links")
    @JsonProperty(value="links")
    private final List<Link> links = new ArrayList<Link>();

    @Override
    @JsonIgnore
    @com.fasterxml.jackson.annotation.JsonIgnore
    public Link getId() {
        return this.getLink("self");
    }

    public void add(Link link) {
        Assert.notNull((Object)link, (String)"Link must not be null!");
        this.links.add(link);
    }

    public void add(Iterable<Link> links) {
        Assert.notNull(links, (String)"Given links must not be null!");
        for (Link candidate : links) {
            this.add(candidate);
        }
    }

    public boolean hasLinks() {
        return !this.links.isEmpty();
    }

    public boolean hasLink(String rel) {
        return this.getLink(rel) != null;
    }

    public List<Link> getLinks() {
        return Collections.unmodifiableList(this.links);
    }

    public Link getLink(String rel) {
        for (Link link : this.links) {
            if (!link.getRel().equals(rel)) continue;
            return link;
        }
        return null;
    }

    public String toString() {
        return String.format("links: %s", this.links.toString());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        ResourceSupport that = (ResourceSupport)obj;
        return this.links.equals(that.links);
    }

    public int hashCode() {
        return this.links.hashCode();
    }
}

