/*
 * Copyright 2019 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.hateoas.config;

import java.util.ArrayList;
import java.util.List;

import org.springframework.context.annotation.ImportSelector;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.hateoas.support.WebStack;

/**
 * {@link ImportSelector} to include web stack specific configuration.
 *
 * @author Oliver Drotbohm
 */
class WebStackImportSelector implements ImportSelector {

	/*
	 * (non-Javadoc)
	 * @see org.springframework.context.annotation.ImportSelector#selectImports(org.springframework.core.type.AnnotationMetadata)
	 */
	@Override
	public String[] selectImports(AnnotationMetadata importingClassMetadata) {

		List<String> imports = new ArrayList<>();

		if (WebStack.WEBMVC.isAvailable()) {
			imports.add("org.springframework.hateoas.config.WebMvcHateoasConfiguration");
		}

		if (WebStack.WEBFLUX.isAvailable()) {
			imports.add("org.springframework.hateoas.config.WebFluxHateoasConfiguration");
		}

		return imports.toArray(new String[imports.size()]);
	}
}
