/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas;

import java.util.List;
import lombok.Generated;
import org.springframework.core.ResolvableType;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.QueryParameter;
import org.springframework.http.HttpMethod;
import org.springframework.util.Assert;

public abstract class AffordanceModel {
    private String name;
    private Link link;
    private HttpMethod httpMethod;
    private ResolvableType inputType;
    private List<QueryParameter> queryMethodParameters;
    private ResolvableType outputType;

    public String getURI() {
        return this.link.expand(new Object[0]).getHref();
    }

    public boolean hasHttpMethod(HttpMethod method) {
        Assert.notNull((Object)method, (String)"HttpMethod must not be null!");
        return this.httpMethod.equals((Object)method);
    }

    public boolean pointsToTargetOf(Link link) {
        Assert.notNull((Object)link, (String)"Link must not be null!");
        return this.getURI().equals(link.expand(new Object[0]).getHref());
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AffordanceModel)) {
            return false;
        }
        AffordanceModel other = (AffordanceModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Link this$link = this.getLink();
        Link other$link = other.getLink();
        if (this$link == null ? other$link != null : !((Object)this$link).equals(other$link)) {
            return false;
        }
        HttpMethod this$httpMethod = this.getHttpMethod();
        HttpMethod other$httpMethod = other.getHttpMethod();
        if (this$httpMethod == null ? other$httpMethod != null : !this$httpMethod.equals(other$httpMethod)) {
            return false;
        }
        ResolvableType this$inputType = this.getInputType();
        ResolvableType other$inputType = other.getInputType();
        if (this$inputType == null ? other$inputType != null : !this$inputType.equals(other$inputType)) {
            return false;
        }
        List<QueryParameter> this$queryMethodParameters = this.getQueryMethodParameters();
        List<QueryParameter> other$queryMethodParameters = other.getQueryMethodParameters();
        if (this$queryMethodParameters == null ? other$queryMethodParameters != null : !((Object)this$queryMethodParameters).equals(other$queryMethodParameters)) {
            return false;
        }
        ResolvableType this$outputType = this.getOutputType();
        ResolvableType other$outputType = other.getOutputType();
        return !(this$outputType == null ? other$outputType != null : !this$outputType.equals(other$outputType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AffordanceModel;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Link $link = this.getLink();
        result = result * 59 + ($link == null ? 43 : ((Object)$link).hashCode());
        HttpMethod $httpMethod = this.getHttpMethod();
        result = result * 59 + ($httpMethod == null ? 43 : $httpMethod.hashCode());
        ResolvableType $inputType = this.getInputType();
        result = result * 59 + ($inputType == null ? 43 : $inputType.hashCode());
        List<QueryParameter> $queryMethodParameters = this.getQueryMethodParameters();
        result = result * 59 + ($queryMethodParameters == null ? 43 : ((Object)$queryMethodParameters).hashCode());
        ResolvableType $outputType = this.getOutputType();
        result = result * 59 + ($outputType == null ? 43 : $outputType.hashCode());
        return result;
    }

    @Generated
    public AffordanceModel(String name, Link link, HttpMethod httpMethod, ResolvableType inputType, List<QueryParameter> queryMethodParameters, ResolvableType outputType) {
        this.name = name;
        this.link = link;
        this.httpMethod = httpMethod;
        this.inputType = inputType;
        this.queryMethodParameters = queryMethodParameters;
        this.outputType = outputType;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Link getLink() {
        return this.link;
    }

    @Generated
    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    @Generated
    public ResolvableType getInputType() {
        return this.inputType;
    }

    @Generated
    public List<QueryParameter> getQueryMethodParameters() {
        return this.queryMethodParameters;
    }

    @Generated
    public ResolvableType getOutputType() {
        return this.outputType;
    }
}

