/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.hal.forms;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import java.util.List;
import lombok.Generated;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.hateoas.client.LinkDiscoverer;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.hateoas.config.HypermediaMappingInformation;
import org.springframework.hateoas.mediatype.hal.CurieProvider;
import org.springframework.hateoas.mediatype.hal.forms.HalFormsConfiguration;
import org.springframework.hateoas.mediatype.hal.forms.HalFormsLinkDiscoverer;
import org.springframework.hateoas.mediatype.hal.forms.Jackson2HalFormsModule;
import org.springframework.hateoas.server.LinkRelationProvider;
import org.springframework.hateoas.server.core.DelegatingLinkRelationProvider;
import org.springframework.http.MediaType;

@Configuration
class HalFormsMediaTypeConfiguration
implements HypermediaMappingInformation {
    private final DelegatingLinkRelationProvider relProvider;
    private final ObjectProvider<CurieProvider> curieProvider;
    private final ObjectProvider<HalFormsConfiguration> halFormsConfiguration;
    private final MessageSourceAccessor messageSourceAccessor;

    @Bean
    LinkDiscoverer halFormsLinkDiscoverer() {
        return new HalFormsLinkDiscoverer();
    }

    @Override
    public List<MediaType> getMediaTypes() {
        return EnableHypermediaSupport.HypermediaType.HAL_FORMS.getMediaTypes();
    }

    @Override
    public ObjectMapper configureObjectMapper(ObjectMapper mapper) {
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapper.registerModule((Module)new Jackson2HalFormsModule());
        mapper.setHandlerInstantiator((HandlerInstantiator)new Jackson2HalFormsModule.HalFormsHandlerInstantiator((LinkRelationProvider)this.relProvider, (CurieProvider)this.curieProvider.getIfAvailable(), this.messageSourceAccessor, true, (HalFormsConfiguration)this.halFormsConfiguration.getIfAvailable(HalFormsConfiguration::new)));
        return mapper;
    }

    @Generated
    public HalFormsMediaTypeConfiguration(DelegatingLinkRelationProvider relProvider, ObjectProvider<CurieProvider> curieProvider, ObjectProvider<HalFormsConfiguration> halFormsConfiguration, MessageSourceAccessor messageSourceAccessor) {
        this.relProvider = relProvider;
        this.curieProvider = curieProvider;
        this.halFormsConfiguration = halFormsConfiguration;
        this.messageSourceAccessor = messageSourceAccessor;
    }
}

