/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas;

import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.LinkRelation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class Links
implements Iterable<Link> {
    public static final Links NONE = new Links(Collections.emptyList());
    private static final Pattern LINK_HEADER_PATTERN = Pattern.compile("(<[^>]*>(;\\s*\\w+=\"[^\"]*\")+)");
    private final List<Link> links;

    private Links(Iterable<Link> links) {
        Assert.notNull(links, (String)"Links must not be null!");
        this.links = StreamSupport.stream(links.spliterator(), false).collect(Collectors.toList());
    }

    private Links(Link ... links) {
        this(Arrays.asList(links));
    }

    public static Links of(Link ... links) {
        return new Links(links);
    }

    public static Links of(Iterable<Link> links) {
        return Links.class.isInstance(links) ? (Links)Links.class.cast(links) : new Links(links);
    }

    @Deprecated
    public static Links valueOf(String source) {
        return Links.parse(source);
    }

    public static Links parse(@Nullable String source) {
        if (!StringUtils.hasText((String)source)) {
            return NONE;
        }
        Matcher matcher = LINK_HEADER_PATTERN.matcher(source);
        ArrayList<Link> links = new ArrayList<Link>();
        while (matcher.find()) {
            Link link = Link.valueOf(matcher.group());
            if (link == null) continue;
            links.add(link);
        }
        return new Links(links);
    }

    public Links and(Link ... links) {
        Assert.notNull((Object)links, (String)"Links must not be null!");
        return this.and(Arrays.asList(links));
    }

    @SafeVarargs
    public final Links andIf(boolean condition, Link ... links) {
        return condition ? this.and(links) : this;
    }

    @SafeVarargs
    public final Links andIf(boolean condition, Supplier<Link> ... links) {
        Assert.notNull(links, (String)"Links must not be null!");
        return this.andIf(condition, Stream.of(links).map(Supplier::get));
    }

    public final Links andIf(boolean condition, Stream<Link> links) {
        Assert.notNull(links, (String)"Links must not be null!");
        return condition ? this.and(links.collect(Collectors.toList())) : this;
    }

    public Links and(Iterable<Link> links) {
        ArrayList<Link> newLinks = new ArrayList<Link>(this.links);
        links.forEach(newLinks::add);
        return Links.of(newLinks);
    }

    public Links and(Stream<Link> links) {
        return this.and(links.collect(Collectors.toList()));
    }

    public Links merge(Link ... links) {
        return this.merge(Arrays.asList(links));
    }

    public Links merge(Stream<Link> links) {
        return this.merge(links.collect(Collectors.toList()));
    }

    public Links merge(Iterable<Link> links) {
        return this.merge(MergeMode.SKIP_BY_EQUALITY, links);
    }

    public Links merge(MergeMode mode, Link ... links) {
        return this.merge(mode, Arrays.asList(links));
    }

    public Links merge(MergeMode mode, Stream<Link> links) {
        return this.merge(mode, links.collect(Collectors.toList()));
    }

    public Links merge(MergeMode mode, Iterable<Link> links) {
        Assert.notNull((Object)((Object)mode), (String)"MergeMode must not be null!");
        Assert.notNull(links, (String)"Links must not be null!");
        List<Link> newLinks = MergeMode.REPLACE_BY_REL.equals((Object)mode) ? this.allWithoutRels(links) : new ArrayList<Link>(this.links);
        links.forEach(it -> {
            if (MergeMode.REPLACE_BY_REL.equals((Object)mode)) {
                newLinks.add((Link)it);
            }
            if (MergeMode.SKIP_BY_EQUALITY.equals((Object)mode) && !this.links.contains(it)) {
                newLinks.add((Link)it);
            }
            if (MergeMode.SKIP_BY_REL.equals((Object)mode) && !this.hasLink(it.getRel())) {
                newLinks.add((Link)it);
            }
        });
        return new Links(newLinks);
    }

    public Links without(LinkRelation relation) {
        Assert.notNull((Object)relation, (String)"LinkRelation must not be null!");
        return this.links.stream().filter(it -> !it.hasRel(relation)).collect(Links.collector());
    }

    public Optional<Link> getLink(String relation) {
        return this.getLink(LinkRelation.of(relation));
    }

    public Optional<Link> getLink(LinkRelation rel) {
        return this.links.stream().filter(it -> it.hasRel(rel)).findFirst();
    }

    public Link getRequiredLink(String rel) {
        return this.getRequiredLink(LinkRelation.of(rel));
    }

    public Link getRequiredLink(LinkRelation relation) {
        return this.getLink(relation).orElseThrow(() -> new IllegalArgumentException(String.format("Couldn't find link with rel '%s'!", relation)));
    }

    public boolean hasLink(String relation) {
        return this.getLink(relation).isPresent();
    }

    public boolean hasLink(LinkRelation relation) {
        return this.getLink(relation).isPresent();
    }

    public boolean isEmpty() {
        return this.links.isEmpty();
    }

    public boolean hasSize(long size) {
        return (long)this.links.size() == size;
    }

    public boolean hasSingleLink() {
        return this.hasSize(1L);
    }

    public Stream<Link> stream() {
        return this.links.stream();
    }

    @JsonValue
    public List<Link> toList() {
        return this.links;
    }

    public boolean contains(Link ... links) {
        return this.links.containsAll(Links.of(links).toList());
    }

    public boolean contains(Iterable<Link> links) {
        return this.links.containsAll(Links.of(links).toList());
    }

    public boolean containsSameLinksAs(Iterable<Link> links) {
        Links other = Links.of(links);
        return this.links.size() != other.links.size() ? false : this.links.containsAll(other.links);
    }

    public static Collector<Link, ?, Links> collector() {
        return Collectors.collectingAndThen(Collectors.toList(), Links::of);
    }

    public String toString() {
        return StringUtils.collectionToCommaDelimitedString(this.links);
    }

    @Override
    public Iterator<Link> iterator() {
        return this.links.iterator();
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof Links)) {
            return false;
        }
        Links that = (Links)obj;
        return this.links.equals(that.links);
    }

    public int hashCode() {
        int result = 17;
        return result += 31 * this.links.hashCode();
    }

    private List<Link> allWithoutRels(Iterable<Link> links) {
        Set toFilter = StreamSupport.stream(links.spliterator(), false).map(Link::getRel).collect(Collectors.toSet());
        return this.links.stream().filter(it -> !toFilter.contains(it.getRel())).collect(Collectors.toList());
    }

    public static enum MergeMode {
        SKIP_BY_EQUALITY,
        SKIP_BY_REL,
        REPLACE_BY_REL;

    }
}

