/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.hal.forms;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.std.ContainerDeserializerBase;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.http.MediaType;
import org.springframework.lang.Nullable;

class HalFormsDeserializers {
    HalFormsDeserializers() {
    }

    static class MediaTypesDeserializer
    extends ContainerDeserializerBase<List<MediaType>> {
        private static final long serialVersionUID = -7218376603548438390L;

        public MediaTypesDeserializer() {
            super((JavaType)TypeFactory.defaultInstance().constructCollectionLikeType(List.class, MediaType.class));
        }

        @Nullable
        public JavaType getContentType() {
            return null;
        }

        @Nullable
        public JsonDeserializer<Object> getContentDeserializer() {
            return null;
        }

        public List<MediaType> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return MediaType.parseMediaTypes((String)p.getText());
        }
    }

    static class HalFormsCollectionModelDeserializer
    extends ContainerDeserializerBase<List<Object>>
    implements ContextualDeserializer {
        private static final long serialVersionUID = -7325599536381465624L;
        private JavaType contentType;

        HalFormsCollectionModelDeserializer(JavaType contentType) {
            super(contentType);
            this.contentType = contentType;
        }

        HalFormsCollectionModelDeserializer() {
            this((JavaType)TypeFactory.defaultInstance().constructCollectionLikeType(List.class, Object.class));
        }

        public List<Object> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            ArrayList<Object> result = new ArrayList<Object>();
            JsonDeserializer deser = ctxt.findRootValueDeserializer(this.contentType);
            while (!JsonToken.END_OBJECT.equals((Object)jp.nextToken())) {
                Object object;
                if (!JsonToken.FIELD_NAME.equals((Object)jp.getCurrentToken())) {
                    throw new JsonParseException(jp, "Expected relation name");
                }
                if (JsonToken.START_ARRAY.equals((Object)jp.nextToken())) {
                    while (!JsonToken.END_ARRAY.equals((Object)jp.nextToken())) {
                        object = deser.deserialize(jp, ctxt);
                        result.add(object);
                    }
                    continue;
                }
                object = deser.deserialize(jp, ctxt);
                result.add(object);
            }
            return result;
        }

        public JavaType getContentType() {
            return this.contentType;
        }

        @Nullable
        public JsonDeserializer<Object> getContentDeserializer() {
            return null;
        }

        public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
            return new HalFormsCollectionModelDeserializer(property == null ? ctxt.getContextualType() : property.getType().getContentType());
        }
    }
}

