/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Links;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.util.Assert;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.SerializationFeature;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.annotation.JsonSerialize;
import tools.jackson.databind.ser.impl.UnknownSerializer;
import tools.jackson.databind.ser.jackson.JsonValueSerializer;
import tools.jackson.databind.ser.std.StdSerializer;
import tools.jackson.databind.util.NameTransformer;

public class EntityModel<T>
extends RepresentationModel<EntityModel<T>> {
    private @Nullable T content;

    protected EntityModel() {
        this.content = null;
    }

    protected EntityModel(T content) {
        this(content, Links.NONE);
    }

    protected EntityModel(T content, Iterable<Link> links) {
        Assert.notNull(content, (String)"Content must not be null!");
        Assert.isTrue((!(content instanceof Collection) ? 1 : 0) != 0, (String)"Content must not be a collection! Use CollectionModel instead!");
        this.content = content;
        this.add(links);
    }

    public static <T> EntityModel<T> of(T content) {
        return EntityModel.of(content, Collections.emptyList());
    }

    public static <T> EntityModel<T> of(T content, Link ... links) {
        return EntityModel.of(content, Arrays.asList(links));
    }

    public static <T> EntityModel<T> of(T content, Iterable<Link> links) {
        return new EntityModel<T>(content, links);
    }

    @JsonUnwrapped
    @JsonSerialize(using=MapSuppressingUnwrappingSerializer.class)
    public T getContent() {
        return Objects.requireNonNull(this.content);
    }

    @JsonAnyGetter
    private @Nullable Map<String, Object> getMapContent() {
        return Map.class.isInstance(this.content) ? (Map)this.content : null;
    }

    @JsonAnySetter
    private void setPropertiesAsMap(String key, Object value) {
        this.getOrInitAsMap().put(key, value);
    }

    private Map<String, Object> getOrInitAsMap() {
        if (this.content == null) {
            this.content = new LinkedHashMap();
        } else {
            Assert.state((boolean)Map.class.isInstance(this.content), (String)"Content is not a Map!");
        }
        return (Map)this.content;
    }

    @Override
    public String toString() {
        return String.format("EntityModel { content: %s, %s }", this.getContent(), super.toString());
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        EntityModel that = (EntityModel)obj;
        return super.equals(obj) && Objects.equals(this.content, that.content);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Objects.hash(this.content);
    }

    private static class MapSuppressingUnwrappingSerializer
    extends StdSerializer<Object> {
        private final @Nullable BeanProperty property;

        public MapSuppressingUnwrappingSerializer() {
            this(null);
        }

        private MapSuppressingUnwrappingSerializer(@Nullable BeanProperty property) {
            super(Object.class);
            this.property = property;
        }

        public void serialize(@Nullable Object value, @Nullable JsonGenerator gen, @Nullable SerializationContext provider) {
            if (value == null || Map.class.isInstance(value) || provider == null) {
                return;
            }
            ValueSerializer serializer = provider.findValueSerializer(value.getClass());
            if (UnknownSerializer.class.isInstance(serializer) && !provider.isEnabled(SerializationFeature.FAIL_ON_EMPTY_BEANS)) {
                return;
            }
            if (JsonValueSerializer.class.isInstance(serializer)) {
                throw new IllegalStateException("@JsonValue rendered classes can not be directly nested in EntityModel as they do not produce a document key!");
            }
            serializer = serializer.createContextual(provider, this.property);
            serializer.unwrappingSerializer(NameTransformer.NOP).serialize(value, gen, provider);
        }

        public ValueSerializer<?> createContextual(@Nullable SerializationContext prov, @Nullable BeanProperty property) {
            return new MapSuppressingUnwrappingSerializer(property);
        }

        public boolean isUnwrappingSerializer() {
            return true;
        }
    }
}

