/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.config;

import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.springframework.hateoas.config.HypermediaMappingInformation;
import org.springframework.http.MediaType;
import org.springframework.http.codec.JacksonCodecSupport;
import tools.jackson.databind.json.JsonMapper;

class WebfluxCodecCustomizer
implements Consumer<Object> {
    private static final MediaType ANY_JSON = MediaType.parseMediaType((String)"application/*+json");
    private final List<HypermediaMappingInformation> mappingInformations;
    private final JsonMapper mapper;
    private final boolean withGenericJsonTypes;

    public WebfluxCodecCustomizer(List<HypermediaMappingInformation> mappingInformations, JsonMapper mapper) {
        this(mappingInformations, mapper, false);
    }

    private WebfluxCodecCustomizer(List<HypermediaMappingInformation> mappingInformations, JsonMapper mapper, boolean withGenericJsonTypes) {
        this.mappingInformations = mappingInformations;
        this.mapper = mapper;
        this.withGenericJsonTypes = withGenericJsonTypes;
    }

    WebfluxCodecCustomizer withGenericJsonTypes() {
        return new WebfluxCodecCustomizer(this.mappingInformations, this.mapper, true);
    }

    @Override
    public void accept(@Nullable Object it) {
        if (it == null || !JacksonCodecSupport.class.isInstance(it)) {
            return;
        }
        JacksonCodecSupport codec = (JacksonCodecSupport)it;
        JsonMapper firstMapper = null;
        for (HypermediaMappingInformation information : this.mappingInformations) {
            JsonMapper configured = information.configureJsonMapper(this.mapper.rebuild()).build();
            if (firstMapper == null) {
                firstMapper = configured;
            }
            for (MediaType mediaType : information.getMediaTypes()) {
                codec.registerMappersForType(information.getRootType(), map -> map.put(mediaType, configured));
            }
        }
        if (!this.withGenericJsonTypes) {
            return;
        }
        Class<?> type = this.mappingInformations.get(0).getRootType();
        JsonMapper mapper = firstMapper;
        codec.registerMappersForType(type, map -> Stream.of(MediaType.APPLICATION_JSON, ANY_JSON).forEach(mediaType -> map.put(mediaType, mapper)));
    }
}

