/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype;

import java.util.HashMap;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.util.Assert;
import tools.jackson.databind.DeserializationConfig;
import tools.jackson.databind.KeyDeserializer;
import tools.jackson.databind.SerializationConfig;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.cfg.HandlerInstantiator;
import tools.jackson.databind.cfg.MapperConfig;
import tools.jackson.databind.introspect.Annotated;
import tools.jackson.databind.jsontype.TypeIdResolver;
import tools.jackson.databind.jsontype.TypeResolverBuilder;
import tools.jackson.databind.ser.VirtualBeanPropertyWriter;

public class ConfigurableHandlerInstantiator
extends HandlerInstantiator {
    private final Map<Class<?>, Object> instances = new HashMap();
    private final AutowireCapableBeanFactory beanFactory;

    protected ConfigurableHandlerInstantiator(AutowireCapableBeanFactory beanFactory) {
        Assert.notNull((Object)beanFactory, (String)"BeanFactory must not be null!");
        this.beanFactory = beanFactory;
    }

    protected void registerInstance(Object instance) {
        this.instances.put(instance.getClass(), instance);
    }

    protected <T> @Nullable T findInstance(Class<T> type) {
        return (T)this.instances.get(type);
    }

    protected <T> T findOrCreateInstance(Class<T> type) {
        T object = this.findInstance(type);
        return (T)(object != null ? object : this.beanFactory.getBeanProvider(type).getIfAvailable(() -> this.beanFactory.createBean(type)));
    }

    public ValueDeserializer<?> deserializerInstance(DeserializationConfig config, Annotated annotated, Class<?> deserClass) {
        return (ValueDeserializer)this.findOrCreateInstance(deserClass);
    }

    public KeyDeserializer keyDeserializerInstance(DeserializationConfig config, Annotated annotated, Class<?> keyDeserClass) {
        return (KeyDeserializer)this.findOrCreateInstance(keyDeserClass);
    }

    public ValueSerializer<?> serializerInstance(SerializationConfig config, Annotated annotated, Class<?> serClass) {
        return (ValueSerializer)this.findOrCreateInstance(serClass);
    }

    public TypeResolverBuilder<?> typeResolverBuilderInstance(MapperConfig<?> config, Annotated annotated, Class<?> builderClass) {
        return (TypeResolverBuilder)this.findOrCreateInstance(builderClass);
    }

    public TypeIdResolver typeIdResolverInstance(MapperConfig<?> config, Annotated annotated, Class<?> resolverClass) {
        return (TypeIdResolver)this.findOrCreateInstance(resolverClass);
    }

    public VirtualBeanPropertyWriter virtualPropertyWriterInstance(MapperConfig<?> config, Class<?> implClass) {
        return (VirtualBeanPropertyWriter)this.findOrCreateInstance(implClass);
    }
}

