/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.hal.forms;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Collection;
import org.jspecify.annotations.Nullable;
import org.springframework.hateoas.Link;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public interface HalFormsOptions {
    @SafeVarargs
    public static <T> Inline inline(T ... values) {
        Assert.notNull(values, (String)"Values must not be null!");
        return HalFormsOptions.inline(Arrays.asList(values));
    }

    public static Inline inline(Collection<? extends Object> values) {
        Assert.notNull(values, (String)"Values must not be null!");
        return new Inline(values, null, null, null, null, null);
    }

    public static Remote remote(Link link) {
        Assert.notNull((Object)link, (String)"Link must not be null!");
        return new Remote(link, null, null, null, null, null);
    }

    public static Remote remote(String href) {
        Assert.hasText((String)href, (String)"Href must not by null or empty!");
        return HalFormsOptions.remote(Link.of(href));
    }

    public @Nullable String getPromptField();

    public @Nullable String getValueField();

    public @Nullable Long getMinItems();

    public @Nullable Long getMaxItems();

    public @Nullable Object getSelectedValue();

    public static class Inline
    extends AbstractHalFormsOptions<Inline> {
        private final Collection<? extends Object> inline;

        private Inline(Collection<? extends Object> values, @Nullable String promptRef, @Nullable String valueRef, @Nullable Long minItems, @Nullable Long maxItems, @Nullable Object selectedValue) {
            super(promptRef, valueRef, minItems, maxItems, selectedValue);
            Assert.notNull(values, (String)"Values must not be null!");
            this.inline = values;
        }

        @JsonProperty
        public Collection<? extends Object> getInline() {
            return this.inline;
        }

        @Override
        protected Inline with(@Nullable String promptRef, @Nullable String valueRef, @Nullable Long minItems, @Nullable Long maxItems, @Nullable Object selectedValue) {
            return new Inline(this.inline, promptRef, valueRef, minItems, maxItems, selectedValue);
        }
    }

    public static class Remote
    extends AbstractHalFormsOptions<Remote> {
        private final Link link;

        private Remote(Link link, @Nullable String promptRef, @Nullable String valueRef, @Nullable Long minItems, @Nullable Long maxItems, @Nullable Object selectedValue) {
            super(promptRef, valueRef, minItems, maxItems, selectedValue);
            Assert.notNull((Object)link, (String)"Link must not be null!");
            this.link = link;
        }

        @JsonProperty
        public Link getLink() {
            return this.link;
        }

        @Override
        protected Remote with(@Nullable String promptRef, @Nullable String valueRef, @Nullable Long minItems, @Nullable Long maxItems, @Nullable Object selectedValue) {
            return new Remote(this.link, promptRef, valueRef, minItems, maxItems, selectedValue);
        }
    }

    public static abstract class AbstractHalFormsOptions<T extends AbstractHalFormsOptions<T>>
    implements HalFormsOptions {
        private final @Nullable String promptField;
        private final @Nullable String valueField;
        private final @Nullable Long minItems;
        private final @Nullable Long maxItems;
        private final @Nullable Object selectedValue;

        protected AbstractHalFormsOptions(@Nullable String promptRef, @Nullable String valueRef, @Nullable Long minItems, @Nullable Long maxItems, @Nullable Object selectedValue) {
            Assert.isTrue((minItems == null || minItems >= 0L ? 1 : 0) != 0, (String)"MinItems must be greater than or equal to 0!");
            this.promptField = promptRef;
            this.valueField = valueRef;
            this.minItems = minItems;
            this.maxItems = maxItems;
            this.selectedValue = selectedValue;
        }

        @Override
        @JsonProperty
        public @Nullable String getPromptField() {
            return this.promptField;
        }

        @Override
        @JsonProperty
        public @Nullable String getValueField() {
            return this.valueField;
        }

        @Override
        @JsonProperty
        public @Nullable Long getMinItems() {
            return this.minItems;
        }

        @Override
        @JsonProperty
        public @Nullable Long getMaxItems() {
            return this.maxItems;
        }

        @Override
        @JsonIgnore
        public @Nullable Object getSelectedValue() {
            return this.selectedValue;
        }

        public T withPromptField(String promptField) {
            if (promptField != null && !StringUtils.hasText((String)promptField)) {
                throw new IllegalArgumentException("Prompt field has to either be null or actually have text!");
            }
            return this.with(promptField, this.valueField, this.minItems, this.maxItems, this.selectedValue);
        }

        public T withValueField(String valueField) {
            if (valueField != null && !StringUtils.hasText((String)valueField)) {
                throw new IllegalArgumentException("Value field has to either be null or actually have text!");
            }
            return this.with(this.promptField, valueField, this.minItems, this.maxItems, this.selectedValue);
        }

        public T withMinItems(Long minItems) {
            if (minItems != null && minItems < 0L) {
                throw new IllegalArgumentException("minItems has to be null or greater or equal to zero!");
            }
            return this.with(this.promptField, this.valueField, minItems, this.maxItems, this.selectedValue);
        }

        public T withMaxItems(@Nullable Long maxItems) {
            if (maxItems != null && maxItems <= 0L) {
                throw new IllegalArgumentException("maxItems has to be null or greater than zero!");
            }
            return this.with(this.promptField, this.valueField, this.minItems, maxItems, this.selectedValue);
        }

        public T withSelectedValue(@Nullable Object value) {
            return this.with(this.promptField, this.valueField, this.minItems, this.maxItems, value);
        }

        protected abstract T with(@Nullable String var1, @Nullable String var2, @Nullable Long var3, @Nullable Long var4, @Nullable Object var5);
    }
}

