/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.amqp.outbound;

import java.util.Map;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.core.MessagePostProcessor;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.SpelParserConfiguration;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.integration.Message;
import org.springframework.integration.amqp.support.AmqpHeaderMapper;
import org.springframework.integration.amqp.support.DefaultAmqpHeaderMapper;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.handler.ExpressionEvaluatingMessageProcessor;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmqpOutboundEndpoint
extends AbstractReplyProducingMessageHandler {
    private static final ExpressionParser expressionParser = new SpelExpressionParser(new SpelParserConfiguration(true, true));
    private final AmqpTemplate amqpTemplate;
    private volatile boolean expectReply;
    private volatile String exchangeName = "";
    private volatile String routingKey = "";
    private volatile String exchangeNameExpression;
    private volatile String routingKeyExpression;
    private volatile ExpressionEvaluatingMessageProcessor<String> routingKeyGenerator;
    private volatile ExpressionEvaluatingMessageProcessor<String> exchangeNameGenerator;
    private volatile AmqpHeaderMapper headerMapper = new DefaultAmqpHeaderMapper();

    protected void onInit() {
        Expression expression;
        super.onInit();
        Assert.state((this.exchangeNameExpression == null || "".equals(this.exchangeName) ? 1 : 0) != 0, (String)"Either an exchangeName or an exchangeNameExpression can be provided, but not both");
        if (this.exchangeNameExpression != null) {
            expression = expressionParser.parseExpression(this.exchangeNameExpression);
            this.exchangeNameGenerator = new ExpressionEvaluatingMessageProcessor(expression, String.class);
        }
        Assert.state((this.routingKeyExpression == null || "".equals(this.routingKey) ? 1 : 0) != 0, (String)"Either a routingKey or a routingKeyExpression can be provided, but not both");
        if (this.routingKeyExpression != null) {
            expression = expressionParser.parseExpression(this.routingKeyExpression);
            this.routingKeyGenerator = new ExpressionEvaluatingMessageProcessor(expression, String.class);
        }
    }

    public AmqpOutboundEndpoint(AmqpTemplate amqpTemplate) {
        Assert.notNull((Object)amqpTemplate, (String)"AmqpTemplate must not be null");
        this.amqpTemplate = amqpTemplate;
    }

    public void setHeaderMapper(AmqpHeaderMapper headerMapper) {
        this.headerMapper = headerMapper;
    }

    public void setExchangeName(String exchangeName) {
        this.exchangeName = exchangeName;
    }

    public void setExchangeNameExpression(String exchangeNameExpression) {
        this.exchangeNameExpression = exchangeNameExpression;
    }

    public void setRoutingKey(String routingKey) {
        this.routingKey = routingKey;
    }

    public void setRoutingKeyExpression(String routingKeyExpression) {
        this.routingKeyExpression = routingKeyExpression;
    }

    public void setExpectReply(boolean expectReply) {
        this.expectReply = expectReply;
    }

    public String getComponentType() {
        return this.expectReply ? "amqp:outbound-channel-adapter" : "amqp:outbound-gateway";
    }

    protected Object handleRequestMessage(Message<?> requestMessage) {
        String exchangeName = this.exchangeName;
        String routingKey = this.routingKey;
        if (this.exchangeNameGenerator != null) {
            exchangeName = (String)this.exchangeNameGenerator.processMessage(requestMessage);
        }
        if (this.routingKeyGenerator != null) {
            routingKey = (String)this.routingKeyGenerator.processMessage(requestMessage);
        }
        if (this.expectReply) {
            return this.sendAndReceive(exchangeName, routingKey, requestMessage);
        }
        this.send(exchangeName, routingKey, requestMessage);
        return null;
    }

    private void send(String exchangeName, String routingKey, final Message<?> requestMessage) {
        this.amqpTemplate.convertAndSend(exchangeName, routingKey, requestMessage.getPayload(), new MessagePostProcessor(){

            public org.springframework.amqp.core.Message postProcessMessage(org.springframework.amqp.core.Message message) throws AmqpException {
                AmqpOutboundEndpoint.this.headerMapper.fromHeadersToRequest(requestMessage.getHeaders(), message.getMessageProperties());
                return message;
            }
        });
    }

    private Message<?> sendAndReceive(String exchangeName, String routingKey, Message<?> requestMessage) {
        Assert.isTrue((boolean)(this.amqpTemplate instanceof RabbitTemplate), (String)"RabbitTemplate implementation is required for send and receive");
        MessageConverter converter = ((RabbitTemplate)this.amqpTemplate).getMessageConverter();
        MessageProperties amqpMessageProperties = new MessageProperties();
        this.headerMapper.fromHeadersToRequest(requestMessage.getHeaders(), amqpMessageProperties);
        org.springframework.amqp.core.Message amqpMessage = converter.toMessage(requestMessage.getPayload(), amqpMessageProperties);
        org.springframework.amqp.core.Message amqpReplyMessage = this.amqpTemplate.sendAndReceive(exchangeName, routingKey, amqpMessage);
        if (amqpReplyMessage == null) {
            return null;
        }
        Object replyObject = converter.fromMessage(amqpReplyMessage);
        MessageBuilder builder = replyObject instanceof Message ? MessageBuilder.fromMessage((Message)((Message)replyObject)) : MessageBuilder.withPayload((Object)replyObject);
        Map headers = this.headerMapper.toHeadersFromReply(amqpReplyMessage.getMessageProperties());
        builder.copyHeadersIfAbsent(headers);
        return builder.build();
    }
}

