/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.amqp.channel;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.amqp.core.AmqpAdmin;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.core.MessageListener;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.amqp.support.converter.SimpleMessageConverter;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.SmartLifecycle;
import org.springframework.integration.Message;
import org.springframework.integration.MessageDeliveryException;
import org.springframework.integration.MessageDispatchingException;
import org.springframework.integration.MessagingException;
import org.springframework.integration.amqp.channel.AbstractAmqpChannel;
import org.springframework.integration.core.MessageHandler;
import org.springframework.integration.core.SubscribableChannel;
import org.springframework.integration.dispatcher.AbstractDispatcher;
import org.springframework.integration.dispatcher.MessageDispatcher;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.util.Assert;

abstract class AbstractSubscribableAmqpChannel
extends AbstractAmqpChannel
implements SubscribableChannel,
SmartLifecycle,
DisposableBean {
    private final String channelName;
    private final SimpleMessageListenerContainer container;
    private volatile AbstractDispatcher dispatcher;
    private final boolean isPubSub;
    private volatile Integer maxSubscribers;

    public AbstractSubscribableAmqpChannel(String channelName, SimpleMessageListenerContainer container, AmqpTemplate amqpTemplate) {
        this(channelName, container, amqpTemplate, false);
    }

    public AbstractSubscribableAmqpChannel(String channelName, SimpleMessageListenerContainer container, AmqpTemplate amqpTemplate, boolean isPubSub) {
        super(amqpTemplate);
        Assert.notNull((Object)container, (String)"container must not be null");
        Assert.hasText((String)channelName, (String)"channel name must not be empty");
        this.channelName = channelName;
        this.container = container;
        this.isPubSub = isPubSub;
    }

    public void setMaxSubscribers(int maxSubscribers) {
        this.maxSubscribers = maxSubscribers;
        if (this.dispatcher != null) {
            this.dispatcher.setMaxSubscribers(this.maxSubscribers.intValue());
        }
    }

    public boolean subscribe(MessageHandler handler) {
        return this.dispatcher.addHandler(handler);
    }

    public boolean unsubscribe(MessageHandler handler) {
        return this.dispatcher.removeHandler(handler);
    }

    public void onInit() throws Exception {
        super.onInit();
        this.dispatcher = this.createDispatcher();
        if (this.maxSubscribers == null) {
            this.maxSubscribers = (Integer)this.getIntegrationProperty(this.isPubSub ? "channels.maxBroadcastSubscribers" : "channels.maxUnicastSubscribers", Integer.class);
        }
        this.setMaxSubscribers(this.maxSubscribers);
        RabbitAdmin admin = new RabbitAdmin(this.container.getConnectionFactory());
        Queue queue = this.initializeQueue((AmqpAdmin)admin, this.channelName);
        this.container.setQueues(new Queue[]{queue});
        SimpleMessageConverter converter = this.getAmqpTemplate() instanceof RabbitTemplate ? ((RabbitTemplate)this.getAmqpTemplate()).getMessageConverter() : new SimpleMessageConverter();
        DispatchingMessageListener listener = new DispatchingMessageListener((MessageConverter)converter, (MessageDispatcher)this.dispatcher, this, this.isPubSub);
        this.container.setMessageListener((Object)listener);
        if (!this.container.isActive()) {
            this.container.afterPropertiesSet();
        }
    }

    protected abstract AbstractDispatcher createDispatcher();

    protected abstract Queue initializeQueue(AmqpAdmin var1, String var2);

    public boolean isAutoStartup() {
        return this.container != null ? this.container.isAutoStartup() : false;
    }

    public int getPhase() {
        return this.container != null ? this.container.getPhase() : 0;
    }

    public boolean isRunning() {
        return this.container != null ? this.container.isRunning() : false;
    }

    public void start() {
        if (this.container != null) {
            this.container.start();
        }
    }

    public void stop() {
        if (this.container != null) {
            this.container.stop();
        }
    }

    public void stop(Runnable callback) {
        if (this.container != null) {
            this.container.stop(callback);
        }
    }

    public void destroy() throws Exception {
        if (this.container != null) {
            this.container.destroy();
        }
    }

    private static class DispatchingMessageListener
    implements MessageListener {
        private final Log logger = LogFactory.getLog(this.getClass());
        private final MessageDispatcher dispatcher;
        private final MessageConverter converter;
        private final AbstractSubscribableAmqpChannel channel;
        private final boolean isPubSub;

        private DispatchingMessageListener(MessageConverter converter, MessageDispatcher dispatcher, AbstractSubscribableAmqpChannel channel, boolean isPubSub) {
            Assert.notNull((Object)converter, (String)"MessageConverter must not be null");
            Assert.notNull((Object)dispatcher, (String)"MessageDispatcher must not be null");
            this.converter = converter;
            this.dispatcher = dispatcher;
            this.channel = channel;
            this.isPubSub = isPubSub;
        }

        public void onMessage(org.springframework.amqp.core.Message message) {
            Message messageToSend = null;
            try {
                Object converted = this.converter.fromMessage(message);
                if (converted != null) {
                    messageToSend = converted instanceof Message ? (Message)converted : MessageBuilder.withPayload((Object)converted).build();
                    this.dispatcher.dispatch(messageToSend);
                } else if (this.logger.isWarnEnabled()) {
                    this.logger.warn((Object)"MessageConverter returned null, no Message to dispatch");
                }
            }
            catch (MessageDispatchingException e) {
                String exceptionMessage = e.getMessage() + " for amqp-channel '" + this.channel.getFullChannelName() + "'.";
                if (this.isPubSub) {
                    if (this.logger.isWarnEnabled()) {
                        this.logger.warn((Object)exceptionMessage, (Throwable)e);
                    }
                }
                throw new MessageDeliveryException(messageToSend, exceptionMessage, (Throwable)e);
            }
            catch (Exception e) {
                throw new MessagingException("Failure occured in AMQP listener while attempting to convert and dispatch Message.", (Throwable)e);
            }
        }
    }
}

