/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.amqp.channel;

import org.springframework.amqp.core.AmqpAdmin;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.integration.Message;
import org.springframework.integration.MessageChannel;
import org.springframework.integration.amqp.channel.AbstractAmqpChannel;
import org.springframework.integration.core.PollableChannel;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.util.Assert;

public class PollableAmqpChannel
extends AbstractAmqpChannel
implements PollableChannel {
    private final String channelName;
    private volatile String queueName;
    private volatile AmqpAdmin amqpAdmin;

    public PollableAmqpChannel(String channelName, AmqpTemplate amqpTemplate) {
        super(amqpTemplate);
        Assert.hasText((String)channelName, (String)"channel name must not be empty");
        this.channelName = channelName;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public void setAmqpAdmin(AmqpAdmin amqpAdmin) {
        this.amqpAdmin = amqpAdmin;
    }

    protected void onInit() throws Exception {
        AmqpTemplate amqpTemplate = this.getAmqpTemplate();
        if (this.queueName == null) {
            if (this.amqpAdmin == null && amqpTemplate instanceof RabbitTemplate) {
                this.amqpAdmin = new RabbitAdmin(((RabbitTemplate)amqpTemplate).getConnectionFactory());
            }
            Assert.notNull((Object)this.amqpAdmin, (String)"If no queueName is configured explicitly, an AmqpAdmin instance must be provided, or the AmqpTemplate must be a RabbitTemplate since the Queue needs to be declared.");
            this.queueName = this.channelName;
            this.amqpAdmin.declareQueue(new Queue(this.queueName));
        }
    }

    @Override
    protected String getRoutingKey() {
        return this.queueName;
    }

    public Message<?> receive() {
        if (!this.getInterceptors().preReceive((MessageChannel)this)) {
            return null;
        }
        Object object = this.getAmqpTemplate().receiveAndConvert(this.queueName);
        if (object == null) {
            return null;
        }
        Message replyMessage = null;
        replyMessage = object instanceof Message ? (Message)object : MessageBuilder.withPayload((Object)object).build();
        return this.getInterceptors().postReceive(replyMessage, (MessageChannel)this);
    }

    public Message<?> receive(long timeout) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)"Calling receive with a timeout value on PollableAmqpChannel. The timeout will be ignored since no receive timeout is supported.");
        }
        return this.receive();
    }
}

