/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.amqp.support;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.amqp.core.MessageDeliveryMode;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.integration.amqp.support.AmqpHeaderMapper;
import org.springframework.integration.mapping.AbstractHeaderMapper;
import org.springframework.integration.mapping.support.JsonHeaders;
import org.springframework.util.StringUtils;

public class DefaultAmqpHeaderMapper
extends AbstractHeaderMapper<MessageProperties>
implements AmqpHeaderMapper {
    private static final List<String> STANDARD_HEADER_NAMES = new ArrayList<String>();

    protected Map<String, Object> extractStandardHeaders(MessageProperties amqpMessageProperties) {
        HashMap<String, Object> headers;
        block24: {
            headers = new HashMap<String, Object>();
            try {
                Object replyToStack;
                String userId;
                String type;
                Date timestamp;
                String replyTo;
                Boolean redelivered;
                String receivedRoutingKey;
                String receivedExchange;
                Integer priority;
                String messageId;
                Integer messageCount;
                String expiration;
                long deliveryTag;
                MessageDeliveryMode deliveryMode;
                byte[] correlationId;
                String contentType;
                long contentLength;
                String contentEncoding;
                String clusterId;
                String appId = amqpMessageProperties.getAppId();
                if (StringUtils.hasText((String)appId)) {
                    headers.put("amqp_appId", appId);
                }
                if (StringUtils.hasText((String)(clusterId = amqpMessageProperties.getClusterId()))) {
                    headers.put("amqp_clusterId", clusterId);
                }
                if (StringUtils.hasText((String)(contentEncoding = amqpMessageProperties.getContentEncoding()))) {
                    headers.put("amqp_contentEncoding", contentEncoding);
                }
                if ((contentLength = amqpMessageProperties.getContentLength()) > 0L) {
                    headers.put("amqp_contentLength", contentLength);
                }
                if (StringUtils.hasText((String)(contentType = amqpMessageProperties.getContentType()))) {
                    headers.put("content-type", contentType);
                }
                if ((correlationId = amqpMessageProperties.getCorrelationId()) != null && correlationId.length > 0) {
                    headers.put("amqp_correlationId", correlationId);
                }
                if ((deliveryMode = amqpMessageProperties.getDeliveryMode()) != null) {
                    headers.put("amqp_deliveryMode", deliveryMode);
                }
                if ((deliveryTag = amqpMessageProperties.getDeliveryTag()) > 0L) {
                    headers.put("amqp_deliveryTag", deliveryTag);
                }
                if (StringUtils.hasText((String)(expiration = amqpMessageProperties.getExpiration()))) {
                    headers.put("amqp_expiration", expiration);
                }
                if ((messageCount = amqpMessageProperties.getMessageCount()) != null && messageCount > 0) {
                    headers.put("amqp_messageCount", messageCount);
                }
                if (StringUtils.hasText((String)(messageId = amqpMessageProperties.getMessageId()))) {
                    headers.put("amqp_messageId", messageId);
                }
                if ((priority = amqpMessageProperties.getPriority()) != null && priority > 0) {
                    headers.put("priority", priority);
                }
                if (StringUtils.hasText((String)(receivedExchange = amqpMessageProperties.getReceivedExchange()))) {
                    headers.put("amqp_receivedExchange", receivedExchange);
                }
                if (StringUtils.hasText((String)(receivedRoutingKey = amqpMessageProperties.getReceivedRoutingKey()))) {
                    headers.put("amqp_receivedRoutingKey", receivedRoutingKey);
                }
                if ((redelivered = amqpMessageProperties.isRedelivered()) != null) {
                    headers.put("amqp_redelivered", redelivered);
                }
                if ((replyTo = amqpMessageProperties.getReplyTo()) != null) {
                    headers.put("amqp_replyTo", replyTo);
                }
                if ((timestamp = amqpMessageProperties.getTimestamp()) != null) {
                    headers.put("amqp_timestamp", timestamp);
                }
                if (StringUtils.hasText((String)(type = amqpMessageProperties.getType()))) {
                    headers.put("amqp_type", type);
                }
                if (StringUtils.hasText((String)(userId = amqpMessageProperties.getUserId()))) {
                    headers.put("amqp_userId", userId);
                }
                for (String jsonHeader : JsonHeaders.HEADERS) {
                    Object value = amqpMessageProperties.getHeaders().get(jsonHeader.replaceFirst("json", ""));
                    if (!(value instanceof String) || !StringUtils.hasText((String)((String)value))) continue;
                    headers.put(jsonHeader, value);
                }
                Object replyCorrelation = amqpMessageProperties.getHeaders().get("spring_reply_correlation");
                if (replyCorrelation instanceof String && StringUtils.hasText((String)((String)replyCorrelation))) {
                    headers.put("amqp_springReplyCorrelation", replyCorrelation);
                }
                if ((replyToStack = amqpMessageProperties.getHeaders().get("spring_reply_to")) instanceof String && StringUtils.hasText((String)((String)replyToStack))) {
                    headers.put("amqp_springReplyToStack", replyToStack);
                }
            }
            catch (Exception e) {
                if (!this.logger.isWarnEnabled()) break block24;
                this.logger.warn((Object)"error occurred while mapping from AMQP properties to MessageHeaders", (Throwable)e);
            }
        }
        return headers;
    }

    protected Map<String, Object> extractUserDefinedHeaders(MessageProperties amqpMessageProperties) {
        Map headers = amqpMessageProperties.getHeaders();
        headers.remove("spring_reply_correlation");
        headers.remove("spring_reply_to");
        return headers;
    }

    protected void populateStandardHeaders(Map<String, Object> headers, MessageProperties amqpMessageProperties) {
        String replyToStack;
        String userId;
        String type;
        Date timestamp;
        String replyTo;
        Boolean redelivered;
        String receivedRoutingKey;
        String receivedExchange;
        Integer priority;
        String messageId;
        Integer messageCount;
        String expiration;
        Long deliveryTag;
        MessageDeliveryMode deliveryMode;
        Object correlationId;
        String contentType;
        Long contentLength;
        String contentEncoding;
        String clusterId;
        String appId = (String)this.getHeaderIfAvailable(headers, "amqp_appId", String.class);
        if (StringUtils.hasText((String)appId)) {
            amqpMessageProperties.setAppId(appId);
        }
        if (StringUtils.hasText((String)(clusterId = (String)this.getHeaderIfAvailable(headers, "amqp_clusterId", String.class)))) {
            amqpMessageProperties.setClusterId(clusterId);
        }
        if (StringUtils.hasText((String)(contentEncoding = (String)this.getHeaderIfAvailable(headers, "amqp_contentEncoding", String.class)))) {
            amqpMessageProperties.setContentEncoding(contentEncoding);
        }
        if ((contentLength = (Long)this.getHeaderIfAvailable(headers, "amqp_contentLength", Long.class)) != null) {
            amqpMessageProperties.setContentLength(contentLength.longValue());
        }
        if (StringUtils.hasText((String)(contentType = this.extractContentTypeAsString(headers)))) {
            amqpMessageProperties.setContentType(contentType);
        }
        if ((correlationId = headers.get("amqp_correlationId")) instanceof byte[]) {
            amqpMessageProperties.setCorrelationId((byte[])correlationId);
        }
        if ((deliveryMode = (MessageDeliveryMode)this.getHeaderIfAvailable(headers, "amqp_deliveryMode", MessageDeliveryMode.class)) != null) {
            amqpMessageProperties.setDeliveryMode(deliveryMode);
        }
        if ((deliveryTag = (Long)this.getHeaderIfAvailable(headers, "amqp_deliveryTag", Long.class)) != null) {
            amqpMessageProperties.setDeliveryTag(deliveryTag.longValue());
        }
        if (StringUtils.hasText((String)(expiration = (String)this.getHeaderIfAvailable(headers, "amqp_expiration", String.class)))) {
            amqpMessageProperties.setExpiration(expiration);
        }
        if ((messageCount = (Integer)this.getHeaderIfAvailable(headers, "amqp_messageCount", Integer.class)) != null) {
            amqpMessageProperties.setMessageCount(messageCount);
        }
        if (StringUtils.hasText((String)(messageId = (String)this.getHeaderIfAvailable(headers, "amqp_messageId", String.class)))) {
            amqpMessageProperties.setMessageId(messageId);
        }
        if ((priority = (Integer)this.getHeaderIfAvailable(headers, "priority", Integer.class)) != null) {
            amqpMessageProperties.setPriority(priority);
        }
        if (StringUtils.hasText((String)(receivedExchange = (String)this.getHeaderIfAvailable(headers, "amqp_receivedExchange", String.class)))) {
            amqpMessageProperties.setReceivedExchange(receivedExchange);
        }
        if (StringUtils.hasText((String)(receivedRoutingKey = (String)this.getHeaderIfAvailable(headers, "amqp_receivedRoutingKey", String.class)))) {
            amqpMessageProperties.setReceivedRoutingKey(receivedRoutingKey);
        }
        if ((redelivered = (Boolean)this.getHeaderIfAvailable(headers, "amqp_redelivered", Boolean.class)) != null) {
            amqpMessageProperties.setRedelivered(redelivered);
        }
        if ((replyTo = (String)this.getHeaderIfAvailable(headers, "amqp_replyTo", String.class)) != null) {
            amqpMessageProperties.setReplyTo(replyTo);
        }
        if ((timestamp = (Date)this.getHeaderIfAvailable(headers, "amqp_timestamp", Date.class)) != null) {
            amqpMessageProperties.setTimestamp(timestamp);
        }
        if ((type = (String)this.getHeaderIfAvailable(headers, "amqp_type", String.class)) != null) {
            amqpMessageProperties.setType(type);
        }
        if (StringUtils.hasText((String)(userId = (String)this.getHeaderIfAvailable(headers, "amqp_userId", String.class)))) {
            amqpMessageProperties.setUserId(userId);
        }
        for (String jsonHeader : JsonHeaders.HEADERS) {
            Object value = this.getHeaderIfAvailable(headers, jsonHeader, Object.class);
            if (value == null) continue;
            headers.remove(jsonHeader);
            if (value instanceof Class) {
                value = ((Class)value).getName();
            }
            amqpMessageProperties.setHeader(jsonHeader.replaceFirst("json", ""), (Object)value.toString());
        }
        String replyCorrelation = (String)this.getHeaderIfAvailable(headers, "amqp_springReplyCorrelation", String.class);
        if (StringUtils.hasLength((String)replyCorrelation)) {
            amqpMessageProperties.setHeader("spring_reply_correlation", (Object)replyCorrelation);
        }
        if (StringUtils.hasLength((String)(replyToStack = (String)this.getHeaderIfAvailable(headers, "amqp_springReplyToStack", String.class)))) {
            amqpMessageProperties.setHeader("spring_reply_to", (Object)replyToStack);
        }
    }

    protected void populateUserDefinedHeader(String headerName, Object headerValue, MessageProperties amqpMessageProperties) {
        if (!amqpMessageProperties.getHeaders().containsKey(headerName)) {
            amqpMessageProperties.setHeader(headerName, headerValue);
        }
    }

    protected List<String> getStandardRequestHeaderNames() {
        return STANDARD_HEADER_NAMES;
    }

    protected List<String> getStandardReplyHeaderNames() {
        return STANDARD_HEADER_NAMES;
    }

    protected String getStandardHeaderPrefix() {
        return "amqp_";
    }

    private String extractContentTypeAsString(Map<String, Object> headers) {
        String contentTypeStringValue = null;
        Object contentType = this.getHeaderIfAvailable(headers, "content-type", Object.class);
        if (contentType != null) {
            String contentTypeClassName = contentType.getClass().getName();
            if (contentTypeClassName.equals("org.springframework.http.MediaType")) {
                contentTypeStringValue = contentType.toString();
            } else if (contentType instanceof String) {
                contentTypeStringValue = (String)contentType;
            } else if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("skipping header 'content-type' since it is not of expected type [" + contentTypeClassName + "]"));
            }
        }
        return contentTypeStringValue;
    }

    static {
        STANDARD_HEADER_NAMES.add("amqp_appId");
        STANDARD_HEADER_NAMES.add("amqp_clusterId");
        STANDARD_HEADER_NAMES.add("amqp_contentEncoding");
        STANDARD_HEADER_NAMES.add("amqp_contentLength");
        STANDARD_HEADER_NAMES.add("content-type");
        STANDARD_HEADER_NAMES.add("amqp_correlationId");
        STANDARD_HEADER_NAMES.add("amqp_deliveryMode");
        STANDARD_HEADER_NAMES.add("amqp_deliveryTag");
        STANDARD_HEADER_NAMES.add("amqp_expiration");
        STANDARD_HEADER_NAMES.add("amqp_messageCount");
        STANDARD_HEADER_NAMES.add("amqp_messageId");
        STANDARD_HEADER_NAMES.add("amqp_receivedExchange");
        STANDARD_HEADER_NAMES.add("amqp_receivedRoutingKey");
        STANDARD_HEADER_NAMES.add("amqp_redelivered");
        STANDARD_HEADER_NAMES.add("amqp_replyTo");
        STANDARD_HEADER_NAMES.add("amqp_timestamp");
        STANDARD_HEADER_NAMES.add("amqp_type");
        STANDARD_HEADER_NAMES.add("amqp_userId");
        STANDARD_HEADER_NAMES.add("json__TypeId__");
        STANDARD_HEADER_NAMES.add("json__ContentTypeId__");
        STANDARD_HEADER_NAMES.add("json__KeyTypeId__");
        STANDARD_HEADER_NAMES.add("amqp_springReplyCorrelation");
        STANDARD_HEADER_NAMES.add("amqp_springReplyToStack");
    }
}

