/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.amqp.channel;

import org.springframework.amqp.core.AmqpAdmin;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.core.AnonymousQueue;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.FanoutExchange;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.connection.Connection;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionListener;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.integration.amqp.channel.AbstractSubscribableAmqpChannel;
import org.springframework.integration.dispatcher.AbstractDispatcher;
import org.springframework.integration.dispatcher.BroadcastingDispatcher;

public class PublishSubscribeAmqpChannel
extends AbstractSubscribableAmqpChannel
implements ConnectionListener {
    private volatile FanoutExchange exchange;
    private final Queue queue = new AnonymousQueue();
    private volatile Binding binding;
    private volatile boolean initialized;

    public PublishSubscribeAmqpChannel(String channelName, SimpleMessageListenerContainer container, AmqpTemplate amqpTemplate) {
        super(channelName, container, amqpTemplate, true);
    }

    public void setExchange(FanoutExchange exchange) {
        this.exchange = exchange;
    }

    @Override
    protected String obtainQueueName(AmqpAdmin admin, String channelName) {
        ConnectionFactory connectionFactory;
        if (this.exchange == null) {
            String exchangeName = "si.fanout." + channelName;
            this.exchange = new FanoutExchange(exchangeName);
        }
        admin.declareExchange((Exchange)this.exchange);
        admin.declareQueue(this.queue);
        this.binding = BindingBuilder.bind((Queue)this.queue).to(this.exchange);
        admin.declareBinding(this.binding);
        if (!this.initialized && this.getAmqpTemplate() instanceof RabbitTemplate && (connectionFactory = this.getConnectionFactory()) != null) {
            connectionFactory.addConnectionListener((ConnectionListener)this);
        }
        this.initialized = true;
        return this.queue.getName();
    }

    private void doDeclares() {
        AmqpAdmin admin;
        if (this.isRunning() && (admin = this.getAdmin()) != null) {
            if (this.queue != null) {
                admin.declareQueue(this.queue);
            }
            if (this.binding != null) {
                admin.declareBinding(this.binding);
            }
        }
    }

    @Override
    protected AbstractDispatcher createDispatcher() {
        BroadcastingDispatcher broadcastingDispatcher = new BroadcastingDispatcher(true);
        broadcastingDispatcher.setBeanFactory(this.getBeanFactory());
        return broadcastingDispatcher;
    }

    @Override
    protected String getExchangeName() {
        return this.exchange != null ? this.exchange.getName() : "";
    }

    @Override
    public void destroy() throws Exception {
        super.destroy();
        if (this.getConnectionFactory() != null) {
            this.getConnectionFactory().removeConnectionListener((ConnectionListener)this);
            this.initialized = false;
        }
    }

    @Override
    public void start() {
        this.doDeclares();
        super.start();
    }

    public void onCreate(Connection connection) {
        this.doDeclares();
    }

    public void onClose(Connection connection) {
    }
}

