/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.amqp.channel;

import org.springframework.amqp.core.AmqpAdmin;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.integration.amqp.channel.AbstractSubscribableAmqpChannel;
import org.springframework.integration.dispatcher.AbstractDispatcher;
import org.springframework.integration.dispatcher.LoadBalancingStrategy;
import org.springframework.integration.dispatcher.RoundRobinLoadBalancingStrategy;
import org.springframework.integration.dispatcher.UnicastingDispatcher;

public class PointToPointSubscribableAmqpChannel
extends AbstractSubscribableAmqpChannel {
    private volatile String queueName;

    public PointToPointSubscribableAmqpChannel(String channelName, SimpleMessageListenerContainer container, AmqpTemplate amqpTemplate) {
        super(channelName, container, amqpTemplate);
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    @Override
    protected String obtainQueueName(AmqpAdmin admin, String channelName) {
        if (this.queueName == null) {
            this.queueName = channelName;
        }
        if (admin.getQueueProperties(this.queueName) == null) {
            admin.declareQueue(new Queue(this.queueName));
        }
        return this.queueName;
    }

    @Override
    protected AbstractDispatcher createDispatcher() {
        UnicastingDispatcher unicastingDispatcher = new UnicastingDispatcher();
        unicastingDispatcher.setLoadBalancingStrategy((LoadBalancingStrategy)new RoundRobinLoadBalancingStrategy());
        return unicastingDispatcher;
    }

    @Override
    protected String getRoutingKey() {
        return this.queueName;
    }
}

