/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.amqp.inbound;

import com.rabbitmq.client.Channel;
import java.util.Map;
import org.springframework.amqp.core.AcknowledgeMode;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.core.ChannelAwareMessageListener;
import org.springframework.amqp.rabbit.listener.AbstractMessageListenerContainer;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.amqp.support.converter.SimpleMessageConverter;
import org.springframework.integration.amqp.support.AmqpHeaderMapper;
import org.springframework.integration.amqp.support.DefaultAmqpHeaderMapper;
import org.springframework.integration.context.OrderlyShutdownCapable;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.util.Assert;

public class AmqpInboundChannelAdapter
extends MessageProducerSupport
implements OrderlyShutdownCapable {
    private final AbstractMessageListenerContainer messageListenerContainer;
    private volatile MessageConverter messageConverter = new SimpleMessageConverter();
    private volatile AmqpHeaderMapper headerMapper = DefaultAmqpHeaderMapper.inboundMapper();

    public AmqpInboundChannelAdapter(AbstractMessageListenerContainer listenerContainer) {
        Assert.notNull((Object)listenerContainer, (String)"listenerContainer must not be null");
        Assert.isNull((Object)listenerContainer.getMessageListener(), (String)"The listenerContainer provided to an AMQP inbound Channel Adapter must not have a MessageListener configured since the adapter configure its own listener implementation.");
        this.messageListenerContainer = listenerContainer;
        this.messageListenerContainer.setAutoStartup(false);
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        Assert.notNull((Object)messageConverter, (String)"messageConverter must not be null");
        this.messageConverter = messageConverter;
    }

    public void setHeaderMapper(AmqpHeaderMapper headerMapper) {
        Assert.notNull((Object)headerMapper, (String)"headerMapper must not be null");
        this.headerMapper = headerMapper;
    }

    public String getComponentType() {
        return "amqp:inbound-channel-adapter";
    }

    protected void onInit() {
        this.messageListenerContainer.setMessageListener((Object)new ChannelAwareMessageListener(){

            public void onMessage(Message message, Channel channel) throws Exception {
                Object payload = AmqpInboundChannelAdapter.this.messageConverter.fromMessage(message);
                Map headers = AmqpInboundChannelAdapter.this.headerMapper.toHeadersFromRequest(message.getMessageProperties());
                if (AmqpInboundChannelAdapter.this.messageListenerContainer.getAcknowledgeMode() == AcknowledgeMode.MANUAL) {
                    headers.put("amqp_deliveryTag", message.getMessageProperties().getDeliveryTag());
                    headers.put("amqp_channel", channel);
                }
                AmqpInboundChannelAdapter.this.sendMessage(AmqpInboundChannelAdapter.this.getMessageBuilderFactory().withPayload(payload).copyHeaders(headers).build());
            }
        });
        this.messageListenerContainer.afterPropertiesSet();
        super.onInit();
    }

    protected void doStart() {
        this.messageListenerContainer.start();
    }

    protected void doStop() {
        this.messageListenerContainer.stop();
    }

    public int beforeShutdown() {
        this.stop();
        return 0;
    }

    public int afterShutdown() {
        return 0;
    }
}

