/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.amqp.channel;

import java.util.ArrayDeque;
import java.util.List;
import java.util.Map;
import org.springframework.amqp.core.AmqpAdmin;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.integration.amqp.channel.AbstractAmqpChannel;
import org.springframework.integration.amqp.support.AmqpHeaderMapper;
import org.springframework.integration.channel.AbstractMessageChannel;
import org.springframework.integration.channel.ExecutorChannelInterceptorAware;
import org.springframework.integration.support.management.PollableChannelManagement;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.PollableChannel;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.messaging.support.ExecutorChannelInterceptor;
import org.springframework.util.Assert;

public class PollableAmqpChannel
extends AbstractAmqpChannel
implements PollableChannel,
PollableChannelManagement,
ExecutorChannelInterceptorAware {
    private final String channelName;
    private volatile Queue queue;
    private volatile int executorInterceptorsSize;
    private volatile boolean declared;

    public PollableAmqpChannel(String channelName, AmqpTemplate amqpTemplate) {
        super(amqpTemplate);
        Assert.hasText((String)channelName, (String)"channel name must not be empty");
        this.channelName = channelName;
    }

    public PollableAmqpChannel(String channelName, AmqpTemplate amqpTemplate, AmqpHeaderMapper outboundMapper, AmqpHeaderMapper inboundMapper) {
        super(amqpTemplate, outboundMapper, inboundMapper);
        Assert.hasText((String)channelName, (String)"channel name must not be empty");
        this.channelName = channelName;
    }

    public void setQueueName(String queueName) {
        this.queue = new Queue(queueName);
    }

    public void setAmqpAdmin(AmqpAdmin amqpAdmin) {
        this.setAdmin(amqpAdmin);
    }

    public int getReceiveCount() {
        return this.getMetrics().getReceiveCount();
    }

    public long getReceiveCountLong() {
        return this.getMetrics().getReceiveCountLong();
    }

    public int getReceiveErrorCount() {
        return this.getMetrics().getReceiveErrorCount();
    }

    public long getReceiveErrorCountLong() {
        return this.getMetrics().getReceiveErrorCountLong();
    }

    @Override
    protected String getRoutingKey() {
        return this.queue != null ? this.queue.getName() : super.getRoutingKey();
    }

    @Override
    protected void onInit() throws Exception {
        AmqpTemplate amqpTemplate = this.getAmqpTemplate();
        if (this.queue == null) {
            if (this.getAdmin() == null && amqpTemplate instanceof RabbitTemplate) {
                ConnectionFactory connectionFactory = ((RabbitTemplate)amqpTemplate).getConnectionFactory();
                this.setAdmin((AmqpAdmin)new RabbitAdmin(connectionFactory));
                this.setConnectionFactory(connectionFactory);
            }
            Assert.notNull((Object)this.getAdmin(), (String)"If no queueName is configured explicitly, an AmqpAdmin instance must be provided, or the AmqpTemplate must be a RabbitTemplate since the Queue needs to be declared.");
            this.queue = new Queue(this.channelName);
        }
        super.onInit();
    }

    @Override
    protected void doDeclares() {
        AmqpAdmin admin = this.getAdmin();
        if (admin != null && admin.getQueueProperties(this.queue.getName()) == null) {
            admin.declareQueue(this.queue);
        }
    }

    public Message<?> receive() {
        return this.doReceive(null);
    }

    public Message<?> receive(long timeout) {
        return this.doReceive(timeout);
    }

    protected Message<?> doReceive(Long timeout) {
        AbstractMessageChannel.ChannelInterceptorList interceptorList = this.getInterceptors();
        ArrayDeque interceptorStack = null;
        boolean counted = false;
        boolean countsEnabled = this.isCountsEnabled();
        try {
            if (this.isLoggingEnabled() && this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("preReceive on channel '" + (Object)((Object)this) + "'"));
            }
            if (interceptorList.getInterceptors().size() > 0 && !interceptorList.preReceive((MessageChannel)this, interceptorStack = new ArrayDeque())) {
                return null;
            }
            Object object = this.performReceive(timeout);
            if (object == null) {
                if (this.isLoggingEnabled() && this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("postReceive on channel '" + (Object)((Object)this) + "', message is null"));
                }
                return null;
            }
            if (countsEnabled) {
                this.getMetrics().afterReceive();
                counted = true;
            }
            Message message = object instanceof Message ? (Message)object : this.getMessageBuilderFactory().withPayload(object).build();
            if (this.isLoggingEnabled() && this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("postReceive on channel '" + (Object)((Object)this) + "', message: " + message));
            }
            if (interceptorStack != null) {
                message = interceptorList.postReceive(message, (MessageChannel)this);
                interceptorList.afterReceiveCompletion(message, (MessageChannel)this, null, interceptorStack);
            }
            return message;
        }
        catch (RuntimeException e) {
            if (countsEnabled && !counted) {
                this.getMetrics().afterError();
            }
            if (interceptorStack != null) {
                interceptorList.afterReceiveCompletion(null, (MessageChannel)this, (Exception)e, interceptorStack);
            }
            throw e;
        }
    }

    protected Object performReceive(Long timeout) {
        if (!this.declared) {
            this.doDeclares();
            this.declared = true;
        }
        if (!this.isExtractPayload()) {
            if (timeout == null) {
                return this.getAmqpTemplate().receiveAndConvert(this.queue.getName());
            }
            return this.getAmqpTemplate().receiveAndConvert(this.queue.getName(), timeout.longValue());
        }
        RabbitTemplate rabbitTemplate = this.getRabbitTemplate();
        org.springframework.amqp.core.Message message = timeout == null ? rabbitTemplate.receive(this.queue.getName()) : rabbitTemplate.receive(this.queue.getName(), timeout.longValue());
        if (message != null) {
            Object payload = rabbitTemplate.getMessageConverter().fromMessage(message);
            Map headers = this.getInboundHeaderMapper().toHeadersFromRequest(message.getMessageProperties());
            return this.getMessageBuilderFactory().withPayload(payload).copyHeaders(headers).build();
        }
        return null;
    }

    public void setInterceptors(List<ChannelInterceptor> interceptors) {
        super.setInterceptors(interceptors);
        for (ChannelInterceptor interceptor : interceptors) {
            if (!(interceptor instanceof ExecutorChannelInterceptor)) continue;
            ++this.executorInterceptorsSize;
        }
    }

    public void addInterceptor(ChannelInterceptor interceptor) {
        super.addInterceptor(interceptor);
        if (interceptor instanceof ExecutorChannelInterceptor) {
            ++this.executorInterceptorsSize;
        }
    }

    public void addInterceptor(int index, ChannelInterceptor interceptor) {
        super.addInterceptor(index, interceptor);
        if (interceptor instanceof ExecutorChannelInterceptor) {
            ++this.executorInterceptorsSize;
        }
    }

    public boolean removeInterceptor(ChannelInterceptor interceptor) {
        boolean removed = super.removeInterceptor(interceptor);
        if (removed && interceptor instanceof ExecutorChannelInterceptor) {
            --this.executorInterceptorsSize;
        }
        return removed;
    }

    public ChannelInterceptor removeInterceptor(int index) {
        ChannelInterceptor interceptor = super.removeInterceptor(index);
        if (interceptor instanceof ExecutorChannelInterceptor) {
            --this.executorInterceptorsSize;
        }
        return interceptor;
    }

    public boolean hasExecutorInterceptors() {
        return this.executorInterceptorsSize > 0;
    }
}

