/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.amqp.support;

import org.springframework.amqp.core.MessageDeliveryMode;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.support.converter.ContentTypeDelegatingMessageConverter;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.integration.amqp.support.AmqpHeaderMapper;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.util.MimeType;

public final class MappingUtils {
    private MappingUtils() {
    }

    public static org.springframework.amqp.core.Message mapMessage(Message<?> requestMessage, MessageConverter converter, AmqpHeaderMapper headerMapper, MessageDeliveryMode defaultDeliveryMode, boolean headersMappedLast) {
        String contentType;
        MessageProperties amqpMessageProperties = new MessageProperties();
        if (!headersMappedLast) {
            headerMapper.fromHeadersToRequest(requestMessage.getHeaders(), amqpMessageProperties);
        }
        if (converter instanceof ContentTypeDelegatingMessageConverter && headersMappedLast && (contentType = MappingUtils.contentTypeAsString(requestMessage.getHeaders())) != null) {
            amqpMessageProperties.setContentType(contentType);
        }
        org.springframework.amqp.core.Message amqpMessage = converter.toMessage(requestMessage.getPayload(), amqpMessageProperties);
        if (headersMappedLast) {
            headerMapper.fromHeadersToRequest(requestMessage.getHeaders(), amqpMessageProperties);
        }
        MappingUtils.checkDeliveryMode(requestMessage, amqpMessageProperties, defaultDeliveryMode);
        return amqpMessage;
    }

    private static String contentTypeAsString(MessageHeaders headers) {
        Object contentType = headers.get((Object)"contentType");
        if (contentType instanceof MimeType) {
            contentType = contentType.toString();
        }
        if (contentType instanceof String) {
            return (String)contentType;
        }
        if (contentType != null) {
            throw new IllegalArgumentException("contentType header must be a MimeType or String, found: " + contentType.getClass().getName());
        }
        return null;
    }

    public static void checkDeliveryMode(Message<?> requestMessage, MessageProperties messageProperties, @Nullable MessageDeliveryMode defaultDeliveryMode) {
        if (defaultDeliveryMode != null && requestMessage.getHeaders().get((Object)"amqp_deliveryMode") == null) {
            messageProperties.setDeliveryMode(defaultDeliveryMode);
        }
    }
}

