/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.event.inbound;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ApplicationContextEvent;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.integration.Message;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationEventListeningMessageProducer
extends MessageProducerSupport
implements ApplicationListener<ApplicationEvent> {
    private final Set<Class<? extends ApplicationEvent>> eventTypes = new CopyOnWriteArraySet<Class<? extends ApplicationEvent>>();
    private volatile Expression payloadExpression;
    private volatile boolean active;
    private final SpelExpressionParser parser = new SpelExpressionParser();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEventTypes(Class<? extends ApplicationEvent>[] eventTypes) {
        Assert.notEmpty((Object[])eventTypes, (String)"at least one event type is required");
        Set<Class<? extends ApplicationEvent>> set = this.eventTypes;
        synchronized (set) {
            this.eventTypes.clear();
            this.eventTypes.addAll(CollectionUtils.arrayToList(eventTypes));
        }
    }

    public void setPayloadExpression(String payloadExpression) {
        this.payloadExpression = payloadExpression == null ? null : this.parser.parseExpression(payloadExpression);
    }

    public String getComponentType() {
        return "event:inbound-channel-adapter";
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (this.active || event instanceof ApplicationContextEvent) {
            if (CollectionUtils.isEmpty(this.eventTypes)) {
                this.sendEventAsMessage(event);
                return;
            }
            for (Class<? extends ApplicationEvent> eventType : this.eventTypes) {
                if (!eventType.isAssignableFrom(event.getClass())) continue;
                this.sendEventAsMessage(event);
                return;
            }
        }
    }

    protected void doStart() {
        this.active = true;
    }

    protected void doStop() {
        this.active = false;
    }

    private void sendEventAsMessage(ApplicationEvent event) {
        if (event.getSource() instanceof Message) {
            this.sendMessage((Message)event.getSource());
        } else {
            ApplicationEvent payload = this.payloadExpression != null ? this.payloadExpression.getValue((Object)event) : event;
            this.sendMessage(MessageBuilder.withPayload((Object)payload).build());
        }
    }
}

