/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.remote.handler;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import org.springframework.expression.Expression;
import org.springframework.integration.Message;
import org.springframework.integration.MessageDeliveryException;
import org.springframework.integration.file.DefaultFileNameGenerator;
import org.springframework.integration.file.FileNameGenerator;
import org.springframework.integration.file.remote.session.Session;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.integration.handler.ExpressionEvaluatingMessageProcessor;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileTransferringMessageHandler
extends AbstractMessageHandler {
    private static final String TEMPORARY_FILE_SUFFIX = ".writing";
    private final SessionFactory sessionFactory;
    private volatile ExpressionEvaluatingMessageProcessor<String> directoryExpressionProcessor;
    private volatile FileNameGenerator fileNameGenerator = new DefaultFileNameGenerator();
    private volatile File temporaryDirectory = new File(System.getProperty("java.io.tmpdir"));
    private volatile String charset = Charset.defaultCharset().name();

    public FileTransferringMessageHandler(SessionFactory sessionFactory) {
        Assert.notNull((Object)sessionFactory, (String)"sessionFactory must not be null");
        this.sessionFactory = sessionFactory;
    }

    public void setRemoteDirectoryExpression(Expression remoteDirectoryExpression) {
        this.directoryExpressionProcessor = new ExpressionEvaluatingMessageProcessor(remoteDirectoryExpression);
    }

    public void setTemporaryDirectory(File temporaryDirectory) {
        Assert.notNull((Object)temporaryDirectory, (String)"temporaryDirectory must not be null");
        this.temporaryDirectory = temporaryDirectory;
    }

    public void setFileNameGenerator(FileNameGenerator fileNameGenerator) {
        this.fileNameGenerator = fileNameGenerator;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    protected void onInit() throws Exception {
        Assert.notNull(this.directoryExpressionProcessor, (String)"remoteDirectoryExpression is required");
    }

    protected void handleMessageInternal(Message<?> message) throws Exception {
        File file = this.redeemForStorableFile(message);
        if (file != null && file.exists()) {
            Session session = this.sessionFactory.getSession();
            boolean sentSuccesfully = false;
            try {
                String targetDirectory = (String)this.directoryExpressionProcessor.processMessage(message);
                sentSuccesfully = this.sendFileToRemoteDirectory(file, targetDirectory, session);
            }
            catch (FileNotFoundException e) {
                throw new MessageDeliveryException(message, "File [" + file + "] not found in local working directory; it was moved or deleted unexpectedly.", (Throwable)e);
            }
            catch (IOException e) {
                throw new MessageDeliveryException(message, "Failed to transfer file [" + file + "] from local working directory to remote FTP directory.", (Throwable)e);
            }
            catch (Exception e) {
                throw new MessageDeliveryException(message, "Error handling message for file [" + file + "]", (Throwable)e);
            }
            finally {
                if (file.exists()) {
                    try {
                        file.delete();
                    }
                    catch (Throwable th) {}
                }
                if (session != null) {
                    session.close();
                }
            }
            if (!sentSuccesfully) {
                throw new MessageDeliveryException(message, "Failed to transfer file '" + file + "'");
            }
        }
    }

    private File handleFileMessage(File sourceFile, File tempFile, File resultFile) throws IOException {
        FileCopyUtils.copy((File)sourceFile, (File)tempFile);
        tempFile.renameTo(resultFile);
        return resultFile;
    }

    private File handleByteArrayMessage(byte[] bytes, File tempFile, File resultFile) throws IOException {
        FileCopyUtils.copy((byte[])bytes, (File)tempFile);
        tempFile.renameTo(resultFile);
        return resultFile;
    }

    private File handleStringMessage(String content, File tempFile, File resultFile, String charset) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile), charset);
        FileCopyUtils.copy((String)content, (Writer)writer);
        tempFile.renameTo(resultFile);
        return resultFile;
    }

    private File redeemForStorableFile(Message<?> message) throws MessageDeliveryException {
        try {
            Object payload = message.getPayload();
            String generateFileName = this.fileNameGenerator.generateFileName(message);
            File tempFile = new File(this.temporaryDirectory, generateFileName + TEMPORARY_FILE_SUFFIX);
            File resultFile = new File(this.temporaryDirectory, generateFileName);
            File sendableFile = null;
            if (payload instanceof String) {
                sendableFile = this.handleStringMessage((String)payload, tempFile, resultFile, this.charset);
            } else if (payload instanceof File) {
                sendableFile = this.handleFileMessage((File)payload, tempFile, resultFile);
            } else if (payload instanceof byte[]) {
                sendableFile = this.handleByteArrayMessage((byte[])payload, tempFile, resultFile);
            }
            return sendableFile;
        }
        catch (Exception e) {
            throw new MessageDeliveryException(message, "Failed to create sendable file.", (Throwable)e);
        }
    }

    private boolean sendFileToRemoteDirectory(File file, String remoteDirectory, Session session) throws FileNotFoundException, IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        if (!StringUtils.endsWithIgnoreCase((String)remoteDirectory, (String)File.separator)) {
            remoteDirectory = remoteDirectory + File.separatorChar;
        }
        String remoteFilePath = remoteDirectory + file.getName();
        session.put(fileInputStream, remoteFilePath);
        fileInputStream.close();
        return true;
    }
}

