/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.Message;
import org.springframework.integration.MessageHandlingException;
import org.springframework.integration.file.DefaultFileNameGenerator;
import org.springframework.integration.file.FileNameGenerator;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileWritingMessageHandler
extends AbstractReplyProducingMessageHandler {
    private volatile String temporaryFileSuffix = ".writing";
    private final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private volatile FileNameGenerator fileNameGenerator = new DefaultFileNameGenerator();
    private final File destinationDirectory;
    private volatile boolean autoCreateDirectory = true;
    private volatile boolean deleteSourceFiles;
    private volatile Charset charset = Charset.defaultCharset();

    public FileWritingMessageHandler(File destinationDirectory) {
        Assert.notNull((Object)destinationDirectory, (String)"Destination directory must not be null.");
        this.destinationDirectory = destinationDirectory;
    }

    public void setAutoCreateDirectory(boolean autoCreateDirectory) {
        this.autoCreateDirectory = autoCreateDirectory;
    }

    public void setTemporaryFileSuffix(String temporaryFileSuffix) {
        this.temporaryFileSuffix = temporaryFileSuffix;
    }

    protected String getTemporaryFileSuffix() {
        return this.temporaryFileSuffix;
    }

    public void setFileNameGenerator(FileNameGenerator fileNameGenerator) {
        Assert.notNull((Object)fileNameGenerator, (String)"FileNameGenerator must not be null");
        this.fileNameGenerator = fileNameGenerator;
    }

    public void setDeleteSourceFiles(boolean deleteSourceFiles) {
        this.deleteSourceFiles = deleteSourceFiles;
    }

    public void setCharset(String charset) {
        Assert.notNull((Object)charset, (String)"charset must not be null");
        Assert.isTrue((boolean)Charset.isSupported(charset), (String)("Charset '" + charset + "' is not supported."));
        this.charset = Charset.forName(charset);
    }

    public final void onInit() {
        if (!this.destinationDirectory.exists() && this.autoCreateDirectory) {
            this.destinationDirectory.mkdirs();
        }
        Assert.isTrue((boolean)this.destinationDirectory.exists(), (String)("Destination directory [" + this.destinationDirectory + "] does not exist."));
        Assert.isTrue((boolean)this.destinationDirectory.isDirectory(), (String)("Destination path [" + this.destinationDirectory + "] does not point to a directory."));
        Assert.isTrue((boolean)this.destinationDirectory.canWrite(), (String)("Destination directory [" + this.destinationDirectory + "] is not writable."));
    }

    protected Object handleRequestMessage(Message<?> requestMessage) {
        File resultFile;
        File originalFileFromHeader;
        Object payload;
        block6: {
            Assert.notNull(requestMessage, (String)"message must not be null");
            payload = requestMessage.getPayload();
            Assert.notNull((Object)payload, (String)"message payload must not be null");
            String generatedFileName = this.fileNameGenerator.generateFileName(requestMessage);
            originalFileFromHeader = this.retrieveOriginalFileFromHeader(requestMessage);
            File tempFile = new File(this.destinationDirectory, generatedFileName + this.temporaryFileSuffix);
            resultFile = new File(this.destinationDirectory, generatedFileName);
            try {
                if (payload instanceof File) {
                    resultFile = this.handleFileMessage((File)payload, tempFile, resultFile);
                    break block6;
                }
                if (payload instanceof byte[]) {
                    resultFile = this.handleByteArrayMessage((byte[])payload, originalFileFromHeader, tempFile, resultFile);
                    break block6;
                }
                if (payload instanceof String) {
                    resultFile = this.handleStringMessage((String)payload, originalFileFromHeader, tempFile, resultFile);
                    break block6;
                }
                throw new IllegalArgumentException("unsupported Message payload type [" + payload.getClass().getName() + "]");
            }
            catch (Exception e) {
                throw new MessageHandlingException(requestMessage, "failed to write Message payload to file", (Throwable)e);
            }
        }
        if (resultFile != null && originalFileFromHeader == null && payload instanceof File) {
            return MessageBuilder.withPayload((Object)resultFile).setHeader("file_originalFile", payload);
        }
        return resultFile;
    }

    private File retrieveOriginalFileFromHeader(Message<?> message) {
        Object value = message.getHeaders().get((Object)"file_originalFile");
        if (value instanceof File) {
            return (File)value;
        }
        if (value instanceof String) {
            return new File((String)value);
        }
        return null;
    }

    private File handleFileMessage(File sourceFile, File tempFile, File resultFile) throws IOException {
        if (this.deleteSourceFiles) {
            if (sourceFile.renameTo(resultFile)) {
                return resultFile;
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)String.format("Failed to move file '%s'. Using copy and delete fallback.", sourceFile.getAbsolutePath()));
            }
        }
        FileCopyUtils.copy((File)sourceFile, (File)tempFile);
        tempFile.renameTo(resultFile);
        if (this.deleteSourceFiles) {
            sourceFile.delete();
        }
        return resultFile;
    }

    private File handleByteArrayMessage(byte[] bytes, File originalFile, File tempFile, File resultFile) throws IOException {
        FileCopyUtils.copy((byte[])bytes, (File)tempFile);
        tempFile.renameTo(resultFile);
        if (this.deleteSourceFiles && originalFile != null) {
            originalFile.delete();
        }
        return resultFile;
    }

    private File handleStringMessage(String content, File originalFile, File tempFile, File resultFile) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile), this.charset);
        FileCopyUtils.copy((String)content, (Writer)writer);
        tempFile.renameTo(resultFile);
        if (this.deleteSourceFiles && originalFile != null) {
            originalFile.delete();
        }
        return resultFile;
    }
}

