/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.remote.session;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.integration.file.remote.session.ExtendedSession;
import org.springframework.integration.file.remote.session.Session;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.integration.util.UpperBound;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingSessionFactory<F>
implements SessionFactory<F>,
DisposableBean {
    private static final Log logger = LogFactory.getLog(CachingSessionFactory.class);
    private volatile long sessionWaitTimeout = Integer.MAX_VALUE;
    private final LinkedBlockingQueue<Session<F>> queue = new LinkedBlockingQueue();
    private final SessionFactory<F> sessionFactory;
    private final UpperBound sessionPermits;

    public CachingSessionFactory(SessionFactory<F> sessionFactory) {
        this(sessionFactory, 0);
    }

    public CachingSessionFactory(SessionFactory<F> sessionFactory, int sessionCacheSize) {
        this.sessionFactory = sessionFactory;
        this.sessionPermits = new UpperBound(sessionCacheSize);
    }

    public void setSessionWaitTimeout(long sessionWaitTimeout) {
        this.sessionWaitTimeout = sessionWaitTimeout;
    }

    @Override
    public Session<F> getSession() {
        boolean permitted = this.sessionPermits.tryAcquire(this.sessionWaitTimeout);
        if (!permitted) {
            throw new IllegalStateException("Timed out while waiting to aquire a Session.");
        }
        Session<F> session = this.doGetSession();
        return new CachedSession(session);
    }

    public void destroy() {
        if (this.queue != null) {
            for (Session<F> session : this.queue) {
                this.closeSession(session);
            }
        }
    }

    private Session<F> doGetSession() {
        Session<F> session = this.queue.poll();
        if (session != null && !session.isOpen()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Received a stale Session, will attempt to get a new one.");
            }
            return this.doGetSession();
        }
        if (session == null) {
            session = this.sessionFactory.getSession();
        }
        return session;
    }

    private void closeSession(Session<F> session) {
        block3: {
            try {
                if (session != null) {
                    session.close();
                }
            }
            catch (Throwable e) {
                if (!logger.isWarnEnabled()) break block3;
                logger.warn((Object)"Exception was thrown while destroying Session. ", e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CachedSession
    implements ExtendedSession<F> {
        private final Session<F> targetSession;

        private CachedSession(Session<F> targetSession) {
            this.targetSession = targetSession;
        }

        @Override
        public void close() {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Releasing Session back to the pool.");
            }
            CachingSessionFactory.this.queue.add(this.targetSession);
            CachingSessionFactory.this.sessionPermits.release();
        }

        @Override
        public boolean remove(String path) throws IOException {
            return this.targetSession.remove(path);
        }

        @Override
        public F[] list(String path) throws IOException {
            return this.targetSession.list(path);
        }

        @Override
        public void read(String source, OutputStream os) throws IOException {
            this.targetSession.read(source, os);
        }

        @Override
        public void write(InputStream inputStream, String destination) throws IOException {
            this.targetSession.write(inputStream, destination);
        }

        @Override
        public boolean isOpen() {
            return this.targetSession.isOpen();
        }

        @Override
        public void rename(String pathFrom, String pathTo) throws IOException {
            this.targetSession.rename(pathFrom, pathTo);
        }

        @Override
        public boolean mkdir(String directory) throws IOException {
            return this.targetSession.mkdir(directory);
        }

        @Override
        public boolean exists(String path) throws IOException {
            return this.targetSession.exists(path);
        }

        @Override
        public String[] listNames(String path) throws IOException {
            Assert.isInstanceOf(ExtendedSession.class, this.targetSession, (String)"mget failed - ");
            return ((ExtendedSession)this.targetSession).listNames(path);
        }
    }
}

