/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file;

import java.io.File;
import org.springframework.integration.Message;
import org.springframework.integration.file.FileNameGenerator;
import org.springframework.integration.util.AbstractExpressionEvaluator;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFileNameGenerator
extends AbstractExpressionEvaluator
implements FileNameGenerator {
    private volatile String expression = "headers['file_name']";

    public void setExpression(String expression) {
        Assert.hasText((String)expression, (String)"expression must not be empty");
        this.expression = expression;
    }

    public void setHeaderName(String headerName) {
        Assert.notNull((Object)headerName, (String)"'headerName' must not be null");
        this.expression = "headers['" + headerName + "']";
    }

    @Override
    public String generateFileName(Message<?> message) {
        Object filenameProperty = this.evaluateExpression(this.expression, message);
        if (filenameProperty instanceof String && StringUtils.hasText((String)((String)filenameProperty))) {
            return (String)filenameProperty;
        }
        if (message.getPayload() instanceof File) {
            return ((File)message.getPayload()).getName();
        }
        return message.getHeaders().getId() + ".msg";
    }
}

