/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.config;

import java.io.File;
import java.util.ArrayList;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.integration.file.filters.AbstractFileListFilter;
import org.springframework.integration.file.filters.AcceptAllFileListFilter;
import org.springframework.integration.file.filters.AcceptOnceFileListFilter;
import org.springframework.integration.file.filters.CompositeFileListFilter;
import org.springframework.integration.file.filters.FileListFilter;
import org.springframework.integration.file.filters.RegexPatternFileListFilter;
import org.springframework.integration.file.filters.SimplePatternFileListFilter;

public class FileListFilterFactoryBean
implements FactoryBean<FileListFilter<File>> {
    private volatile FileListFilter<File> result;
    private volatile FileListFilter<File> filter;
    private volatile String filenamePattern;
    private volatile String filenameRegex;
    private volatile Boolean preventDuplicates;
    private final Object monitor = new Object();

    public void setFilter(FileListFilter<File> filter) {
        this.filter = filter;
    }

    public void setFilenamePattern(String filenamePattern) {
        this.filenamePattern = filenamePattern;
    }

    public void setFilenameRegex(String filenameRegex) {
        this.filenameRegex = filenameRegex;
    }

    public void setPreventDuplicates(Boolean preventDuplicates) {
        this.preventDuplicates = preventDuplicates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileListFilter<File> getObject() throws Exception {
        if (this.result == null) {
            Object object = this.monitor;
            synchronized (object) {
                this.initializeFileListFilter();
            }
        }
        return this.result;
    }

    public Class<?> getObjectType() {
        return this.result != null ? this.result.getClass() : FileListFilter.class;
    }

    public boolean isSingleton() {
        return true;
    }

    private void initializeFileListFilter() {
        if (this.result != null) {
            return;
        }
        FileListFilter<Object> createdFilter = null;
        if (this.filter != null && (this.filenamePattern != null || this.filenameRegex != null)) {
            throw new IllegalArgumentException("The 'filter' reference is mutually exclusive with either the 'filename-pattern' or 'filename-regex' attribute.");
        }
        if (this.filenamePattern != null && this.filenameRegex != null) {
            throw new IllegalArgumentException("The 'filename-pattern' and 'filename-regex' attributes are mutually exclusive.");
        }
        if (this.filter != null) {
            createdFilter = Boolean.TRUE.equals(this.preventDuplicates) ? this.createCompositeWithAcceptOnceFilter(this.filter) : this.filter;
        } else if (this.filenamePattern != null || this.filenameRegex != null) {
            ArrayList<AbstractFileListFilter> filtersNeeded = new ArrayList<AbstractFileListFilter>();
            if (!Boolean.FALSE.equals(this.preventDuplicates)) {
                filtersNeeded.add(new AcceptOnceFileListFilter());
            }
            if (this.filenamePattern != null) {
                filtersNeeded.add(new SimplePatternFileListFilter(this.filenamePattern));
            }
            if (this.filenameRegex != null) {
                filtersNeeded.add(new RegexPatternFileListFilter(this.filenameRegex));
            }
            createdFilter = filtersNeeded.size() == 1 ? (CompositeFileListFilter)filtersNeeded.get(0) : new CompositeFileListFilter(filtersNeeded);
        } else {
            createdFilter = Boolean.FALSE.equals(this.preventDuplicates) ? new AcceptAllFileListFilter<File>() : new AcceptOnceFileListFilter<File>();
        }
        this.result = createdFilter;
    }

    private CompositeFileListFilter<File> createCompositeWithAcceptOnceFilter(FileListFilter<File> otherFilter) {
        CompositeFileListFilter<File> compositeFilter = new CompositeFileListFilter<File>();
        compositeFilter.addFilter(new AcceptOnceFileListFilter());
        compositeFilter.addFilter(otherFilter);
        return compositeFilter;
    }
}

