/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.remote;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.expression.Expression;
import org.springframework.integration.Message;
import org.springframework.integration.MessageDeliveryException;
import org.springframework.integration.MessagingException;
import org.springframework.integration.file.DefaultFileNameGenerator;
import org.springframework.integration.file.FileNameGenerator;
import org.springframework.integration.file.remote.InputStreamCallback;
import org.springframework.integration.file.remote.RemoteFileOperations;
import org.springframework.integration.file.remote.RemoteFileUtils;
import org.springframework.integration.file.remote.SessionCallback;
import org.springframework.integration.file.remote.SessionCallbackWithoutResult;
import org.springframework.integration.file.remote.session.CachingSessionFactory;
import org.springframework.integration.file.remote.session.Session;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.integration.handler.ExpressionEvaluatingMessageProcessor;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class RemoteFileTemplate<F>
implements RemoteFileOperations<F>,
InitializingBean,
BeanFactoryAware {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final SessionFactory<F> sessionFactory;
    private volatile String temporaryFileSuffix = ".writing";
    private volatile boolean autoCreateDirectory = false;
    private volatile boolean useTemporaryFileName = true;
    private volatile ExpressionEvaluatingMessageProcessor<String> directoryExpressionProcessor;
    private volatile ExpressionEvaluatingMessageProcessor<String> temporaryDirectoryExpressionProcessor;
    private volatile ExpressionEvaluatingMessageProcessor<String> fileNameProcessor;
    private volatile FileNameGenerator fileNameGenerator = new DefaultFileNameGenerator();
    private volatile boolean fileNameGeneratorSet;
    private volatile String charset = "UTF-8";
    private volatile String remoteFileSeparator = "/";
    private volatile boolean hasExplicitlySetSuffix;
    private volatile BeanFactory beanFactory;

    public RemoteFileTemplate(SessionFactory<F> sessionFactory) {
        Assert.notNull(sessionFactory, (String)"sessionFactory must not be null");
        this.sessionFactory = sessionFactory;
    }

    public void setAutoCreateDirectory(boolean autoCreateDirectory) {
        this.autoCreateDirectory = autoCreateDirectory;
    }

    public void setRemoteFileSeparator(String remoteFileSeparator) {
        Assert.notNull((Object)remoteFileSeparator, (String)"'remoteFileSeparator' must not be null");
        this.remoteFileSeparator = remoteFileSeparator;
    }

    public final String getRemoteFileSeparator() {
        return this.remoteFileSeparator;
    }

    public void setRemoteDirectoryExpression(Expression remoteDirectoryExpression) {
        Assert.notNull((Object)remoteDirectoryExpression, (String)"remoteDirectoryExpression must not be null");
        this.directoryExpressionProcessor = new ExpressionEvaluatingMessageProcessor(remoteDirectoryExpression, String.class);
    }

    public void setTemporaryRemoteDirectoryExpression(Expression temporaryRemoteDirectoryExpression) {
        Assert.notNull((Object)temporaryRemoteDirectoryExpression, (String)"temporaryRemoteDirectoryExpression must not be null");
        this.temporaryDirectoryExpressionProcessor = new ExpressionEvaluatingMessageProcessor(temporaryRemoteDirectoryExpression, String.class);
    }

    public void setFileNameExpression(Expression fileNameExpression) {
        Assert.notNull((Object)fileNameExpression, (String)"fileNameExpression must not be null");
        this.fileNameProcessor = new ExpressionEvaluatingMessageProcessor(fileNameExpression, String.class);
    }

    public String getTemporaryFileSuffix() {
        return this.temporaryFileSuffix;
    }

    public boolean isUseTemporaryFileName() {
        return this.useTemporaryFileName;
    }

    public void setUseTemporaryFileName(boolean useTemporaryFileName) {
        this.useTemporaryFileName = useTemporaryFileName;
    }

    public void setFileNameGenerator(FileNameGenerator fileNameGenerator) {
        this.fileNameGenerator = fileNameGenerator != null ? fileNameGenerator : new DefaultFileNameGenerator();
        this.fileNameGeneratorSet = fileNameGenerator != null;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setTemporaryFileSuffix(String temporaryFileSuffix) {
        Assert.notNull((Object)temporaryFileSuffix, (String)"'temporaryFileSuffix' must not be null");
        this.hasExplicitlySetSuffix = true;
        this.temporaryFileSuffix = temporaryFileSuffix;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void afterPropertiesSet() throws Exception {
        BeanFactory beanFactory = this.beanFactory;
        if (beanFactory != null) {
            if (this.directoryExpressionProcessor != null) {
                this.directoryExpressionProcessor.setBeanFactory(beanFactory);
            }
            if (this.temporaryDirectoryExpressionProcessor != null) {
                this.temporaryDirectoryExpressionProcessor.setBeanFactory(beanFactory);
            }
            if (!this.fileNameGeneratorSet && this.fileNameGenerator instanceof BeanFactoryAware) {
                ((BeanFactoryAware)this.fileNameGenerator).setBeanFactory(beanFactory);
            }
            if (this.fileNameProcessor != null) {
                this.fileNameProcessor.setBeanFactory(beanFactory);
            }
        }
        if (this.autoCreateDirectory) {
            Assert.hasText((String)this.remoteFileSeparator, (String)"'remoteFileSeparator' must not be empty when 'autoCreateDirectory' is set to 'true'");
        }
        if (this.hasExplicitlySetSuffix && !this.useTemporaryFileName) {
            this.logger.warn((Object)"Since 'use-temporary-file-name' is set to 'false' the value of 'temporary-file-suffix' has no effect");
        }
    }

    @Override
    public String send(Message<?> message) {
        return this.send(message, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String send(final Message<?> message, final String subDirectory) {
        Assert.notNull(this.directoryExpressionProcessor, (String)"'remoteDirectoryExpression' is required");
        final StreamHolder inputStreamHolder = this.payloadToInputStream(message);
        if (inputStreamHolder != null) {
            try {
                String string = (String)this.execute(new SessionCallback<F, String>(){

                    @Override
                    public String doInSession(Session<F> session) throws IOException {
                        String fileName = inputStreamHolder.getName();
                        try {
                            String remoteDirectory = (String)RemoteFileTemplate.this.directoryExpressionProcessor.processMessage(message);
                            remoteDirectory = RemoteFileTemplate.this.normalizeDirectoryPath(remoteDirectory);
                            if (StringUtils.hasText((String)subDirectory)) {
                                remoteDirectory = subDirectory.startsWith(RemoteFileTemplate.this.remoteFileSeparator) ? remoteDirectory + subDirectory.substring(1) : remoteDirectory + RemoteFileTemplate.this.normalizeDirectoryPath(subDirectory);
                            }
                            String temporaryRemoteDirectory = remoteDirectory;
                            if (RemoteFileTemplate.this.temporaryDirectoryExpressionProcessor != null) {
                                temporaryRemoteDirectory = (String)RemoteFileTemplate.this.temporaryDirectoryExpressionProcessor.processMessage(message);
                            }
                            fileName = RemoteFileTemplate.this.fileNameGenerator.generateFileName(message);
                            RemoteFileTemplate.this.sendFileToRemoteDirectory(inputStreamHolder.getStream(), temporaryRemoteDirectory, remoteDirectory, fileName, session);
                            return remoteDirectory + fileName;
                        }
                        catch (FileNotFoundException e) {
                            throw new MessageDeliveryException(message, "File [" + inputStreamHolder.getName() + "] not found in local working directory; it was moved or deleted unexpectedly.", (Throwable)e);
                        }
                        catch (IOException e) {
                            throw new MessageDeliveryException(message, "Failed to transfer file [" + inputStreamHolder.getName() + " -> " + fileName + "] from local directory to remote directory.", (Throwable)e);
                        }
                        catch (Exception e) {
                            throw new MessageDeliveryException(message, "Error handling message for file [" + inputStreamHolder.getName() + " -> " + fileName + "]", (Throwable)e);
                        }
                    }
                });
                return string;
            }
            finally {
                try {
                    inputStreamHolder.getStream().close();
                }
                catch (IOException e) {}
            }
        }
        if (this.logger.isWarnEnabled()) {
            this.logger.warn((Object)("File " + message.getPayload() + " does not exist"));
        }
        return null;
    }

    @Override
    public boolean remove(final String path) {
        return (Boolean)this.execute(new SessionCallback<F, Boolean>(){

            @Override
            public Boolean doInSession(Session<F> session) throws IOException {
                return session.remove(path);
            }
        });
    }

    @Override
    public void rename(final String fromPath, final String toPath) {
        Assert.hasText((String)fromPath, (String)"Old filename cannot be null or empty");
        Assert.hasText((String)toPath, (String)"New filename cannot be null or empty");
        this.execute(new SessionCallbackWithoutResult<F>(){

            @Override
            public void doInSessionWithoutResult(Session<F> session) throws IOException {
                int lastSeparator = toPath.lastIndexOf(RemoteFileTemplate.this.remoteFileSeparator);
                if (lastSeparator > 0) {
                    String remoteFileDirectory = toPath.substring(0, lastSeparator + 1);
                    RemoteFileUtils.makeDirectories(remoteFileDirectory, session, RemoteFileTemplate.this.remoteFileSeparator, RemoteFileTemplate.this.logger);
                }
                session.rename(fromPath, toPath);
            }
        });
    }

    @Override
    public boolean get(final Message<?> message, final InputStreamCallback callback) {
        Assert.notNull(this.fileNameProcessor, (String)"A 'fileNameExpression' is needed to use get");
        return (Boolean)this.execute(new SessionCallback<F, Boolean>(){

            @Override
            public Boolean doInSession(Session<F> session) throws IOException {
                String remotePath = (String)RemoteFileTemplate.this.fileNameProcessor.processMessage(message);
                InputStream inputStream = session.readRaw(remotePath);
                callback.doWithInputStream(inputStream);
                inputStream.close();
                return session.finalizeRaw();
            }
        });
    }

    @Override
    public <T> T execute(SessionCallback<F, T> callback) {
        Session<F> session = null;
        try {
            session = this.sessionFactory.getSession();
            Assert.notNull(session, (String)"failed to acquire a Session");
            T t = callback.doInSession(session);
            return t;
        }
        catch (Exception e) {
            if (session instanceof CachingSessionFactory.CachedSession) {
                ((CachingSessionFactory.CachedSession)session).dirty();
            }
            if (e instanceof MessagingException) {
                throw (MessagingException)e;
            }
            throw new MessagingException("Failed to execute on session", (Throwable)e);
        }
        finally {
            block12: {
                if (session != null) {
                    try {
                        session.close();
                    }
                    catch (Exception ignored) {
                        if (!this.logger.isDebugEnabled()) break block12;
                        this.logger.debug((Object)"failed to close Session", (Throwable)ignored);
                    }
                }
            }
        }
    }

    private StreamHolder payloadToInputStream(Message<?> message) throws MessageDeliveryException {
        try {
            Object payload = message.getPayload();
            InputStream dataInputStream = null;
            String name = null;
            if (payload instanceof File) {
                File inputFile = (File)payload;
                if (inputFile.exists()) {
                    dataInputStream = new BufferedInputStream(new FileInputStream(inputFile));
                    name = inputFile.getAbsolutePath();
                }
            } else if (payload instanceof byte[] || payload instanceof String) {
                byte[] bytes = null;
                if (payload instanceof String) {
                    bytes = ((String)payload).getBytes(this.charset);
                    name = "String payload";
                } else {
                    bytes = (byte[])payload;
                    name = "byte[] payload";
                }
                dataInputStream = new ByteArrayInputStream(bytes);
            } else {
                throw new IllegalArgumentException("Unsupported payload type. The only supported payloads are java.io.File, java.lang.String, and byte[]");
            }
            if (dataInputStream == null) {
                return null;
            }
            return new StreamHolder(dataInputStream, name);
        }
        catch (Exception e) {
            throw new MessageDeliveryException(message, "Failed to create sendable file.", (Throwable)e);
        }
    }

    private void sendFileToRemoteDirectory(InputStream inputStream, String temporaryRemoteDirectory, String remoteDirectory, String fileName, Session<F> session) throws IOException {
        remoteDirectory = this.normalizeDirectoryPath(remoteDirectory);
        temporaryRemoteDirectory = this.normalizeDirectoryPath(temporaryRemoteDirectory);
        String remoteFilePath = remoteDirectory + fileName;
        String tempRemoteFilePath = temporaryRemoteDirectory + fileName;
        String tempFilePath = tempRemoteFilePath + (this.useTemporaryFileName ? this.temporaryFileSuffix : "");
        if (this.autoCreateDirectory) {
            try {
                RemoteFileUtils.makeDirectories(remoteDirectory, session, this.remoteFileSeparator, this.logger);
            }
            catch (IllegalStateException e) {
                session.mkdir(remoteDirectory);
            }
        }
        try {
            session.write(inputStream, tempFilePath);
            if (this.useTemporaryFileName) {
                session.rename(tempFilePath, remoteFilePath);
            }
        }
        catch (Exception e) {
            throw new MessagingException("Failed to write to '" + tempFilePath + "' while uploading the file", (Throwable)e);
        }
        finally {
            inputStream.close();
        }
    }

    private String normalizeDirectoryPath(String directoryPath) {
        if (!StringUtils.hasText((String)directoryPath)) {
            directoryPath = "";
        } else if (!directoryPath.endsWith(this.remoteFileSeparator)) {
            directoryPath = directoryPath + this.remoteFileSeparator;
        }
        return directoryPath;
    }

    private class StreamHolder {
        private final InputStream stream;
        private final String name;

        private StreamHolder(InputStream stream, String name) {
            this.stream = stream;
            this.name = name;
        }

        public InputStream getStream() {
            return this.stream;
        }

        public String getName() {
            return this.name;
        }
    }
}

