/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.springframework.integration.file.DefaultDirectoryScanner;
import org.springframework.integration.file.filters.FileListFilter;

public class HeadDirectoryScanner
extends DefaultDirectoryScanner {
    public HeadDirectoryScanner(int maxNumberOfFiles) {
        this.setFilter(new HeadFilter(maxNumberOfFiles));
    }

    private static class HeadFilter
    implements FileListFilter<File> {
        private final int maxNumberOfFiles;

        public HeadFilter(int maxNumberOfFiles) {
            this.maxNumberOfFiles = maxNumberOfFiles;
        }

        public List<File> filterFiles(File[] files) {
            return Arrays.asList(files).subList(0, Math.min(files.length, this.maxNumberOfFiles));
        }
    }
}

