/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.config;

import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractPollingInboundChannelAdapterParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.file.config.FileListFilterFactoryBean;
import org.springframework.integration.file.config.FileReadingMessageSourceFactoryBean;
import org.springframework.integration.file.locking.NioFileLocker;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class FileInboundChannelAdapterParser
extends AbstractPollingInboundChannelAdapterParser {
    protected BeanMetadataElement parseSource(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(FileReadingMessageSourceFactoryBean.class);
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"comparator");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"scanner");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"directory");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"auto-create-directory");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"queue-size");
        String filterBeanName = this.registerFilter(element, parserContext);
        String lockerBeanName = this.registerLocker(element, parserContext);
        if (filterBeanName != null) {
            builder.addPropertyReference("filter", filterBeanName);
        }
        if (lockerBeanName != null) {
            builder.addPropertyReference("locker", lockerBeanName);
        }
        return builder.getBeanDefinition();
    }

    private String registerLocker(Element element, ParserContext parserContext) {
        String lockerBeanName = null;
        Element nioLocker = DomUtils.getChildElementByTagName((Element)element, (String)"nio-locker");
        if (nioLocker != null) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(NioFileLocker.class);
            lockerBeanName = BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)builder.getBeanDefinition(), (BeanDefinitionRegistry)parserContext.getRegistry());
        } else {
            Element locker = DomUtils.getChildElementByTagName((Element)element, (String)"locker");
            if (locker != null) {
                lockerBeanName = locker.getAttribute("ref");
            }
        }
        return lockerBeanName;
    }

    private String registerFilter(Element element, ParserContext parserContext) {
        String filenamePattern = element.getAttribute("filename-pattern");
        String filenameRegex = element.getAttribute("filename-regex");
        String preventDuplicates = element.getAttribute("prevent-duplicates");
        String ignoreHidden = element.getAttribute("ignore-hidden");
        if (!(StringUtils.hasText((String)filenamePattern) || StringUtils.hasText((String)filenameRegex) || StringUtils.hasText((String)preventDuplicates) || StringUtils.hasText((String)ignoreHidden))) {
            return null;
        }
        BeanDefinitionBuilder factoryBeanBuilder = BeanDefinitionBuilder.genericBeanDefinition(FileListFilterFactoryBean.class);
        factoryBeanBuilder.setRole(1);
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)factoryBeanBuilder, (Element)element, (String)"filter");
        if (StringUtils.hasText((String)filenamePattern)) {
            if (element.hasAttribute("filter")) {
                parserContext.getReaderContext().error("At most one of 'filter' and 'filename-pattern' may be provided.", (Object)element);
            }
            factoryBeanBuilder.addPropertyValue("filenamePattern", (Object)filenamePattern);
        }
        if (StringUtils.hasText((String)filenameRegex)) {
            if (element.hasAttribute("filter")) {
                parserContext.getReaderContext().error("At most one of 'filter' and 'filename-regex' may be provided.", (Object)element);
            }
            factoryBeanBuilder.addPropertyValue("filenameRegex", (Object)filenameRegex);
        }
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)factoryBeanBuilder, (Element)element, (String)"prevent-duplicates");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)factoryBeanBuilder, (Element)element, (String)"ignore-hidden");
        return BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)factoryBeanBuilder.getBeanDefinition(), (BeanDefinitionRegistry)parserContext.getRegistry());
    }
}

