/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.context.Lifecycle;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.file.DefaultFileNameGenerator;
import org.springframework.integration.file.FileNameGenerator;
import org.springframework.integration.file.support.FileExistsMode;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.handler.MessageTriggerAction;
import org.springframework.integration.support.locks.DefaultLockRegistry;
import org.springframework.integration.support.locks.LockRegistry;
import org.springframework.integration.support.locks.PassThruLockRegistry;
import org.springframework.integration.util.WhileLockedProcessor;
import org.springframework.lang.UsesJava7;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandlingException;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class FileWritingMessageHandler
extends AbstractReplyProducingMessageHandler
implements Lifecycle,
MessageTriggerAction {
    private static final boolean nioFilesPresent = ClassUtils.isPresent((String)"java.nio.file.Files", (ClassLoader)FileWritingMessageHandler.class.getClassLoader());
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private static final long DEFAULT_FLUSH_INTERVAL = 30000L;
    private final Map<String, FileState> fileStates = new HashMap<String, FileState>();
    private volatile String temporaryFileSuffix = ".writing";
    private volatile boolean temporaryFileSuffixSet = false;
    private volatile FileExistsMode fileExistsMode = FileExistsMode.REPLACE;
    private final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private volatile FileNameGenerator fileNameGenerator = new DefaultFileNameGenerator();
    private volatile boolean fileNameGeneratorSet;
    private volatile StandardEvaluationContext evaluationContext;
    private final Expression destinationDirectoryExpression;
    private volatile boolean autoCreateDirectory = true;
    private volatile boolean deleteSourceFiles;
    private volatile Charset charset = Charset.defaultCharset();
    private volatile boolean expectReply = true;
    private volatile boolean appendNewLine = false;
    private volatile LockRegistry lockRegistry = new PassThruLockRegistry();
    private volatile int bufferSize = 8192;
    private volatile long flushInterval = 30000L;
    private volatile ScheduledFuture<?> flushTask;
    private volatile MessageFlushPredicate flushPredicate = new DefaultFlushPredicate();
    private volatile boolean preserveTimestamp;

    public FileWritingMessageHandler(File destinationDirectory) {
        Assert.notNull((Object)destinationDirectory, (String)"Destination directory must not be null.");
        this.destinationDirectoryExpression = new LiteralExpression(destinationDirectory.getPath());
    }

    public FileWritingMessageHandler(Expression destinationDirectoryExpression) {
        Assert.notNull((Object)destinationDirectoryExpression, (String)"Destination directory expression must not be null.");
        this.destinationDirectoryExpression = destinationDirectoryExpression;
    }

    public void setAutoCreateDirectory(boolean autoCreateDirectory) {
        this.autoCreateDirectory = autoCreateDirectory;
    }

    public void setTemporaryFileSuffix(String temporaryFileSuffix) {
        Assert.notNull((Object)temporaryFileSuffix, (String)"'temporaryFileSuffix' must not be null");
        this.temporaryFileSuffix = temporaryFileSuffix;
        this.temporaryFileSuffixSet = true;
    }

    public void setFileExistsMode(FileExistsMode fileExistsMode) {
        Assert.notNull((Object)((Object)fileExistsMode), (String)"'fileExistsMode' must not be null.");
        this.fileExistsMode = fileExistsMode;
        if (FileExistsMode.APPEND.equals((Object)fileExistsMode) || FileExistsMode.APPEND_NO_FLUSH.equals((Object)this.fileExistsMode)) {
            this.lockRegistry = this.lockRegistry instanceof PassThruLockRegistry ? new DefaultLockRegistry() : this.lockRegistry;
        }
    }

    public void setExpectReply(boolean expectReply) {
        this.expectReply = expectReply;
    }

    public void setAppendNewLine(boolean appendNewLine) {
        this.appendNewLine = appendNewLine;
    }

    protected String getTemporaryFileSuffix() {
        return this.temporaryFileSuffix;
    }

    public void setFileNameGenerator(FileNameGenerator fileNameGenerator) {
        Assert.notNull((Object)fileNameGenerator, (String)"FileNameGenerator must not be null");
        this.fileNameGenerator = fileNameGenerator;
        this.fileNameGeneratorSet = true;
    }

    public void setDeleteSourceFiles(boolean deleteSourceFiles) {
        this.deleteSourceFiles = deleteSourceFiles;
    }

    public void setCharset(String charset) {
        Assert.notNull((Object)charset, (String)"charset must not be null");
        Assert.isTrue((boolean)Charset.isSupported(charset), (String)("Charset '" + charset + "' is not supported."));
        this.charset = Charset.forName(charset);
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setFlushInterval(long flushInterval) {
        this.flushInterval = flushInterval;
    }

    public void setTaskScheduler(TaskScheduler taskScheduler) {
        super.setTaskScheduler(taskScheduler);
    }

    public void setFlushPredicate(MessageFlushPredicate flushPredicate) {
        Assert.notNull((Object)flushPredicate, (String)"'flushPredicate' cannot be null");
        this.flushPredicate = flushPredicate;
    }

    public void setPreserveTimestamp(boolean preserveTimestamp) {
        this.preserveTimestamp = preserveTimestamp;
    }

    protected void doInit() {
        this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.getBeanFactory());
        if (this.destinationDirectoryExpression instanceof LiteralExpression) {
            File directory = new File((String)this.destinationDirectoryExpression.getValue((EvaluationContext)this.evaluationContext, null, String.class));
            this.validateDestinationDirectory(directory, this.autoCreateDirectory);
        }
        Assert.state((!this.temporaryFileSuffixSet || !FileExistsMode.APPEND.equals((Object)this.fileExistsMode) && !FileExistsMode.APPEND_NO_FLUSH.equals((Object)this.fileExistsMode) ? 1 : 0) != 0, (String)"'temporaryFileSuffix' can not be set when appending to an existing file");
        if (!this.fileNameGeneratorSet && this.fileNameGenerator instanceof BeanFactoryAware) {
            ((BeanFactoryAware)this.fileNameGenerator).setBeanFactory(this.getBeanFactory());
        }
    }

    public void start() {
        if (FileExistsMode.APPEND_NO_FLUSH.equals((Object)this.fileExistsMode)) {
            TaskScheduler taskScheduler = this.getTaskScheduler();
            Assert.state((taskScheduler != null ? 1 : 0) != 0, (String)"'taskScheduler' is required for FileExistsMode.APPEND_NO_FLUSH");
            this.flushTask = taskScheduler.scheduleAtFixedRate((Runnable)new Flusher(), this.flushInterval / 3L);
        }
    }

    public void stop() {
        if (this.flushTask != null) {
            this.flushTask.cancel(true);
            this.flushTask = null;
        }
        new Flusher().run();
    }

    public boolean isRunning() {
        return this.flushTask != null;
    }

    private void validateDestinationDirectory(File destinationDirectory, boolean autoCreateDirectory) {
        if (!destinationDirectory.exists() && autoCreateDirectory) {
            Assert.isTrue((boolean)destinationDirectory.mkdirs(), (String)("Destination directory [" + destinationDirectory + "] could not be created."));
        }
        Assert.isTrue((boolean)destinationDirectory.exists(), (String)("Destination directory [" + destinationDirectory + "] does not exist."));
        Assert.isTrue((boolean)destinationDirectory.isDirectory(), (String)("Destination path [" + destinationDirectory + "] does not point to a directory."));
        Assert.isTrue((boolean)destinationDirectory.canWrite(), (String)("Destination directory [" + destinationDirectory + "] is not writable."));
    }

    protected Object handleRequestMessage(Message<?> requestMessage) {
        boolean ignore;
        Assert.notNull(requestMessage, (String)"message must not be null");
        Object payload = requestMessage.getPayload();
        Assert.notNull((Object)payload, (String)"message payload must not be null");
        String generatedFileName = this.fileNameGenerator.generateFileName(requestMessage);
        File originalFileFromHeader = this.retrieveOriginalFileFromHeader(requestMessage);
        File destinationDirectoryToUse = this.evaluateDestinationDirectoryExpression(requestMessage);
        File tempFile = new File(destinationDirectoryToUse, generatedFileName + this.temporaryFileSuffix);
        File resultFile = new File(destinationDirectoryToUse, generatedFileName);
        if (FileExistsMode.FAIL.equals((Object)this.fileExistsMode) && resultFile.exists()) {
            throw new MessageHandlingException(requestMessage, "The destination file already exists at '" + resultFile.getAbsolutePath() + "'.");
        }
        boolean bl = ignore = FileExistsMode.IGNORE.equals((Object)this.fileExistsMode) && (resultFile.exists() || StringUtils.hasText((String)this.temporaryFileSuffix) && tempFile.exists());
        if (!ignore) {
            try {
                Object timestamp = requestMessage.getHeaders().get((Object)"file_setModified");
                if (!resultFile.exists() && generatedFileName.replaceAll("/", Matcher.quoteReplacement(File.separator)).contains(File.separator)) {
                    resultFile.getParentFile().mkdirs();
                }
                if (payload instanceof File) {
                    resultFile = this.handleFileMessage((File)payload, tempFile, resultFile);
                    timestamp = ((File)payload).lastModified();
                } else if (payload instanceof InputStream) {
                    resultFile = this.handleInputStreamMessage((InputStream)payload, originalFileFromHeader, tempFile, resultFile);
                } else if (payload instanceof byte[]) {
                    resultFile = this.handleByteArrayMessage((byte[])payload, originalFileFromHeader, tempFile, resultFile);
                } else if (payload instanceof String) {
                    resultFile = this.handleStringMessage((String)payload, originalFileFromHeader, tempFile, resultFile);
                } else {
                    throw new IllegalArgumentException("unsupported Message payload type [" + payload.getClass().getName() + "]");
                }
                if (this.preserveTimestamp) {
                    if (timestamp instanceof Number) {
                        resultFile.setLastModified(((Number)timestamp).longValue());
                    } else if (this.logger.isWarnEnabled()) {
                        this.logger.warn((Object)("Could not set lastModified, header file_setModified must be a Number, not " + timestamp.getClass()));
                    }
                }
            }
            catch (Exception e) {
                throw new MessageHandlingException(requestMessage, "failed to write Message payload to file", (Throwable)e);
            }
        }
        if (!this.expectReply) {
            return null;
        }
        if (resultFile != null && originalFileFromHeader == null && payload instanceof File) {
            return this.getMessageBuilderFactory().withPayload((Object)resultFile).setHeader("file_originalFile", payload);
        }
        return resultFile;
    }

    private File retrieveOriginalFileFromHeader(Message<?> message) {
        Object value = message.getHeaders().get((Object)"file_originalFile");
        if (value instanceof File) {
            return (File)value;
        }
        if (value instanceof String) {
            return new File((String)value);
        }
        return null;
    }

    private File handleFileMessage(File sourceFile, File tempFile, File resultFile) throws IOException {
        if (!FileExistsMode.APPEND.equals((Object)this.fileExistsMode) && this.deleteSourceFiles) {
            if (FileWritingMessageHandler.rename(sourceFile, resultFile)) {
                return resultFile;
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)String.format("Failed to move file '%s'. Using copy and delete fallback.", sourceFile.getAbsolutePath()));
            }
        }
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(sourceFile));
        return this.handleInputStreamMessage(bis, sourceFile, tempFile, resultFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File handleInputStreamMessage(final InputStream sourceFileInputStream, File originalFile, File tempFile, File resultFile) throws IOException {
        boolean append;
        boolean bl = append = FileExistsMode.APPEND.equals((Object)this.fileExistsMode) || FileExistsMode.APPEND_NO_FLUSH.equals((Object)this.fileExistsMode);
        if (append) {
            final File fileToWriteTo = this.determineFileToWrite(resultFile, tempFile);
            final FileState state = this.getFileState(fileToWriteTo, false);
            WhileLockedProcessor whileLockedProcessor = new WhileLockedProcessor(this.lockRegistry, fileToWriteTo.getAbsolutePath()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void whileLocked() throws IOException {
                    BufferedOutputStream bos = state != null ? state.stream : FileWritingMessageHandler.this.createOutputStream(fileToWriteTo, true);
                    try {
                        byte[] buffer = new byte[4096];
                        int bytesRead = -1;
                        while ((bytesRead = sourceFileInputStream.read(buffer)) != -1) {
                            bos.write(buffer, 0, bytesRead);
                        }
                        if (FileWritingMessageHandler.this.appendNewLine) {
                            bos.write(LINE_SEPARATOR.getBytes());
                        }
                    }
                    finally {
                        try {
                            sourceFileInputStream.close();
                        }
                        catch (IOException iOException) {}
                        try {
                            if (state == null || FileWritingMessageHandler.this.flushTask == null) {
                                bos.close();
                                FileWritingMessageHandler.this.clearState(fileToWriteTo, state);
                            } else {
                                state.lastWrite = System.currentTimeMillis();
                            }
                        }
                        catch (IOException iOException) {}
                    }
                }
            };
            whileLockedProcessor.doWhileLocked();
            this.cleanUpAfterCopy(fileToWriteTo, resultFile, originalFile);
            return resultFile;
        }
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(tempFile), this.bufferSize);
        try {
            byte[] buffer = new byte[4096];
            int bytesRead = -1;
            while ((bytesRead = sourceFileInputStream.read(buffer)) != -1) {
                bos.write(buffer, 0, bytesRead);
            }
            if (this.appendNewLine) {
                bos.write(LINE_SEPARATOR.getBytes());
            }
            bos.flush();
        }
        finally {
            try {
                sourceFileInputStream.close();
            }
            catch (IOException iOException) {}
            try {
                bos.close();
            }
            catch (IOException iOException) {}
        }
        this.cleanUpAfterCopy(tempFile, resultFile, originalFile);
        return resultFile;
    }

    private File handleByteArrayMessage(final byte[] bytes, File originalFile, File tempFile, File resultFile) throws IOException {
        final File fileToWriteTo = this.determineFileToWrite(resultFile, tempFile);
        final FileState state = this.getFileState(fileToWriteTo, false);
        final boolean append = FileExistsMode.APPEND.equals((Object)this.fileExistsMode);
        WhileLockedProcessor whileLockedProcessor = new WhileLockedProcessor(this.lockRegistry, fileToWriteTo.getAbsolutePath()){

            protected void whileLocked() throws IOException {
                BufferedOutputStream bos = state != null ? state.stream : FileWritingMessageHandler.this.createOutputStream(fileToWriteTo, append);
                try {
                    bos.write(bytes);
                    if (FileWritingMessageHandler.this.appendNewLine) {
                        bos.write(LINE_SEPARATOR.getBytes());
                    }
                }
                finally {
                    try {
                        if (state == null || FileWritingMessageHandler.this.flushTask == null) {
                            bos.close();
                            FileWritingMessageHandler.this.clearState(fileToWriteTo, state);
                        } else {
                            state.lastWrite = System.currentTimeMillis();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
        };
        whileLockedProcessor.doWhileLocked();
        this.cleanUpAfterCopy(fileToWriteTo, resultFile, originalFile);
        return resultFile;
    }

    private File handleStringMessage(final String content, File originalFile, File tempFile, File resultFile) throws IOException {
        final File fileToWriteTo = this.determineFileToWrite(resultFile, tempFile);
        final FileState state = this.getFileState(fileToWriteTo, true);
        final boolean append = FileExistsMode.APPEND.equals((Object)this.fileExistsMode);
        WhileLockedProcessor whileLockedProcessor = new WhileLockedProcessor(this.lockRegistry, fileToWriteTo.getAbsolutePath()){

            protected void whileLocked() throws IOException {
                BufferedWriter writer = state != null ? state.writer : FileWritingMessageHandler.this.createWriter(fileToWriteTo, append);
                try {
                    writer.write(content);
                    if (FileWritingMessageHandler.this.appendNewLine) {
                        writer.newLine();
                    }
                }
                finally {
                    try {
                        if (state == null || FileWritingMessageHandler.this.flushTask == null) {
                            writer.close();
                            FileWritingMessageHandler.this.clearState(fileToWriteTo, state);
                        } else {
                            state.lastWrite = System.currentTimeMillis();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
        };
        whileLockedProcessor.doWhileLocked();
        this.cleanUpAfterCopy(fileToWriteTo, resultFile, originalFile);
        return resultFile;
    }

    private File determineFileToWrite(File resultFile, File tempFile) {
        File fileToWriteTo;
        switch (this.fileExistsMode) {
            case APPEND: 
            case APPEND_NO_FLUSH: {
                fileToWriteTo = resultFile;
                break;
            }
            case FAIL: 
            case IGNORE: 
            case REPLACE: {
                fileToWriteTo = tempFile;
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported FileExistsMode " + (Object)((Object)this.fileExistsMode));
            }
        }
        return fileToWriteTo;
    }

    private void cleanUpAfterCopy(File fileToWriteTo, File resultFile, File originalFile) throws IOException {
        if (!FileExistsMode.APPEND.equals((Object)this.fileExistsMode) && !FileExistsMode.APPEND_NO_FLUSH.equals((Object)this.fileExistsMode) && StringUtils.hasText((String)this.temporaryFileSuffix)) {
            this.renameTo(fileToWriteTo, resultFile);
        }
        if (this.deleteSourceFiles && originalFile != null) {
            originalFile.delete();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void renameTo(File tempFile, File resultFile) throws IOException {
        Assert.notNull((Object)resultFile, (String)"'resultFile' must not be null");
        Assert.notNull((Object)tempFile, (String)"'tempFile' must not be null");
        if (resultFile.exists()) {
            if (!resultFile.setWritable(true, false) || !resultFile.delete()) throw new IOException("Failed to rename file '" + tempFile.getAbsolutePath() + "' to '" + resultFile.getAbsolutePath() + "' since '" + resultFile.getName() + "' is not writable or can not be deleted");
            if (FileWritingMessageHandler.rename(tempFile, resultFile)) return;
            throw new IOException("Failed to rename file '" + tempFile.getAbsolutePath() + "' to '" + resultFile.getAbsolutePath() + "'");
        }
        if (FileWritingMessageHandler.rename(tempFile, resultFile)) return;
        throw new IOException("Failed to rename file '" + tempFile.getAbsolutePath() + "' to '" + resultFile.getAbsolutePath() + "'");
    }

    private File evaluateDestinationDirectoryExpression(Message<?> message) {
        File destinationDirectory;
        Object destinationDirectoryToUse = this.destinationDirectoryExpression.getValue((EvaluationContext)this.evaluationContext, message);
        if (destinationDirectoryToUse == null) {
            throw new IllegalStateException(String.format("The provided destinationDirectoryExpression (%s) must not resolve to null.", this.destinationDirectoryExpression.getExpressionString()));
        }
        if (destinationDirectoryToUse instanceof String) {
            String destinationDirectoryPath = (String)destinationDirectoryToUse;
            Assert.hasText((String)destinationDirectoryPath, (String)String.format("Unable to resolve destination directory name for the provided Expression '%s'.", this.destinationDirectoryExpression.getExpressionString()));
            destinationDirectory = new File(destinationDirectoryPath);
        } else if (destinationDirectoryToUse instanceof File) {
            destinationDirectory = (File)destinationDirectoryToUse;
        } else {
            throw new IllegalStateException(String.format("The provided destinationDirectoryExpression (%s) must be of type java.io.File or be a String.", this.destinationDirectoryExpression.getExpressionString()));
        }
        this.validateDestinationDirectory(destinationDirectory, this.autoCreateDirectory);
        return destinationDirectory;
    }

    private synchronized FileState getFileState(File fileToWriteTo, boolean isString) throws FileNotFoundException {
        FileState state;
        String absolutePath = fileToWriteTo.getAbsolutePath();
        boolean appendNoFlush = FileExistsMode.APPEND_NO_FLUSH.equals((Object)this.fileExistsMode);
        if (appendNoFlush) {
            state = this.fileStates.get(absolutePath);
            if (state != null && (isString && state.stream != null || !isString && state.writer != null)) {
                state.close();
                state = null;
                this.fileStates.remove(absolutePath);
            }
            if (state == null) {
                state = isString ? new FileState(this.createWriter(fileToWriteTo, true)) : new FileState(this.createOutputStream(fileToWriteTo, true));
                this.fileStates.put(absolutePath, state);
            }
            state.lastWrite = Long.MAX_VALUE;
        } else {
            state = null;
        }
        return state;
    }

    private BufferedWriter createWriter(File fileToWriteTo, boolean append) throws FileNotFoundException {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fileToWriteTo, append), this.charset), this.bufferSize);
    }

    private BufferedOutputStream createOutputStream(File fileToWriteTo, boolean append) throws FileNotFoundException {
        return new BufferedOutputStream(new FileOutputStream(fileToWriteTo, append), this.bufferSize);
    }

    public void trigger(Message<?> message) {
        this.flushIfNeeded(this.flushPredicate, message);
    }

    public synchronized void flushIfNeeded(FlushPredicate flushPredicate) {
        Iterator<Map.Entry<String, FileState>> iterator = this.fileStates.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, FileState> entry = iterator.next();
            FileState state = entry.getValue();
            if (!flushPredicate.shouldFlush(entry.getKey(), state.lastWrite)) continue;
            iterator.remove();
            state.close();
        }
    }

    public synchronized void flushIfNeeded(MessageFlushPredicate flushPredicate, Message<?> filterMessage) {
        Iterator<Map.Entry<String, FileState>> iterator = this.fileStates.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, FileState> entry = iterator.next();
            FileState state = entry.getValue();
            if (!flushPredicate.shouldFlush(entry.getKey(), state.lastWrite, filterMessage)) continue;
            iterator.remove();
            state.close();
        }
    }

    private synchronized void clearState(File fileToWriteTo, FileState state) {
        if (state != null) {
            this.fileStates.remove(fileToWriteTo.getAbsolutePath());
        }
    }

    private static boolean rename(File source, File target) throws IOException {
        return nioFilesPresent && FileWritingMessageHandler.filesMove(source, target) || source.renameTo(target);
    }

    @UsesJava7
    private static boolean filesMove(File source, File target) throws IOException {
        Files.move(source.toPath(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
        return true;
    }

    private static final class DefaultFlushPredicate
    implements MessageFlushPredicate {
        private DefaultFlushPredicate() {
        }

        @Override
        public boolean shouldFlush(String fileAbsolutePath, long lastWrite, Message<?> triggerMessage) {
            Pattern pattern;
            if (triggerMessage.getPayload() instanceof String) {
                pattern = Pattern.compile((String)triggerMessage.getPayload());
            } else if (triggerMessage.getPayload() instanceof Pattern) {
                pattern = (Pattern)triggerMessage.getPayload();
            } else {
                throw new IllegalArgumentException("Invalid payload type, must be a String or Pattern");
            }
            return pattern.matcher(fileAbsolutePath).matches();
        }
    }

    public static interface MessageFlushPredicate {
        public boolean shouldFlush(String var1, long var2, Message<?> var4);
    }

    public static interface FlushPredicate {
        public boolean shouldFlush(String var1, long var2);
    }

    private final class Flusher
    implements Runnable {
        private Flusher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            FileWritingMessageHandler fileWritingMessageHandler = FileWritingMessageHandler.this;
            synchronized (fileWritingMessageHandler) {
                long expired = FileWritingMessageHandler.this.flushTask == null ? Long.MAX_VALUE : System.currentTimeMillis() - FileWritingMessageHandler.this.flushInterval;
                Iterator iterator = FileWritingMessageHandler.this.fileStates.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    FileState state = (FileState)entry.getValue();
                    if (state.lastWrite >= expired) continue;
                    iterator.remove();
                    state.close();
                    if (!FileWritingMessageHandler.this.logger.isDebugEnabled()) continue;
                    FileWritingMessageHandler.this.logger.debug((Object)("Flushed: " + (String)entry.getKey()));
                }
            }
        }
    }

    private static final class FileState {
        private final BufferedWriter writer;
        private final BufferedOutputStream stream;
        private volatile long lastWrite;

        private FileState(BufferedWriter writer) {
            this.writer = writer;
            this.stream = null;
        }

        private FileState(BufferedOutputStream stream) {
            this.writer = null;
            this.stream = stream;
        }

        private void close() {
            try {
                if (this.writer != null) {
                    this.writer.close();
                } else {
                    this.stream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

