/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.remote.gateway;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.expression.FunctionExpression;
import org.springframework.integration.expression.ValueExpression;
import org.springframework.integration.file.filters.FileListFilter;
import org.springframework.integration.file.remote.AbstractFileInfo;
import org.springframework.integration.file.remote.MessageSessionCallback;
import org.springframework.integration.file.remote.RemoteFileOperations;
import org.springframework.integration.file.remote.RemoteFileTemplate;
import org.springframework.integration.file.remote.RemoteFileUtils;
import org.springframework.integration.file.remote.session.Session;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.integration.file.support.FileExistsMode;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.handler.ExpressionEvaluatingMessageProcessor;
import org.springframework.integration.support.MutableMessage;
import org.springframework.integration.support.PartialSuccessException;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandlingException;
import org.springframework.messaging.MessagingException;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractRemoteFileOutboundGateway<F>
extends AbstractReplyProducingMessageHandler {
    protected final RemoteFileTemplate<F> remoteFileTemplate;
    protected final Command command;
    private final ExpressionEvaluatingMessageProcessor<String> fileNameProcessor;
    private final MessageSessionCallback<F, ?> messageSessionCallback;
    protected final Set<Option> options = new HashSet<Option>();
    private volatile ExpressionEvaluatingMessageProcessor<String> renameProcessor = new ExpressionEvaluatingMessageProcessor((Expression)new FunctionExpression(m -> m.getHeaders().get((Object)"file_renameTo")));
    private volatile Expression localDirectoryExpression;
    private volatile boolean autoCreateLocalDirectory = true;
    private volatile FileListFilter<F> filter;
    private volatile FileListFilter<File> mputFilter;
    private volatile Expression localFilenameGeneratorExpression;
    private volatile FileExistsMode fileExistsMode;
    private volatile Integer chmod;

    public AbstractRemoteFileOutboundGateway(SessionFactory<F> sessionFactory, MessageSessionCallback<F, ?> messageSessionCallback) {
        this(new RemoteFileTemplate<F>(sessionFactory), messageSessionCallback);
    }

    public AbstractRemoteFileOutboundGateway(RemoteFileTemplate<F> remoteFileTemplate, MessageSessionCallback<F, ?> messageSessionCallback) {
        Assert.notNull(remoteFileTemplate, (String)"'remoteFileTemplate' cannot be null");
        Assert.notNull(messageSessionCallback, (String)"'messageSessionCallback' cannot be null");
        this.remoteFileTemplate = remoteFileTemplate;
        this.messageSessionCallback = messageSessionCallback;
        this.fileNameProcessor = null;
        this.command = null;
    }

    public AbstractRemoteFileOutboundGateway(SessionFactory<F> sessionFactory, String command, String expression) {
        this(sessionFactory, Command.toCommand(command), expression);
    }

    public AbstractRemoteFileOutboundGateway(SessionFactory<F> sessionFactory, Command command, String expression) {
        this(new RemoteFileTemplate<F>(sessionFactory), command, expression);
    }

    public AbstractRemoteFileOutboundGateway(RemoteFileTemplate<F> remoteFileTemplate, String command, String expression) {
        this(remoteFileTemplate, Command.toCommand(command), expression);
    }

    public AbstractRemoteFileOutboundGateway(RemoteFileTemplate<F> remoteFileTemplate, Command command, String expression) {
        Assert.notNull(remoteFileTemplate, (String)"'remoteFileTemplate' cannot be null");
        this.remoteFileTemplate = remoteFileTemplate;
        this.command = command;
        Expression parsedExpression = new SpelExpressionParser().parseExpression(expression);
        this.fileNameProcessor = new ExpressionEvaluatingMessageProcessor(parsedExpression);
        this.messageSessionCallback = null;
        this.setPrimaryExpression(parsedExpression);
    }

    public void setOptions(String options) {
        Assert.hasText((String)options, (String)"'options' must not be empty.");
        this.options.clear();
        Arrays.stream(options.split("\\s")).filter(StringUtils::hasText).map(s -> Option.toOption(s.trim())).forEach(this.options::add);
    }

    public void setOption(Option ... options) {
        Assert.notNull((Object)options, (String)"'options' must not be null");
        Assert.noNullElements((Object[])options, (String)"'options' cannot contain null element");
        this.options.clear();
        Collections.addAll(this.options, options);
    }

    public void setRemoteFileSeparator(String remoteFileSeparator) {
        this.remoteFileTemplate.setRemoteFileSeparator(remoteFileSeparator);
    }

    public void setLocalDirectory(File localDirectory) {
        if (localDirectory != null) {
            this.localDirectoryExpression = new ValueExpression((Object)localDirectory);
        }
    }

    public void setLocalDirectoryExpression(Expression localDirectoryExpression) {
        this.localDirectoryExpression = localDirectoryExpression;
    }

    public void setLocalDirectoryExpressionString(String localDirectoryExpression) {
        this.localDirectoryExpression = EXPRESSION_PARSER.parseExpression(localDirectoryExpression);
    }

    public void setAutoCreateLocalDirectory(boolean autoCreateLocalDirectory) {
        this.autoCreateLocalDirectory = autoCreateLocalDirectory;
    }

    public void setTemporaryFileSuffix(String temporaryFileSuffix) {
        this.remoteFileTemplate.setTemporaryFileSuffix(temporaryFileSuffix);
    }

    public void setFilter(FileListFilter<F> filter) {
        this.filter = filter;
    }

    public void setMputFilter(FileListFilter<File> filter) {
        this.mputFilter = filter;
    }

    public void setRenameExpression(Expression renameExpression) {
        this.renameProcessor = new ExpressionEvaluatingMessageProcessor(renameExpression);
    }

    public void setRenameExpressionString(String renameExpression) {
        Assert.hasText((String)renameExpression, (String)"'renameExpression' cannot be empty");
        this.setRenameExpression(EXPRESSION_PARSER.parseExpression(renameExpression));
    }

    public void setLocalFilenameGeneratorExpression(Expression localFilenameGeneratorExpression) {
        Assert.notNull((Object)localFilenameGeneratorExpression, (String)"'localFilenameGeneratorExpression' must not be null");
        this.localFilenameGeneratorExpression = localFilenameGeneratorExpression;
    }

    public void setLocalFilenameGeneratorExpressionString(String localFilenameGeneratorExpression) {
        Assert.hasText((String)localFilenameGeneratorExpression, (String)"'localFilenameGeneratorExpression' must not be empty");
        this.localFilenameGeneratorExpression = EXPRESSION_PARSER.parseExpression(localFilenameGeneratorExpression);
    }

    public void setFileExistsMode(FileExistsMode fileExistsMode) {
        this.fileExistsMode = fileExistsMode;
        if (FileExistsMode.APPEND.equals((Object)fileExistsMode)) {
            this.remoteFileTemplate.setUseTemporaryFileName(false);
        }
    }

    public void setChmodOctal(String chmod) {
        Assert.notNull((Object)chmod, (String)"'chmod' cannot be null");
        this.setChmod(Integer.parseInt(chmod, 8));
    }

    public void setChmod(int chmod) {
        Assert.isTrue((boolean)this.isChmodCapable(), (String)"chmod operations not supported");
        this.chmod = chmod;
    }

    public boolean isChmodCapable() {
        return false;
    }

    protected void doInit() {
        block11: {
            Assert.state((this.command != null || this.messageSessionCallback != null ? 1 : 0) != 0, (String)"'command' or 'messageSessionCallback' must be specified.");
            if (Command.RM.equals((Object)this.command) || Command.GET.equals((Object)this.command)) {
                Assert.isNull(this.filter, (String)"Filters are not supported with the rm and get commands");
            }
            if (Command.GET.equals((Object)this.command) && !this.options.contains((Object)Option.STREAM) || Command.MGET.equals((Object)this.command)) {
                Assert.notNull((Object)this.localDirectoryExpression, (String)"localDirectory must not be null");
                if (this.localDirectoryExpression instanceof ValueExpression) {
                    File localDirectory = (File)this.localDirectoryExpression.getValue(File.class);
                    try {
                        if (localDirectory.exists()) break block11;
                        if (this.autoCreateLocalDirectory) {
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug((Object)("The '" + localDirectory + "' directory doesn't exist; Will create."));
                            }
                            if (!localDirectory.mkdirs()) {
                                throw new IOException("Failed to make local directory: " + localDirectory);
                            }
                            break block11;
                        }
                        throw new FileNotFoundException(localDirectory.getName());
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new MessagingException("Failure during initialization of: " + this.getComponentType(), (Throwable)e);
                    }
                }
            }
        }
        if (Command.MGET.equals((Object)this.command)) {
            Assert.isTrue((!this.options.contains((Object)Option.SUBDIRS) ? 1 : 0) != 0, (String)("Cannot use " + Option.SUBDIRS.toString() + " when using 'mget' use " + Option.RECURSIVE.toString() + " to obtain files in subdirectories"));
        }
        if (this.fileNameProcessor != null && this.getBeanFactory() != null) {
            this.fileNameProcessor.setBeanFactory(this.getBeanFactory());
            this.renameProcessor.setBeanFactory(this.getBeanFactory());
            this.remoteFileTemplate.setBeanFactory(this.getBeanFactory());
        }
    }

    protected Object handleRequestMessage(Message<?> requestMessage) {
        if (this.command != null) {
            switch (this.command) {
                case LS: {
                    return this.doLs(requestMessage);
                }
                case NLST: {
                    return this.doNlst(requestMessage);
                }
                case GET: {
                    return this.doGet(requestMessage);
                }
                case MGET: {
                    return this.doMget(requestMessage);
                }
                case RM: {
                    return this.doRm(requestMessage);
                }
                case MV: {
                    return this.doMv(requestMessage);
                }
                case PUT: {
                    return this.doPut(requestMessage);
                }
                case MPUT: {
                    return this.doMput(requestMessage);
                }
            }
        }
        return this.remoteFileTemplate.execute(session -> this.messageSessionCallback.doInSession(session, requestMessage));
    }

    private Object doLs(Message<?> requestMessage) {
        String dir = (String)this.fileNameProcessor.processMessage(requestMessage);
        if (dir != null && !dir.endsWith(this.remoteFileTemplate.getRemoteFileSeparator())) {
            dir = dir + this.remoteFileTemplate.getRemoteFileSeparator();
        }
        String fullDir = dir;
        List payload = this.remoteFileTemplate.execute(session -> this.ls(requestMessage, session, fullDir));
        return this.getMessageBuilderFactory().withPayload((Object)payload).setHeader("file_remoteDirectory", (Object)dir);
    }

    private Object doNlst(Message<?> requestMessage) {
        String dir = (String)this.fileNameProcessor.processMessage(requestMessage);
        if (dir != null && !dir.endsWith(this.remoteFileTemplate.getRemoteFileSeparator())) {
            dir = dir + this.remoteFileTemplate.getRemoteFileSeparator();
        }
        String fullDir = dir;
        List payload = this.remoteFileTemplate.execute(session -> this.nlst(requestMessage, session, fullDir));
        return this.getMessageBuilderFactory().withPayload((Object)payload).setHeader("file_remoteDirectory", (Object)dir);
    }

    protected List<String> nlst(Message<?> message, Session<F> session, String dir) throws IOException {
        String remoteDirectory = this.buildRemotePath(dir, "");
        List<String> fileNames = Arrays.asList(session.listNames(remoteDirectory));
        if (!this.options.contains((Object)Option.NOSORT)) {
            Collections.sort(fileNames);
        }
        return fileNames;
    }

    private Object doGet(Message<?> requestMessage) {
        Object payload;
        String remoteFilePath = (String)this.fileNameProcessor.processMessage(requestMessage);
        String remoteFilename = this.getRemoteFilename(remoteFilePath);
        String remoteDir = this.getRemoteDirectory(remoteFilePath, remoteFilename);
        Session<F> session = null;
        if (this.options.contains((Object)Option.STREAM)) {
            session = this.remoteFileTemplate.getSessionFactory().getSession();
            try {
                payload = session.readRaw(remoteFilePath);
            }
            catch (IOException e) {
                throw new MessageHandlingException(requestMessage, "Failed to get the remote file [" + remoteFilePath + "] as a stream", (Throwable)e);
            }
        } else {
            payload = this.remoteFileTemplate.execute(session1 -> this.get(requestMessage, session1, remoteDir, remoteFilePath, remoteFilename, null));
        }
        return this.getMessageBuilderFactory().withPayload(payload).setHeader("file_remoteDirectory", (Object)remoteDir).setHeader("file_remoteFile", (Object)remoteFilename).setHeader("closeableResource", session);
    }

    private Object doMget(Message<?> requestMessage) {
        String remoteFilePath = (String)this.fileNameProcessor.processMessage(requestMessage);
        String remoteFilename = this.getRemoteFilename(remoteFilePath);
        String remoteDir = this.getRemoteDirectory(remoteFilePath, remoteFilename);
        List payload = this.remoteFileTemplate.execute(session -> this.mGet(requestMessage, session, remoteDir, remoteFilename));
        return this.getMessageBuilderFactory().withPayload((Object)payload).setHeader("file_remoteDirectory", (Object)remoteDir).setHeader("file_remoteFile", (Object)remoteFilename);
    }

    private Object doRm(Message<?> requestMessage) {
        String remoteFilePath = (String)this.fileNameProcessor.processMessage(requestMessage);
        String remoteFilename = this.getRemoteFilename(remoteFilePath);
        String remoteDir = this.getRemoteDirectory(remoteFilePath, remoteFilename);
        boolean payload = this.remoteFileTemplate.execute(session -> this.rm(requestMessage, session, remoteFilePath));
        return this.getMessageBuilderFactory().withPayload((Object)payload).setHeader("file_remoteDirectory", (Object)remoteDir).setHeader("file_remoteFile", (Object)remoteFilename);
    }

    protected boolean rm(Message<?> message, Session<F> session, String remoteFilePath) throws IOException {
        return session.remove(remoteFilePath);
    }

    private Object doMv(Message<?> requestMessage) {
        String remoteFilePath = (String)this.fileNameProcessor.processMessage(requestMessage);
        String remoteFilename = this.getRemoteFilename(remoteFilePath);
        String remoteDir = this.getRemoteDirectory(remoteFilePath, remoteFilename);
        String remoteFileNewPath = (String)this.renameProcessor.processMessage(requestMessage);
        Assert.hasLength((String)remoteFileNewPath, (String)"New filename cannot be empty");
        Boolean result = this.remoteFileTemplate.execute(session -> this.mv(requestMessage, session, remoteFilePath, remoteFileNewPath));
        return this.getMessageBuilderFactory().withPayload((Object)result).setHeader("file_remoteDirectory", (Object)remoteDir).setHeader("file_remoteFile", (Object)remoteFilename).setHeader("file_renameTo", (Object)remoteFileNewPath);
    }

    protected boolean mv(Message<?> message, Session<F> session, String remoteFilePath, String remoteFileNewPath) throws IOException {
        int lastSeparator = remoteFileNewPath.lastIndexOf(this.remoteFileTemplate.getRemoteFileSeparator());
        if (lastSeparator > 0) {
            String remoteFileDirectory = remoteFileNewPath.substring(0, lastSeparator + 1);
            RemoteFileUtils.makeDirectories(remoteFileDirectory, session, this.remoteFileTemplate.getRemoteFileSeparator(), this.logger);
        }
        session.rename(remoteFilePath, remoteFileNewPath);
        return true;
    }

    private String doPut(Message<?> requestMessage) {
        return this.doPut(requestMessage, null);
    }

    private String doPut(Message<?> requestMessage, String subDirectory) {
        return this.remoteFileTemplate.invoke(template -> this.put(requestMessage, template.getSession(), subDirectory));
    }

    protected String put(Message<?> message, Session<F> session, String subDirectory) {
        String path = this.remoteFileTemplate.send(message, subDirectory, new FileExistsMode[]{this.fileExistsMode});
        if (path == null) {
            throw new MessagingException(message, "No local file found for " + message);
        }
        if (this.chmod != null && this.isChmodCapable()) {
            this.doChmod(this.remoteFileTemplate, path, this.chmod);
        }
        return path;
    }

    protected void doChmod(RemoteFileOperations<F> remoteFileOperations, String path, int chmod) {
    }

    private Object doMput(Message<?> requestMessage) {
        File file = null;
        if (requestMessage.getPayload() instanceof File) {
            file = (File)requestMessage.getPayload();
        } else if (requestMessage.getPayload() instanceof String) {
            file = new File((String)requestMessage.getPayload());
        } else {
            throw new IllegalArgumentException("Only File or String payloads allowed for 'mput'");
        }
        if (!file.isDirectory()) {
            return this.doPut(requestMessage);
        }
        File localDir = file;
        return this.remoteFileTemplate.invoke(t -> this.mPut(requestMessage, t.getSession(), localDir));
    }

    protected List<String> mPut(Message<?> message, Session<F> session, File localDir) {
        return this.putLocalDirectory(message, localDir, null);
    }

    private List<String> putLocalDirectory(Message<?> requestMessage, File file, String subDirectory) {
        File[] files = file.listFiles();
        List<File> filteredFiles = this.filterMputFiles(files);
        ArrayList<String> replies = new ArrayList<String>();
        try {
            for (File filteredFile : filteredFiles) {
                if (!filteredFile.isDirectory()) {
                    String path = this.doPut((Message<?>)new MutableMessage((Object)filteredFile, (Map)requestMessage.getHeaders()), subDirectory);
                    if (path == null) {
                        if (!this.logger.isDebugEnabled()) continue;
                        this.logger.debug((Object)("File " + filteredFile.getAbsolutePath() + " removed before transfer; ignoring"));
                        continue;
                    }
                    replies.add(path);
                    continue;
                }
                if (!this.options.contains((Object)Option.RECURSIVE)) continue;
                String newSubDirectory = (StringUtils.hasText((String)subDirectory) ? subDirectory + this.remoteFileTemplate.getRemoteFileSeparator() : "") + filteredFile.getName();
                replies.addAll(this.putLocalDirectory(requestMessage, filteredFile, newSubDirectory));
            }
        }
        catch (Exception e) {
            if (replies.size() > 0) {
                throw new PartialSuccessException(requestMessage, "Partially successful 'mput' operation" + (subDirectory == null ? "" : " on " + subDirectory), (Throwable)e, replies, filteredFiles);
            }
            if (e instanceof PartialSuccessException) {
                throw new PartialSuccessException(requestMessage, "Partially successful 'mput' operation" + (subDirectory == null ? "" : " on " + subDirectory), (Throwable)e, replies, filteredFiles);
            }
            throw e;
        }
        return replies;
    }

    protected List<?> ls(Message<?> message, Session<F> session, String dir) throws IOException {
        List<F> lsFiles = this.listFilesInRemoteDir(session, dir, "");
        if (!this.options.contains((Object)Option.LINKS)) {
            this.purgeLinks(lsFiles);
        }
        if (!this.options.contains((Object)Option.ALL)) {
            this.purgeDots(lsFiles);
        }
        if (this.options.contains((Object)Option.NAME_ONLY)) {
            ArrayList<String> results = new ArrayList<String>();
            for (F file : lsFiles) {
                results.add(this.getFilename(file));
            }
            if (!this.options.contains((Object)Option.NOSORT)) {
                Collections.sort(results);
            }
            return results;
        }
        List<AbstractFileInfo<F>> canonicalFiles = this.asFileInfoList(lsFiles);
        for (AbstractFileInfo<F> file : canonicalFiles) {
            file.setRemoteDirectory(dir);
        }
        if (!this.options.contains((Object)Option.NOSORT)) {
            Collections.sort(canonicalFiles);
        }
        return canonicalFiles;
    }

    private List<F> listFilesInRemoteDir(Session<F> session, String directory, String subDirectory) throws IOException {
        ArrayList<Object> lsFiles = new ArrayList<Object>();
        String remoteDirectory = this.buildRemotePath(directory, subDirectory);
        Object[] files = session.list(remoteDirectory);
        boolean recursion = this.options.contains((Object)Option.RECURSIVE);
        if (!ObjectUtils.isEmpty((Object[])files)) {
            List<Object> filteredFiles = this.filterFiles(files);
            for (Object e : filteredFiles) {
                String fileName = this.getFilename(e);
                if (e == null) continue;
                if (this.options.contains((Object)Option.SUBDIRS) || !this.isDirectory(e)) {
                    if (recursion && StringUtils.hasText((String)subDirectory)) {
                        lsFiles.add(this.enhanceNameWithSubDirectory(e, subDirectory));
                    } else {
                        lsFiles.add(e);
                    }
                }
                if (!recursion || !this.isDirectory(e) || ".".equals(fileName) || "..".equals(fileName)) continue;
                lsFiles.addAll(this.listFilesInRemoteDir(session, directory, subDirectory + fileName + this.remoteFileTemplate.getRemoteFileSeparator()));
            }
        }
        return lsFiles;
    }

    private String buildRemotePath(String parent, String child) {
        String remotePath = null;
        if (parent != null) {
            remotePath = parent + child;
        } else if (StringUtils.hasText((String)child)) {
            remotePath = "." + this.remoteFileTemplate.getRemoteFileSeparator() + child;
        }
        return remotePath;
    }

    protected final List<F> filterFiles(F[] files) {
        return this.filter != null ? this.filter.filterFiles(files) : Arrays.asList(files);
    }

    protected final List<File> filterMputFiles(File[] files) {
        if (files == null) {
            return Collections.emptyList();
        }
        return this.mputFilter != null ? this.mputFilter.filterFiles((File[])files) : Arrays.asList(files);
    }

    protected void purgeLinks(List<F> lsFiles) {
        Iterator<F> iterator = lsFiles.iterator();
        while (iterator.hasNext()) {
            if (!this.isLink(iterator.next())) continue;
            iterator.remove();
        }
    }

    protected void purgeDots(List<F> lsFiles) {
        Iterator<F> iterator = lsFiles.iterator();
        while (iterator.hasNext()) {
            if (!this.getFilename(iterator.next()).startsWith(".")) continue;
            iterator.remove();
        }
    }

    protected File get(Message<?> message, Session<F> session, String remoteDir, String remoteFilePath, String remoteFilename, F fileInfoParam) throws IOException {
        boolean replacing;
        F fileInfo = fileInfoParam;
        if (fileInfo == null) {
            F[] files = session.list(remoteFilePath);
            if (files == null) {
                throw new MessagingException("Session returned null when listing " + remoteFilePath);
            }
            if (files.length != 1 || files[0] == null || this.isDirectory(files[0]) || this.isLink(files[0])) {
                throw new MessagingException(remoteFilePath + " is not a file");
            }
            fileInfo = files[0];
        }
        File localFile = new File(this.generateLocalDirectory(message, remoteDir), this.generateLocalFileName(message, remoteFilename));
        FileExistsMode fileExistsMode = this.fileExistsMode;
        boolean appending = FileExistsMode.APPEND.equals((Object)fileExistsMode);
        boolean exists = localFile.exists();
        boolean bl = replacing = FileExistsMode.REPLACE.equals((Object)fileExistsMode) || exists && FileExistsMode.REPLACE_IF_MODIFIED.equals((Object)fileExistsMode) && localFile.lastModified() != this.getModified(fileInfo);
        if (!exists || appending || replacing) {
            String tempFileName = localFile.getAbsolutePath() + this.remoteFileTemplate.getTemporaryFileSuffix();
            File tempFile = new File(tempFileName);
            BufferedOutputStream outputStream = appending ? new BufferedOutputStream(new FileOutputStream(localFile, true)) : new BufferedOutputStream(new FileOutputStream(tempFile));
            if (replacing) {
                localFile.delete();
            }
            try {
                session.read(remoteFilePath, outputStream);
            }
            catch (Exception e) {
                ((OutputStream)outputStream).close();
                tempFile.delete();
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new MessagingException("Failure occurred while copying from remote to local directory", (Throwable)e);
            }
            finally {
                try {
                    ((OutputStream)outputStream).close();
                }
                catch (Exception exception) {}
            }
            if (!appending && !tempFile.renameTo(localFile)) {
                throw new MessagingException("Failed to rename local file");
            }
            if (this.options.contains((Object)Option.PRESERVE_TIMESTAMP) || FileExistsMode.REPLACE_IF_MODIFIED.equals((Object)fileExistsMode)) {
                localFile.setLastModified(this.getModified(fileInfo));
            }
            if (this.options.contains((Object)Option.DELETE)) {
                boolean result = session.remove(remoteFilePath);
                if (!result) {
                    this.logger.error((Object)("Failed to delete: " + remoteFilePath));
                } else if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)(remoteFilePath + " deleted"));
                }
            }
        } else if (FileExistsMode.REPLACE_IF_MODIFIED.equals((Object)fileExistsMode)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Local file '" + localFile + "' has the same modified timestamp, ignored"));
            }
            if (this.command.equals((Object)Command.MGET)) {
                localFile = null;
            }
        } else {
            if (!FileExistsMode.IGNORE.equals((Object)fileExistsMode)) {
                throw new MessageHandlingException(message, "Local file " + localFile + " already exists");
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Existing file skipped: " + localFile));
            }
            if (this.command.equals((Object)Command.MGET)) {
                localFile = null;
            }
        }
        return localFile;
    }

    protected List<File> mGet(Message<?> message, Session<F> session, String remoteDirectory, String remoteFilename) throws IOException {
        if (this.options.contains((Object)Option.RECURSIVE)) {
            if (this.logger.isWarnEnabled() && !"*".equals(remoteFilename)) {
                this.logger.warn((Object)"File name pattern must be '*' when using recursion");
            }
            if (this.options.contains((Object)Option.NAME_ONLY)) {
                this.options.remove((Object)Option.NAME_ONLY);
            }
            return this.mGetWithRecursion(message, session, remoteDirectory, remoteFilename);
        }
        return this.mGetWithoutRecursion(message, session, remoteDirectory, remoteFilename);
    }

    private List<File> mGetWithoutRecursion(Message<?> message, Session<F> session, String remoteDirectory, String remoteFilename) throws IOException {
        ArrayList<File> files;
        block6: {
            files = new ArrayList<File>();
            String remotePath = this.buildRemotePath(remoteDirectory, remoteFilename);
            List<?> remoteFiles = this.ls(message, session, remotePath);
            if (remoteFiles.size() == 0 && this.options.contains((Object)Option.EXCEPTION_WHEN_EMPTY)) {
                throw new MessagingException("No files found at " + (remoteDirectory != null ? remoteDirectory : "Client Working Directory") + " with pattern " + remoteFilename);
            }
            try {
                for (AbstractFileInfo lsEntry : remoteFiles) {
                    String fileName;
                    String fullFileName;
                    String actualRemoteDirectory;
                    File file;
                    if (lsEntry.isDirectory() || (file = this.get(message, session, actualRemoteDirectory = this.getRemoteDirectory(fullFileName = remoteDirectory != null ? remoteDirectory + this.getFilename(lsEntry) : this.getFilename(lsEntry), fileName = this.getRemoteFilename(fullFileName)), fullFileName, fileName, lsEntry.getFileInfo())) == null) continue;
                    files.add(file);
                }
            }
            catch (Exception e) {
                if (files.size() > 0) {
                    throw new PartialSuccessException(message, "Partially successful recursive 'mget' operation on " + (remoteDirectory != null ? remoteDirectory : "Client Working Directory"), (Throwable)e, files, remoteFiles);
                }
                if (e instanceof MessagingException) {
                    throw (MessagingException)e;
                }
                if (!(e instanceof IOException)) break block6;
                throw (IOException)e;
            }
        }
        return files;
    }

    private List<File> mGetWithRecursion(Message<?> message, Session<F> session, String remoteDirectory, String remoteFilename) throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        List<?> fileNames = this.ls(message, session, remoteDirectory);
        if (fileNames.size() == 0 && this.options.contains((Object)Option.EXCEPTION_WHEN_EMPTY)) {
            throw new MessagingException("No files found at " + (remoteDirectory != null ? remoteDirectory : "Client Working Directory") + " with pattern " + remoteFilename);
        }
        try {
            for (AbstractFileInfo lsEntry : fileNames) {
                String fileName;
                String fullFileName = remoteDirectory != null ? remoteDirectory + this.getFilename(lsEntry) : this.getFilename(lsEntry);
                String actualRemoteDirectory = this.getRemoteDirectory(fullFileName, fileName = this.getRemoteFilename(fullFileName));
                File file = this.get(message, session, actualRemoteDirectory, fullFileName, fileName, lsEntry.getFileInfo());
                if (file == null) continue;
                files.add(file);
            }
        }
        catch (Exception e) {
            if (files.size() > 0) {
                throw new PartialSuccessException(message, "Partially successful recursive 'mget' operation on " + (remoteDirectory != null ? remoteDirectory : "Client Working Directory"), (Throwable)e, files, fileNames);
            }
            if (e instanceof MessagingException) {
                throw (MessagingException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new MessagingException("Failed to process MGET on first file", (Throwable)e);
        }
        return files;
    }

    private String getRemoteDirectory(String remoteFilePath, String remoteFilename) {
        String remoteDir = remoteFilePath.substring(0, remoteFilePath.lastIndexOf(remoteFilename));
        if (remoteDir.length() == 0) {
            return null;
        }
        return remoteDir;
    }

    protected String getRemoteFilename(String remoteFilePath) {
        int index = remoteFilePath.lastIndexOf(this.remoteFileTemplate.getRemoteFileSeparator());
        if (index < 0) {
            return remoteFilePath;
        }
        return remoteFilePath.substring(index + 1);
    }

    private File generateLocalDirectory(Message<?> message, String remoteDirectory) {
        File localDir;
        StandardEvaluationContext evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.getBeanFactory());
        if (remoteDirectory != null) {
            evaluationContext.setVariable("remoteDirectory", (Object)remoteDirectory);
        }
        if (!(localDir = ExpressionUtils.expressionToFile((Expression)this.localDirectoryExpression, (EvaluationContext)evaluationContext, message, (String)"Local Directory")).exists()) {
            Assert.isTrue((boolean)localDir.mkdirs(), (String)("Failed to make local directory: " + localDir));
        }
        return localDir;
    }

    private String generateLocalFileName(Message<?> message, String remoteFileName) {
        if (this.localFilenameGeneratorExpression != null) {
            StandardEvaluationContext evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.getBeanFactory());
            evaluationContext.setVariable("remoteFileName", (Object)remoteFileName);
            return (String)this.localFilenameGeneratorExpression.getValue((EvaluationContext)evaluationContext, message, String.class);
        }
        return remoteFileName;
    }

    protected abstract boolean isDirectory(F var1);

    protected abstract boolean isLink(F var1);

    protected abstract String getFilename(F var1);

    protected abstract String getFilename(AbstractFileInfo<F> var1);

    protected abstract long getModified(F var1);

    protected abstract List<AbstractFileInfo<F>> asFileInfoList(Collection<F> var1);

    protected abstract F enhanceNameWithSubDirectory(F var1, String var2);

    public static enum Option {
        NAME_ONLY("-1"),
        ALL("-a"),
        NOSORT("-f"),
        SUBDIRS("-dirs"),
        LINKS("-links"),
        PRESERVE_TIMESTAMP("-P"),
        EXCEPTION_WHEN_EMPTY("-x"),
        RECURSIVE("-R"),
        STREAM("-stream"),
        DELETE("-D");

        private String option;

        private Option(String option) {
            this.option = option;
        }

        public String getOption() {
            return this.option;
        }

        public static Option toOption(String opt) {
            for (Option option : Option.values()) {
                if (!option.getOption().equals(opt)) continue;
                return option;
            }
            throw new IllegalArgumentException("No option with value '" + opt + "'");
        }
    }

    public static enum Command {
        LS("ls"),
        NLST("nlst"),
        GET("get"),
        RM("rm"),
        MGET("mget"),
        MV("mv"),
        PUT("put"),
        MPUT("mput");

        private String command;

        private Command(String command) {
            this.command = command;
        }

        public String getCommand() {
            return this.command;
        }

        public static Command toCommand(String cmd) {
            for (Command command : Command.values()) {
                if (!command.getCommand().equals(cmd)) continue;
                return command;
            }
            throw new IllegalArgumentException("No Command with value '" + cmd + "'");
        }
    }
}

