/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.flow.config.xml;

import java.util.List;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.flow.ChannelNamePortConfiguration;
import org.springframework.integration.flow.FlowConfiguration;
import org.springframework.integration.flow.PortMetadata;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class FlowConfigurationParser
implements BeanDefinitionParser {
    public BeanDefinition parse(Element element, ParserContext parserContext) {
        List portMappings = DomUtils.getChildElementsByTagName((Element)element, (String)"port-mapping");
        BeanDefinitionBuilder flowConfigurationBuilder = BeanDefinitionBuilder.genericBeanDefinition(FlowConfiguration.class);
        ManagedList portConfigList = new ManagedList();
        for (Element el : portMappings) {
            if (!DomUtils.getChildElements((Element)el).isEmpty()) {
                if (el.hasAttribute("input-channel") || el.hasAttribute("output-channel")) {
                    parserContext.getReaderContext().error("port-mapping cannot include both channel attributes and child elements", (Object)flowConfigurationBuilder);
                }
                BeanDefinition portConfiguration = this.buildFlowProviderPortConfiguration(el, parserContext);
                portConfigList.add((Object)portConfiguration);
                continue;
            }
            if (!el.hasAttribute("input-channel")) {
                parserContext.getReaderContext().error("port-mapping with no child elements must include an 'input-channel' attribute", (Object)flowConfigurationBuilder);
            }
            BeanDefinitionBuilder portConfigurationBuilder = BeanDefinitionBuilder.genericBeanDefinition(ChannelNamePortConfiguration.class);
            portConfigurationBuilder.addConstructorArgValue((Object)el.getAttribute("input-channel"));
            if (el.hasAttribute("output-channel")) {
                portConfigurationBuilder.addConstructorArgValue((Object)el.getAttribute("output-channel"));
            } else {
                portConfigurationBuilder.addConstructorArgValue(null);
            }
            portConfigList.add((Object)portConfigurationBuilder.getBeanDefinition());
        }
        flowConfigurationBuilder.addConstructorArgValue((Object)portConfigList);
        BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)flowConfigurationBuilder.getBeanDefinition(), (BeanDefinitionRegistry)parserContext.getRegistry());
        return null;
    }

    private BeanDefinition buildFlowProviderPortConfiguration(Element el, ParserContext parserContext) {
        Element inputPortEl = DomUtils.getChildElementByTagName((Element)el, (String)"input-port");
        BeanDefinitionBuilder portConfigurationBuilder = BeanDefinitionBuilder.genericBeanDefinition(ChannelNamePortConfiguration.class);
        BeanDefinition portMetadata = this.buildPortMetadata(el, inputPortEl);
        portConfigurationBuilder.addConstructorArgValue((Object)portMetadata);
        List outputPortElements = DomUtils.getChildElementsByTagName((Element)el, (String)"output-port");
        ManagedList outputList = null;
        if (outputPortElements != null) {
            outputList = new ManagedList();
            for (Element outputPortEl : outputPortElements) {
                portMetadata = this.buildPortMetadata(el, outputPortEl);
                outputList.add((Object)portMetadata);
            }
        }
        portConfigurationBuilder.addConstructorArgValue(outputList);
        return portConfigurationBuilder.getBeanDefinition();
    }

    private BeanDefinition buildPortMetadata(Element element, Element portElement) {
        BeanDefinitionBuilder portMetadataBuilder = BeanDefinitionBuilder.genericBeanDefinition(PortMetadata.class);
        portMetadataBuilder.addConstructorArgValue((Object)portElement.getAttribute("name"));
        portMetadataBuilder.addConstructorArgValue((Object)portElement.getAttribute("channel"));
        return portMetadataBuilder.getBeanDefinition();
    }
}

