/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.flow.config.xml;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.channel.PublishSubscribeChannel;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.flow.Flow;
import org.springframework.integration.flow.config.FlowUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class FlowParser
implements BeanDefinitionParser {
    public BeanDefinition parse(Element element, ParserContext parserContext) {
        Element props = DomUtils.getChildElementByTagName((Element)element, (String)"props");
        if (element.hasAttribute("properties") && props != null) {
            parserContext.getReaderContext().error("Element cannot have both 'properties' attribute and inner 'props' element", (Object)element);
        }
        BeanDefinitionBuilder flowBuilder = BeanDefinitionBuilder.genericBeanDefinition(Flow.class);
        String id = element.getAttribute("id");
        BeanDefinitionBuilder flowOutputChannelBuilder = BeanDefinitionBuilder.genericBeanDefinition(PublishSubscribeChannel.class);
        String beanName = FlowUtils.registerBeanDefinition((BeanDefinition)flowOutputChannelBuilder.getBeanDefinition(), parserContext.getRegistry());
        flowBuilder.addPropertyReference("flowOutputChannel", beanName);
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)flowBuilder, (Element)element, (String)"referenced-bean-locations");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)flowBuilder, (Element)element, (String)"properties");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)flowBuilder, (Element)element, (String)"help");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)flowBuilder, (Element)element, (String)"flow-id");
        if (props != null) {
            flowBuilder.addPropertyValue("properties", (Object)parserContext.getDelegate().parsePropsElement(props));
        }
        AbstractBeanDefinition beanDefinition = flowBuilder.getBeanDefinition();
        parserContext.getRegistry().registerBeanDefinition(id, (BeanDefinition)beanDefinition);
        return beanDefinition;
    }
}

