/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ftp.session;

import java.io.IOException;
import java.net.SocketException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPReply;
import org.springframework.integration.MessagingException;
import org.springframework.integration.file.remote.session.Session;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.integration.ftp.session.FtpSession;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFtpSessionFactory<T extends FTPClient>
implements SessionFactory {
    public static final String DEFAULT_REMOTE_WORKING_DIRECTORY = "/";
    private final Log logger = LogFactory.getLog(this.getClass());
    protected FTPClientConfig config;
    protected String username;
    protected String host;
    protected String password;
    protected int port = 21;
    protected int bufferSize = 2048;
    protected int clientMode = 0;
    protected int fileType = 2;

    public void setFileType(int fileType) {
        this.fileType = fileType;
    }

    public void setConfig(FTPClientConfig config) {
        Assert.notNull((Object)config);
        this.config = config;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setHost(String host) {
        Assert.hasText((String)host);
        this.host = host;
    }

    public void setPort(int port) {
        Assert.isTrue((port > 0 ? 1 : 0) != 0, (String)"Port number should be > 0");
        this.port = port;
    }

    public void setUsername(String user) {
        Assert.hasText((String)user, (String)"'user' should be a nonempty string");
        this.username = user;
    }

    public void setPassword(String pass) {
        Assert.notNull((Object)pass, (String)"password should not be null");
        this.password = pass;
    }

    public void setClientMode(int clientMode) {
        Assert.isTrue((clientMode == 0 || clientMode == 2 ? 1 : 0) != 0, (String)("Only local modes are supported. Was: " + clientMode));
        this.clientMode = clientMode;
    }

    public Session getSession() {
        try {
            T client = this.createClient();
            if (client == null) {
                return null;
            }
            return new FtpSession((FTPClient)client);
        }
        catch (Exception e) {
            throw new IllegalStateException("failed to create FTPClient", e);
        }
    }

    private T createClient() throws SocketException, IOException {
        T client = this.createClientInstance();
        Assert.notNull(client, (String)"client must not be null");
        client.configure(this.config);
        Assert.hasText((String)this.username, (String)"username is required");
        this.postProcessClientBeforeConnect(client);
        client.connect(this.host, this.port);
        if (!FTPReply.isPositiveCompletion((int)client.getReplyCode())) {
            throw new MessagingException("Connecting to server [" + this.host + ":" + this.port + "] failed. Please check the connection.");
        }
        this.logger.debug((Object)("Connected to server [" + this.host + ":" + this.port + "]"));
        if (!client.login(this.username, this.password)) {
            throw new IllegalStateException("Login failed. The respponse from the server is: " + client.getReplyString());
        }
        this.postProcessClientAfterConnect(client);
        this.updateClientMode((FTPClient)client);
        client.setFileType(this.fileType);
        client.setBufferSize(this.bufferSize);
        return client;
    }

    private void updateClientMode(FTPClient client) {
        switch (this.clientMode) {
            case 0: {
                client.enterLocalActiveMode();
                break;
            }
            case 2: {
                client.enterLocalPassiveMode();
                break;
            }
        }
    }

    protected abstract T createClientInstance();

    protected void postProcessClientAfterConnect(T t) throws IOException {
    }

    protected void postProcessClientBeforeConnect(T client) throws IOException {
    }
}

