/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.gemfire.store;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.GemFireCache;
import com.gemstone.gemfire.cache.Region;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.gemfire.RegionAttributesFactoryBean;
import org.springframework.data.gemfire.RegionFactoryBean;
import org.springframework.integration.store.AbstractKeyValueMessageStore;
import org.springframework.util.Assert;
import org.springframework.util.PatternMatchUtils;

public class GemfireMessageStore
extends AbstractKeyValueMessageStore
implements InitializingBean {
    private static final String MESSAGE_STORE_REGION_NAME = "messageStoreRegion";
    private volatile Region<Object, Object> messageStoreRegion;
    private final Cache cache;
    private volatile boolean ignoreJta = true;

    public GemfireMessageStore(Region<Object, Object> messageStoreRegion) {
        this.cache = null;
        this.messageStoreRegion = messageStoreRegion;
    }

    @Deprecated
    public GemfireMessageStore(Cache cache) {
        Assert.notNull((Object)cache, (String)"'cache' must not be null");
        this.cache = cache;
    }

    public void setIgnoreJta(boolean ignoreJta) {
        this.ignoreJta = ignoreJta;
    }

    public void afterPropertiesSet() {
        if (this.messageStoreRegion != null) {
            return;
        }
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"creating message store region as 'messageStoreRegion'");
            }
            RegionAttributesFactoryBean attributesFactoryBean = new RegionAttributesFactoryBean();
            attributesFactoryBean.setIgnoreJTA(this.ignoreJta);
            attributesFactoryBean.afterPropertiesSet();
            RegionFactoryBean<Object, Object> messageRegionFactoryBean = new RegionFactoryBean<Object, Object>(){};
            messageRegionFactoryBean.setBeanName(MESSAGE_STORE_REGION_NAME);
            messageRegionFactoryBean.setAttributes(attributesFactoryBean.getObject());
            messageRegionFactoryBean.setCache((GemFireCache)this.cache);
            messageRegionFactoryBean.afterPropertiesSet();
            this.messageStoreRegion = messageRegionFactoryBean.getObject();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to initialize Gemfire Region", e);
        }
    }

    protected Object doRetrieve(Object id) {
        Assert.notNull((Object)id, (String)"'id' must not be null");
        return this.messageStoreRegion.get(id);
    }

    protected void doStore(Object id, Object objectToStore) {
        Assert.notNull((Object)id, (String)"'id' must not be null");
        Assert.notNull((Object)objectToStore, (String)"'objectToStore' must not be null");
        this.messageStoreRegion.put(id, objectToStore);
    }

    protected Object doRemove(Object id) {
        Assert.notNull((Object)id, (String)"'id' must not be null");
        return this.messageStoreRegion.remove(id);
    }

    protected Collection<?> doListKeys(String keyPattern) {
        Assert.hasText((String)keyPattern, (String)"'keyPattern' must not be empty");
        Set keys = this.messageStoreRegion.keySet();
        ArrayList<String> keyList = new ArrayList<String>();
        for (Object key : keys) {
            String keyValue = key.toString();
            if (!PatternMatchUtils.simpleMatch((String)keyPattern, (String)keyValue)) continue;
            keyList.add(keyValue);
        }
        return keyList;
    }
}

