/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.groovy;

import groovy.lang.Binding;
import groovy.lang.GString;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.UUID;
import org.springframework.integration.IntegrationPattern;
import org.springframework.integration.IntegrationPatternType;
import org.springframework.integration.groovy.BindingOverwriteGroovyObjectCustomizerDecorator;
import org.springframework.integration.groovy.VariableBindingGroovyObjectCustomizerDecorator;
import org.springframework.integration.scripting.AbstractScriptExecutingMessageProcessor;
import org.springframework.integration.scripting.ScriptVariableGenerator;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.scripting.ScriptSource;
import org.springframework.scripting.groovy.GroovyObjectCustomizer;
import org.springframework.scripting.groovy.GroovyScriptFactory;
import org.springframework.scripting.support.StaticScriptSource;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

public class GroovyCommandMessageProcessor
extends AbstractScriptExecutingMessageProcessor<Object>
implements IntegrationPattern {
    private GroovyObjectCustomizer customizer;
    @Nullable
    private Binding binding;

    public GroovyCommandMessageProcessor() {
    }

    public GroovyCommandMessageProcessor(ScriptVariableGenerator scriptVariableGenerator) {
        super(scriptVariableGenerator);
    }

    public GroovyCommandMessageProcessor(Binding binding) {
        Assert.notNull((Object)binding, (String)"binding must not be null");
        this.binding = binding;
    }

    public GroovyCommandMessageProcessor(Binding binding, ScriptVariableGenerator scriptVariableGenerator) {
        this(scriptVariableGenerator);
        Assert.notNull((Object)binding, (String)"binding must not be null");
        this.binding = binding;
    }

    public void setCustomizer(GroovyObjectCustomizer customizer) {
        this.customizer = customizer;
    }

    public IntegrationPatternType getIntegrationPatternType() {
        return IntegrationPatternType.control_bus;
    }

    protected ScriptSource getScriptSource(Message<?> message) {
        Object payload = message.getPayload();
        Assert.isInstanceOf(String.class, (Object)payload, (String)"Payload must be a String containing a Groovy script.");
        String className = this.generateScriptName(message);
        return new StaticScriptSource((String)payload, className);
    }

    protected Object executeScript(ScriptSource scriptSource, Map<String, Object> variables) {
        VariableBindingGroovyObjectCustomizerDecorator customizerDecorator;
        Assert.notNull((Object)scriptSource, (String)"scriptSource must not be null");
        VariableBindingGroovyObjectCustomizerDecorator variableBindingGroovyObjectCustomizerDecorator = customizerDecorator = this.binding != null ? new BindingOverwriteGroovyObjectCustomizerDecorator(this.binding) : new VariableBindingGroovyObjectCustomizerDecorator();
        if (this.customizer != null) {
            customizerDecorator.setCustomizer(this.customizer);
        }
        if (!CollectionUtils.isEmpty(variables)) {
            customizerDecorator.setVariables(variables);
        }
        GroovyScriptFactory factory = new GroovyScriptFactory(((Object)((Object)this)).getClass().getSimpleName(), (GroovyObjectCustomizer)customizerDecorator);
        ClassLoader beanClassLoader = this.getBeanClassLoader();
        if (beanClassLoader != null) {
            factory.setBeanClassLoader(beanClassLoader);
        }
        factory.setBeanFactory(this.getBeanFactory());
        try {
            Object result = factory.getScriptedObject(scriptSource, new Class[0]);
            return result instanceof GString ? result.toString() : result;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected String generateScriptName(Message<?> message) {
        UUID id = message.getHeaders().getId();
        return ((Object)((Object)this)).getClass().getSimpleName() + (id != null ? id.toString().replaceAll("-", "") : ObjectUtils.getIdentityHexString(message));
    }
}

