/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.http;

import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.integration.Message;
import org.springframework.integration.http.InboundRequestMapper;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.util.Assert;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.support.WebBindingInitializer;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.handler.DispatcherServletWebRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataBindingInboundRequestMapper
implements InboundRequestMapper,
BeanFactoryAware,
InitializingBean {
    private volatile Class<?> targetType = Object.class;
    private volatile String targetBeanName;
    private volatile WebBindingInitializer webBindingInitializer;
    private volatile BeanFactory beanFactory;
    private volatile boolean validated;

    public DataBindingInboundRequestMapper() {
        this.targetType = Object.class;
    }

    public DataBindingInboundRequestMapper(Class<?> targetType) {
        Assert.notNull(targetType, (String)"targetType must not be null");
        this.targetType = targetType;
    }

    public void setTargetType(Class<?> targetType) {
        this.targetType = targetType;
    }

    public void setTargetBeanName(String targetBeanName) {
        this.targetBeanName = targetBeanName;
    }

    public void setWebBindingInitializer(WebBindingInitializer webBindingInitializer) {
        this.webBindingInitializer = webBindingInitializer;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public final void afterPropertiesSet() {
        if (this.targetBeanName == null && Object.class.equals(this.targetType)) {
            throw new IllegalArgumentException("When no 'targetBeanName' is provided, the 'targetType' must be more specific than Object.");
        }
        this.validateTargetBeanIfNecessary();
    }

    private void validateTargetBeanIfNecessary() {
        if (this.targetBeanName != null && !this.validated) {
            Assert.notNull((Object)this.beanFactory, (String)"beanFactory is required for binding to a bean");
            if (this.beanFactory.isSingleton(this.targetBeanName)) {
                throw new IllegalArgumentException("binding target bean must not be a singleton");
            }
            Class beanType = this.beanFactory.getType(this.targetBeanName);
            if (beanType != null) {
                Assert.isAssignable(this.targetType, (Class)beanType);
            }
            this.validated = true;
        }
    }

    public Message<?> toMessage(HttpServletRequest request) throws Exception {
        ServletRequestDataBinder binder = new ServletRequestDataBinder(this.getTarget());
        this.initBinder(binder, request);
        binder.bind((ServletRequest)request);
        Map map = binder.close();
        Object payload = map.get("target");
        return MessageBuilder.withPayload(payload).build();
    }

    private void initBinder(ServletRequestDataBinder binder, HttpServletRequest request) {
        if (this.webBindingInitializer != null) {
            this.webBindingInitializer.initBinder((WebDataBinder)binder, (WebRequest)new DispatcherServletWebRequest(request));
        }
    }

    private Object getTarget() throws InstantiationException, IllegalAccessException {
        if (this.targetBeanName != null) {
            this.validateTargetBeanIfNecessary();
            return this.beanFactory.getBean(this.targetBeanName, this.targetType);
        }
        return this.targetType.newInstance();
    }
}

