/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.http;

import java.net.URI;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Source;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.core.convert.ConversionService;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.expression.spel.support.StandardTypeConverter;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.integration.Message;
import org.springframework.integration.MessageHandlingException;
import org.springframework.integration.MessagingException;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.http.DefaultHttpHeaderMapper;
import org.springframework.integration.http.SerializingHttpMessageConverter;
import org.springframework.integration.mapping.HeaderMapper;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpRequestExecutingMessageHandler
extends AbstractReplyProducingMessageHandler {
    private static final ExpressionParser PARSER = new SpelExpressionParser();
    private final String uri;
    private volatile HttpMethod httpMethod = HttpMethod.POST;
    private volatile boolean expectReply = true;
    private volatile Class<?> expectedResponseType;
    private volatile boolean extractPayload = true;
    private volatile String charset = "UTF-8";
    private volatile HeaderMapper<HttpHeaders> headerMapper = new DefaultHttpHeaderMapper();
    private final Map<String, Expression> uriVariableExpressions = new HashMap<String, Expression>();
    private final RestTemplate restTemplate = new RestTemplate();
    private final StandardEvaluationContext evaluationContext = new StandardEvaluationContext();

    public HttpRequestExecutingMessageHandler(URI uri) {
        this(uri.toString());
    }

    public HttpRequestExecutingMessageHandler(String uri) {
        Assert.hasText((String)uri, (String)"URI is required");
        this.restTemplate.getMessageConverters().add(0, new SerializingHttpMessageConverter());
        this.uri = uri;
    }

    public void setHttpMethod(HttpMethod httpMethod) {
        this.httpMethod = httpMethod;
    }

    public void setExtractPayload(boolean extractPayload) {
        this.extractPayload = extractPayload;
    }

    public void setCharset(String charset) {
        Assert.isTrue((boolean)Charset.isSupported(charset), (String)("unsupported charset '" + charset + "'"));
        this.charset = charset;
    }

    public void setExpectReply(boolean expectReply) {
        this.expectReply = expectReply;
    }

    public void setExpectedResponseType(Class<?> expectedResponseType) {
        this.expectedResponseType = expectedResponseType;
    }

    public void setErrorHandler(ResponseErrorHandler errorHandler) {
        this.restTemplate.setErrorHandler(errorHandler);
    }

    public void setMessageConverters(List<HttpMessageConverter<?>> messageConverters) {
        this.restTemplate.setMessageConverters(messageConverters);
    }

    public void setHeaderMapper(HeaderMapper<HttpHeaders> headerMapper) {
        Assert.notNull(headerMapper, (String)"headerMapper must not be null");
        this.headerMapper = headerMapper;
    }

    public void setRequestFactory(ClientHttpRequestFactory requestFactory) {
        this.restTemplate.setRequestFactory(requestFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUriVariableExpressions(Map<String, String> uriVariableExpressions) {
        Map<String, Expression> map = this.uriVariableExpressions;
        synchronized (map) {
            this.uriVariableExpressions.clear();
            if (!CollectionUtils.isEmpty(uriVariableExpressions)) {
                for (Map.Entry<String, String> entry : uriVariableExpressions.entrySet()) {
                    this.uriVariableExpressions.put(entry.getKey(), PARSER.parseExpression(entry.getValue()));
                }
            }
        }
    }

    public void onInit() {
        ConversionService conversionService;
        super.onInit();
        BeanFactory beanFactory = this.getBeanFactory();
        if (beanFactory != null) {
            this.evaluationContext.setBeanResolver((BeanResolver)new BeanFactoryResolver(beanFactory));
        }
        if ((conversionService = this.getConversionService()) != null) {
            this.evaluationContext.setTypeConverter((TypeConverter)new StandardTypeConverter(conversionService));
        }
    }

    protected Object handleRequestMessage(Message<?> requestMessage) {
        try {
            HashMap<String, Object> uriVariables = new HashMap<String, Object>();
            for (Map.Entry<String, Expression> entry : this.uriVariableExpressions.entrySet()) {
                Object value = entry.getValue().getValue((EvaluationContext)this.evaluationContext, requestMessage, String.class);
                uriVariables.put(entry.getKey(), value);
            }
            HttpEntity<?> httpRequest = this.generateHttpRequest(requestMessage);
            ResponseEntity httpResponse = this.restTemplate.exchange(this.uri, this.httpMethod, httpRequest, this.expectedResponseType, uriVariables);
            if (this.expectReply) {
                Map headers = this.headerMapper.toHeaders((Object)httpResponse.getHeaders());
                if (httpResponse.hasBody()) {
                    Object responseBody = httpResponse.getBody();
                    MessageBuilder replyBuilder = responseBody instanceof Message ? MessageBuilder.fromMessage((Message)((Message)responseBody)) : MessageBuilder.withPayload((Object)responseBody);
                    return replyBuilder.copyHeaders(headers).build();
                }
                return MessageBuilder.withPayload((Object)httpResponse.getStatusCode()).copyHeaders(headers).build();
            }
            return null;
        }
        catch (MessagingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessageHandlingException(requestMessage, "HTTP request execution failed for URI [" + this.uri + "]", (Throwable)e);
        }
    }

    private HttpEntity<?> generateHttpRequest(Message<?> message) throws Exception {
        Assert.notNull(message, (String)"message must not be null");
        return this.extractPayload ? this.createHttpEntityWithPayloadAsBody(message) : this.createHttpEntityWithMessageAsBody(message);
    }

    private HttpEntity<?> createHttpEntityWithPayloadAsBody(Message<?> requestMessage) {
        MediaType contentType;
        if (requestMessage.getPayload() instanceof HttpEntity) {
            return (HttpEntity)requestMessage.getPayload();
        }
        HttpHeaders httpHeaders = new HttpHeaders();
        this.headerMapper.fromHeaders(requestMessage.getHeaders(), (Object)httpHeaders);
        MultiValueMap<Object, Object> payload = requestMessage.getPayload();
        MediaType mediaType = contentType = payload instanceof String ? this.resolveContentType((String)payload, this.charset) : this.resolveContentType(payload);
        if ((contentType.equals((Object)MediaType.APPLICATION_FORM_URLENCODED) || contentType.equals((Object)MediaType.MULTIPART_FORM_DATA)) && !(payload instanceof MultiValueMap)) {
            payload = this.convertToMultiValueMap((Map)payload);
        }
        httpHeaders.setContentType(contentType);
        if (HttpMethod.POST.equals((Object)this.httpMethod) || HttpMethod.PUT.equals((Object)this.httpMethod)) {
            return new HttpEntity(payload, (MultiValueMap)httpHeaders);
        }
        return new HttpEntity((MultiValueMap)httpHeaders);
    }

    private HttpEntity<Object> createHttpEntityWithMessageAsBody(Message<?> requestMessage) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(new MediaType("application", "x-java-serialized-object"));
        return new HttpEntity(requestMessage, (MultiValueMap)headers);
    }

    private MediaType resolveContentType(Object content) {
        MediaType contentType = null;
        if (content instanceof byte[]) {
            contentType = MediaType.APPLICATION_OCTET_STREAM;
        } else if (content instanceof Source) {
            contentType = MediaType.TEXT_XML;
        } else if (content instanceof Map && this.isFormData((Map)content)) {
            contentType = this.isMultipart((Map)content) ? MediaType.MULTIPART_FORM_DATA : MediaType.APPLICATION_FORM_URLENCODED;
        }
        if (contentType == null) {
            contentType = new MediaType("application", "x-java-serialized-object");
        }
        return contentType;
    }

    private MediaType resolveContentType(String content, String charset) {
        return new MediaType("text", "plain", Charset.forName(charset));
    }

    private MultiValueMap<Object, Object> convertToMultiValueMap(Map<Object, Object> simpleContentMap) {
        LinkedMultiValueMap multipartValueMap = new LinkedMultiValueMap();
        for (Object key : simpleContentMap.keySet()) {
            List<Object> value = simpleContentMap.get(key);
            if (value instanceof Object[]) {
                Object[] valueArray = (Object[])value;
                value = Arrays.asList(valueArray);
            }
            if (value instanceof Collection) {
                multipartValueMap.put(key, value);
                continue;
            }
            multipartValueMap.add(key, value);
        }
        return multipartValueMap;
    }

    private boolean isMultipart(Map<String, ?> map) {
        for (String key : map.keySet()) {
            Object value = map.get(key);
            if (value == null) continue;
            if (value.getClass().isArray()) {
                value = CollectionUtils.arrayToList(value);
            }
            if (value instanceof Collection) {
                Collection cValues = (Collection)value;
                for (Object cValue : cValues) {
                    if (cValue == null || cValue instanceof String) continue;
                    return true;
                }
                continue;
            }
            if (value instanceof String) continue;
            return true;
        }
        return false;
    }

    private boolean isFormData(Map<Object, ?> map) {
        for (Object key : map.keySet()) {
            if (key instanceof String) continue;
            return false;
        }
        return true;
    }
}

