/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.http.config;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractOutboundChannelAdapterParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class HttpOutboundChannelAdapterParser
extends AbstractOutboundChannelAdapterParser {
    protected AbstractBeanDefinition parseConsumer(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.integration.http.outbound.HttpRequestExecutingMessageHandler");
        builder.addPropertyValue("expectReply", (Object)false);
        builder.addConstructorArgValue((Object)element.getAttribute("url"));
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"http-method");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"message-converters");
        String headerMapper = element.getAttribute("header-mapper");
        String mappedRequestHeaders = element.getAttribute("mapped-request-headers");
        if (StringUtils.hasText((String)headerMapper)) {
            if (StringUtils.hasText((String)mappedRequestHeaders)) {
                parserContext.getReaderContext().error("The 'mappped-request-headers' attribute is not allowed when a 'header-mapper' has been specified.", parserContext.extractSource((Object)element));
                return null;
            }
            builder.addPropertyReference("headerMapper", headerMapper);
        } else if (StringUtils.hasText((String)mappedRequestHeaders)) {
            BeanDefinitionBuilder headerMapperBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.integration.http.support.DefaultHttpHeaderMapper");
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)headerMapperBuilder, (Element)element, (String)"mapped-request-headers", (String)"outboundHeaderNames");
            builder.addPropertyValue("headerMapper", (Object)headerMapperBuilder.getBeanDefinition());
        }
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"charset");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"extract-payload");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"expected-response-type");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"request-factory");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"error-handler");
        List uriVariableElements = DomUtils.getChildElementsByTagName((Element)element, (String)"uri-variable");
        if (!CollectionUtils.isEmpty((Collection)uriVariableElements)) {
            HashMap<String, String> uriVariableExpressions = new HashMap<String, String>();
            for (Element uriVariableElement : uriVariableElements) {
                String name = uriVariableElement.getAttribute("name");
                String expression = uriVariableElement.getAttribute("expression");
                uriVariableExpressions.put(name, expression);
            }
            builder.addPropertyValue("uriVariableExpressions", uriVariableExpressions);
        }
        return builder.getBeanDefinition();
    }
}

