/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.http.support;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpHeaders;
import org.springframework.integration.MessageHeaders;
import org.springframework.integration.mapping.HeaderMapper;
import org.springframework.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultHttpHeaderMapper
implements HeaderMapper<HttpHeaders> {
    public static final String USER_DEFINED_HEADER_PREFIX = "X-";
    private volatile String[] outboundHeaderNames = new String[0];
    private volatile String[] inboundHeaderNames = new String[0];

    public void setOutboundHeaderNames(String[] outboundHeaderNames) {
        this.outboundHeaderNames = outboundHeaderNames != null ? outboundHeaderNames : new String[]{};
    }

    public void setInboundHeaderNames(String[] inboundHeaderNames) {
        this.inboundHeaderNames = inboundHeaderNames != null ? inboundHeaderNames : new String[]{};
    }

    public void fromHeaders(MessageHeaders headers, HttpHeaders target) {
        for (String name : this.outboundHeaderNames) {
            String prefixedName;
            Object value = headers.get((Object)name);
            String string = prefixedName = name.startsWith(USER_DEFINED_HEADER_PREFIX) ? name : USER_DEFINED_HEADER_PREFIX + name;
            if (value instanceof String) {
                target.add(prefixedName, (String)value);
                continue;
            }
            if (value instanceof String[]) {
                for (String next : (String[])value) {
                    target.add(prefixedName, next);
                }
                continue;
            }
            if (!(value instanceof Iterable)) continue;
            for (Object next : (Iterable)value) {
                if (!(next instanceof String)) continue;
                target.add(prefixedName, (String)next);
            }
        }
    }

    public Map<String, ?> toHeaders(HttpHeaders source) {
        HashMap<String, Object> target = new HashMap<String, Object>();
        for (String name : this.inboundHeaderNames) {
            List values;
            String prefixedName = name.startsWith(USER_DEFINED_HEADER_PREFIX) ? name : USER_DEFINED_HEADER_PREFIX + name;
            List list = values = source.containsKey((Object)prefixedName) ? source.get((Object)prefixedName) : source.get((Object)name);
            if (CollectionUtils.isEmpty((Collection)values)) continue;
            if (values.size() == 1) {
                target.put(name, values.get(0));
                continue;
            }
            target.put(name, values);
        }
        return target;
    }
}

