/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.http.config;

import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class HttpInboundEndpointParser
extends AbstractSingleBeanDefinitionParser {
    private final boolean expectReply;

    public HttpInboundEndpointParser(boolean expectReply) {
        this.expectReply = expectReply;
    }

    protected String getBeanClassName(Element element) {
        return element.hasAttribute("view-name") ? "org.springframework.integration.http.inbound.HttpRequestHandlingController" : "org.springframework.integration.http.inbound.HttpRequestHandlingMessagingGateway";
    }

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        String id = super.resolveId(element, definition, parserContext);
        if (!StringUtils.hasText((String)id)) {
            id = element.getAttribute("name");
        }
        if (!StringUtils.hasText((String)id)) {
            parserContext.getReaderContext().error("The 'id' or 'name' is required.", (Object)element);
        }
        return id;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        builder.addConstructorArgValue((Object)this.expectReply);
        String inputChannelAttributeName = this.getInputChannelAttributeName();
        String inputChannelRef = element.getAttribute(inputChannelAttributeName);
        if (!StringUtils.hasText((String)inputChannelRef)) {
            parserContext.getReaderContext().error("a '" + inputChannelAttributeName + "' reference is required", (Object)element);
        }
        builder.addPropertyReference("requestChannel", inputChannelRef);
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"error-channel");
        if (this.expectReply) {
            IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"reply-channel");
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"request-timeout");
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"reply-timeout");
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"extract-reply-payload");
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"reply-key");
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"convert-exceptions");
        } else {
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"send-timeout", (String)"requestTimeout");
        }
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"supported-methods", (String)"supportedMethodNames");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"request-payload-type");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"view-name");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"errors-key");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"error-code");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"message-converters");
        String headerMapper = element.getAttribute("header-mapper");
        String mappedRequestHeaders = element.getAttribute("mapped-request-headers");
        String mappedResponseHeaders = element.getAttribute("mapped-response-headers");
        if (StringUtils.hasText((String)headerMapper)) {
            if (StringUtils.hasText((String)mappedRequestHeaders) || StringUtils.hasText((String)mappedResponseHeaders)) {
                parserContext.getReaderContext().error("Neither 'mappped-request-headers' or 'mapped-response-headers' attributes are allowed when a 'header-mapper' has been specified.", parserContext.extractSource((Object)element));
            }
            builder.addPropertyReference("headerMapper", headerMapper);
        } else {
            BeanDefinitionBuilder headerMapperBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.integration.http.support.DefaultHttpHeaderMapper");
            headerMapperBuilder.setFactoryMethod("inboundMapper");
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)headerMapperBuilder, (Element)element, (String)"mapped-request-headers", (String)"inboundHeaderNames");
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)headerMapperBuilder, (Element)element, (String)"mapped-response-headers", (String)"outboundHeaderNames");
            builder.addPropertyValue("headerMapper", (Object)headerMapperBuilder.getBeanDefinition());
        }
    }

    private String getInputChannelAttributeName() {
        return this.expectReply ? "request-channel" : "channel";
    }
}

