/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.http.support;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.integration.MessageHeaders;
import org.springframework.integration.context.IntegrationContextUtils;
import org.springframework.integration.mapping.HeaderMapper;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.PatternMatchUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultHttpHeaderMapper
implements HeaderMapper<HttpHeaders>,
BeanFactoryAware,
InitializingBean {
    private static final Log logger = LogFactory.getLog(DefaultHttpHeaderMapper.class);
    private volatile ConversionService conversionService;
    private volatile BeanFactory beanFactory;
    private static final String ACCEPT = "Accept";
    private static final String ACCEPT_CHARSET = "Accept-Charset";
    private static final String ACCEPT_ENCODING = "Accept-Encoding";
    private static final String ACCEPT_LANGUAGE = "Accept-Language";
    private static final String ACCEPT_RANGES = "Accept-Ranges";
    private static final String AGE = "Age";
    private static final String ALLOW = "Allow";
    private static final String AUTHORIZATION = "Authorization";
    private static final String CACHE_CONTROL = "Cache-Control";
    private static final String CONNECTION = "Connection";
    private static final String CONTENT_ENCODING = "Content-Encoding";
    private static final String CONTENT_LANGUAGE = "Content-Language";
    private static final String CONTENT_LENGTH = "Content-Length";
    private static final String CONTENT_LOCATION = "Content-Location";
    private static final String CONTENT_MD5 = "Content-MD5";
    private static final String CONTENT_RANGE = "Content-Range";
    private static final String CONTENT_TYPE = "Content-Type";
    public static final String COOKIE = "Cookie";
    private static final String DATE = "Date";
    private static final String ETAG = "ETag";
    private static final String EXPECT = "Expect";
    private static final String EXPIRES = "Expires";
    private static final String FROM = "From";
    private static final String HOST = "Host";
    private static final String IF_MATCH = "If-Match";
    private static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    private static final String IF_NONE_MATCH = "If-None-Match";
    private static final String IF_RANGE = "If-Range";
    private static final String IF_UNMODIFIED_SINCE = "If-Unmodified-Since";
    private static final String LAST_MODIFIED = "Last-Modified";
    private static final String LOCATION = "Location";
    private static final String MAX_FORWARDS = "Max-Forwards";
    private static final String PRAGMA = "Pragma";
    private static final String PROXY_AUTHENTICATE = "Proxy-Authenticate";
    private static final String PROXY_AUTHORIZATION = "Proxy-Authorization";
    private static final String RANGE = "Range";
    private static final String REFERER = "Referer";
    private static final String REFRESH = "Refresh";
    private static final String RETRY_AFTER = "Retry-After";
    private static final String SERVER = "Server";
    public static final String SET_COOKIE = "Set-Cookie";
    private static final String TE = "TE";
    private static final String TRAILER = "Trailer";
    private static final String TRANSFER_ENCODING = "Transfer-Encoding";
    private static final String UPGRADE = "Upgrade";
    private static final String USER_AGENT = "User-Agent";
    private static final String VARY = "Vary";
    private static final String VIA = "Via";
    private static final String WARNING = "Warning";
    private static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    private static final String[] HTTP_REQUEST_HEADER_NAMES = new String[]{"Accept", "Accept-Charset", "Accept-Encoding", "Accept-Language", "Accept-Ranges", "Authorization", "Cache-Control", "Connection", "Content-Length", "Content-Type", "Cookie", "Date", "Expect", "From", "Host", "If-Match", "If-Modified-Since", "If-None-Match", "If-Range", "If-Unmodified-Since", "Max-Forwards", "Pragma", "Proxy-Authorization", "Range", "Referer", "TE", "Upgrade", "User-Agent", "Via", "Warning"};
    private static String[] HTTP_RESPONSE_HEADER_NAMES = new String[]{"Accept-Ranges", "Age", "Allow", "Cache-Control", "Content-Encoding", "Content-Language", "Content-Length", "Content-Location", "Content-MD5", "Content-Range", "Content-Type", "Date", "ETag", "Expires", "Last-Modified", "Location", "Pragma", "Proxy-Authenticate", "Refresh", "Retry-After", "Server", "Set-Cookie", "Trailer", "Transfer-Encoding", "Vary", "Via", "Warning", "WWW-Authenticate"};
    public static final String HTTP_REQUEST_HEADER_NAME_PATTERN = "HTTP_REQUEST_HEADERS";
    public static final String HTTP_RESPONSE_HEADER_NAME_PATTERN = "HTTP_RESPONSE_HEADERS";
    private volatile String[] outboundHeaderNames = new String[0];
    private volatile String[] inboundHeaderNames = new String[0];
    private volatile String userDefinedHeaderPrefix = "X-";

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setOutboundHeaderNames(String[] outboundHeaderNames) {
        this.outboundHeaderNames = outboundHeaderNames != null ? outboundHeaderNames : new String[]{};
    }

    public void setInboundHeaderNames(String[] inboundHeaderNames) {
        this.inboundHeaderNames = inboundHeaderNames != null ? inboundHeaderNames : new String[]{};
    }

    public void setUserDefinedHeaderPrefix(String userDefinedHeaderPrefix) {
        this.userDefinedHeaderPrefix = userDefinedHeaderPrefix != null ? userDefinedHeaderPrefix : "";
    }

    public void fromHeaders(MessageHeaders headers, HttpHeaders target) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)MessageFormat.format("outboundHeaderNames={0}", CollectionUtils.arrayToList((Object)this.outboundHeaderNames)));
        }
        Set headerNames = headers.keySet();
        for (String name : headerNames) {
            Object value;
            if (!this.shouldMapOutboundHeader(name) || (value = headers.get((Object)name)) == null) continue;
            if (!this.containsElementIgnoreCase(HTTP_REQUEST_HEADER_NAMES, name) && !this.containsElementIgnoreCase(HTTP_RESPONSE_HEADER_NAMES, name)) {
                String string = name = StringUtils.startsWithIgnoreCase((String)name, (String)this.userDefinedHeaderPrefix) ? name : this.userDefinedHeaderPrefix + name;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)MessageFormat.format("setting headerName=[{0}], value={1}", name, value));
            }
            this.setHttpHeader(target, name, value);
        }
    }

    public Map<String, Object> toHeaders(HttpHeaders source) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)MessageFormat.format("inboundHeaderNames={0}", CollectionUtils.arrayToList((Object)this.inboundHeaderNames)));
        }
        HashMap<String, Object> target = new HashMap<String, Object>();
        Set headerNames = source.keySet();
        for (String name : headerNames) {
            if (!this.shouldMapInboundHeader(name)) continue;
            if (!ObjectUtils.containsElement((Object[])HTTP_REQUEST_HEADER_NAMES, (Object)name) && !ObjectUtils.containsElement((Object[])HTTP_RESPONSE_HEADER_NAMES, (Object)name)) {
                String prefixedName = StringUtils.startsWithIgnoreCase((String)name, (String)this.userDefinedHeaderPrefix) ? name : this.userDefinedHeaderPrefix + name;
                Object value = source.containsKey((Object)prefixedName) ? this.getHttpHeader(source, prefixedName) : this.getHttpHeader(source, name);
                if (value == null) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)MessageFormat.format("setting headerName=[{0}], value={1}", name, value));
                }
                this.setMessageHeader(target, name, value);
                continue;
            }
            Object value = this.getHttpHeader(source, name);
            if (value == null) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)MessageFormat.format("setting headerName=[{0}], value={1}", name, value));
            }
            this.setMessageHeader(target, name, value);
        }
        return target;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.beanFactory != null) {
            this.conversionService = IntegrationContextUtils.getConversionService((BeanFactory)this.beanFactory);
        }
    }

    private boolean containsElementIgnoreCase(String[] headerNames, String name) {
        for (String headerName : headerNames) {
            if (!headerName.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    private boolean shouldMapOutboundHeader(String headerName) {
        return this.shouldMapHeader(headerName, this.outboundHeaderNames);
    }

    private boolean shouldMapInboundHeader(String headerName) {
        return this.shouldMapHeader(headerName, this.inboundHeaderNames);
    }

    private boolean shouldMapHeader(String headerName, String[] patterns) {
        if (patterns != null && patterns.length > 0) {
            for (String pattern : patterns) {
                if (PatternMatchUtils.simpleMatch((String)pattern.toLowerCase(), (String)headerName.toLowerCase())) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)MessageFormat.format("headerName=[{0}] WILL be mapped, matched pattern={1}", headerName, pattern));
                    }
                    return true;
                }
                if (HTTP_REQUEST_HEADER_NAME_PATTERN.equals(pattern) && this.containsElementIgnoreCase(HTTP_REQUEST_HEADER_NAMES, headerName)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)MessageFormat.format("headerName=[{0}] WILL be mapped, matched pattern={1}", headerName, pattern));
                    }
                    return true;
                }
                if (!HTTP_RESPONSE_HEADER_NAME_PATTERN.equals(pattern) || !this.containsElementIgnoreCase(HTTP_RESPONSE_HEADER_NAMES, headerName)) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)MessageFormat.format("headerName=[{0}] WILL be mapped, matched pattern={1}", headerName, pattern));
                }
                return true;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)MessageFormat.format("headerName=[{0}] WILL NOT be mapped", headerName));
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setHttpHeader(HttpHeaders target, String name, Object value) {
        block85: {
            Object method;
            block84: {
                Object[] values;
                block82: {
                    Object charset;
                    block81: {
                        Object type;
                        block79: {
                            block83: {
                                block80: {
                                    block78: {
                                        if (!ACCEPT.equalsIgnoreCase(name)) break block78;
                                        if (!(value instanceof Collection)) {
                                            if (value instanceof MediaType) {
                                                target.setAccept(Collections.singletonList((MediaType)value));
                                                return;
                                            }
                                            if (value instanceof String[]) {
                                                ArrayList<MediaType> acceptableMediaTypes = new ArrayList<MediaType>();
                                                String[] arr$ = (String[])value;
                                                int len$ = arr$.length;
                                                int i$ = 0;
                                                while (true) {
                                                    if (i$ >= len$) {
                                                        target.setAccept(acceptableMediaTypes);
                                                        return;
                                                    }
                                                    String next = arr$[i$];
                                                    acceptableMediaTypes.add(MediaType.parseMediaType((String)next));
                                                    ++i$;
                                                }
                                            }
                                            if (value instanceof String) {
                                                target.setAccept(MediaType.parseMediaTypes((String)((String)value)));
                                                return;
                                            }
                                            Class<?> clazz = value != null ? value.getClass() : null;
                                            throw new IllegalArgumentException("Expected MediaType or String value for 'Accept' header value, but received: " + clazz);
                                        }
                                        break block79;
                                    }
                                    if (!ACCEPT_CHARSET.equalsIgnoreCase(name)) break block80;
                                    if (value instanceof Collection) break block81;
                                    if (!(value instanceof Charset[]) && !(value instanceof String[])) {
                                        if (value instanceof Charset) {
                                            target.setAcceptCharset(Collections.singletonList((Charset)value));
                                            return;
                                        }
                                        if (value instanceof String) {
                                            String[] charsets = StringUtils.commaDelimitedListToStringArray((String)((String)value));
                                            ArrayList<Charset> acceptableCharsets = new ArrayList<Charset>();
                                            String[] arr$ = charsets;
                                            int len$ = arr$.length;
                                            int i$ = 0;
                                            while (true) {
                                                if (i$ >= len$) {
                                                    target.setAcceptCharset(acceptableCharsets);
                                                    return;
                                                }
                                                String charset2 = arr$[i$];
                                                acceptableCharsets.add(Charset.forName(charset2.trim()));
                                                ++i$;
                                            }
                                        }
                                        Class<?> clazz = value != null ? value.getClass() : null;
                                        throw new IllegalArgumentException("Expected Charset or String value for 'Accept-Charset' header value, but received: " + clazz);
                                    }
                                    break block82;
                                }
                                if (!ALLOW.equalsIgnoreCase(name)) break block83;
                                if (!(value instanceof Collection)) {
                                    if (value instanceof HttpMethod) {
                                        target.setAllow(Collections.singleton((HttpMethod)value));
                                        return;
                                    }
                                    if (value instanceof HttpMethod[]) {
                                        HashSet<HttpMethod> allowedMethods = new HashSet<HttpMethod>();
                                        HttpMethod[] arr$ = (HttpMethod[])value;
                                        int len$ = arr$.length;
                                        int i$ = 0;
                                        while (true) {
                                            if (i$ >= len$) {
                                                target.setAllow(allowedMethods);
                                                return;
                                            }
                                            HttpMethod next = arr$[i$];
                                            allowedMethods.add(next);
                                            ++i$;
                                        }
                                    }
                                    if (value instanceof String || value instanceof String[]) {
                                        String[] values2 = value instanceof String[] ? (String[])value : StringUtils.commaDelimitedListToStringArray((String)((String)value));
                                        HashSet<HttpMethod> allowedMethods = new HashSet<HttpMethod>();
                                        String[] arr$ = values2;
                                        int len$ = arr$.length;
                                        int i$ = 0;
                                        while (true) {
                                            if (i$ >= len$) {
                                                target.setAllow(allowedMethods);
                                                return;
                                            }
                                            String next = arr$[i$];
                                            allowedMethods.add(HttpMethod.valueOf((String)next.trim()));
                                            ++i$;
                                        }
                                    }
                                    Class<?> clazz = value != null ? value.getClass() : null;
                                    throw new IllegalArgumentException("Expected HttpMethod or String value for 'Allow' header value, but received: " + clazz);
                                }
                                break block84;
                            }
                            if (CACHE_CONTROL.equalsIgnoreCase(name)) {
                                if (value instanceof String) {
                                    target.setCacheControl((String)value);
                                    return;
                                }
                                Class<?> clazz = value != null ? value.getClass() : null;
                                throw new IllegalArgumentException("Expected String value for 'Cache-Control' header value, but received: " + clazz);
                            }
                            if (CONTENT_LENGTH.equalsIgnoreCase(name)) {
                                if (value instanceof Number) {
                                    target.setContentLength(((Number)value).longValue());
                                    return;
                                }
                                if (value instanceof String) {
                                    target.setContentLength(Long.parseLong((String)value));
                                    return;
                                }
                                Class<?> clazz = value != null ? value.getClass() : null;
                                throw new IllegalArgumentException("Expected Number or String value for 'Content-Length' header value, but received: " + clazz);
                            }
                            if (CONTENT_TYPE.equalsIgnoreCase(name)) {
                                if (value instanceof MediaType) {
                                    target.setContentType((MediaType)value);
                                    return;
                                }
                                if (value instanceof String) {
                                    target.setContentType(MediaType.parseMediaType((String)((String)value)));
                                    return;
                                }
                                Class<?> clazz = value != null ? value.getClass() : null;
                                throw new IllegalArgumentException("Expected MediaType or String value for 'Content-Type' header value, but received: " + clazz);
                            }
                            if (DATE.equalsIgnoreCase(name)) {
                                if (value instanceof Date) {
                                    target.setDate(((Date)value).getTime());
                                    return;
                                }
                                if (value instanceof Number) {
                                    target.setDate(((Number)value).longValue());
                                    return;
                                }
                                if (value instanceof String) {
                                    target.setDate(Long.parseLong((String)value));
                                    return;
                                }
                                Class<?> clazz = value != null ? value.getClass() : null;
                                throw new IllegalArgumentException("Expected Date, Number, or String value for 'Date' header value, but received: " + clazz);
                            }
                            if (ETAG.equalsIgnoreCase(name)) {
                                if (value instanceof String) {
                                    target.setETag((String)value);
                                    return;
                                }
                                Class<?> clazz = value != null ? value.getClass() : null;
                                throw new IllegalArgumentException("Expected String value for 'ETag' header value, but received: " + clazz);
                            }
                            if (EXPIRES.equalsIgnoreCase(name)) {
                                if (value instanceof Date) {
                                    target.setExpires(((Date)value).getTime());
                                    return;
                                }
                                if (value instanceof Number) {
                                    target.setExpires(((Number)value).longValue());
                                    return;
                                }
                                if (value instanceof String) {
                                    target.setExpires(Long.parseLong((String)value));
                                    return;
                                }
                                Class<?> clazz = value != null ? value.getClass() : null;
                                throw new IllegalArgumentException("Expected Date, Number, or String value for 'Expires' header value, but received: " + clazz);
                            }
                            if (IF_MODIFIED_SINCE.equalsIgnoreCase(name)) {
                                if (value instanceof Date) {
                                    target.setIfModifiedSince(((Date)value).getTime());
                                    return;
                                }
                                if (value instanceof Number) {
                                    target.setIfModifiedSince(((Number)value).longValue());
                                    return;
                                }
                                if (value instanceof String) {
                                    target.setIfModifiedSince(Long.parseLong((String)value));
                                    return;
                                }
                                Class<?> clazz = value != null ? value.getClass() : null;
                                throw new IllegalArgumentException("Expected Date, Number, or String value for 'If-Modified-Since' header value, but received: " + clazz);
                            }
                            if (IF_NONE_MATCH.equalsIgnoreCase(name)) {
                                Object next;
                                if (value instanceof String) {
                                    target.setIfNoneMatch((String)value);
                                    return;
                                }
                                if (value instanceof String[]) {
                                    String delmitedString = StringUtils.arrayToCommaDelimitedString((Object[])((String[])value));
                                    target.setIfNoneMatch(delmitedString);
                                    return;
                                }
                                if (!(value instanceof Collection)) return;
                                Collection values3 = (Collection)value;
                                if (CollectionUtils.isEmpty((Collection)values3)) return;
                                ArrayList<String> ifNoneMatchList = new ArrayList<String>();
                                Iterator i$ = values3.iterator();
                                while (true) {
                                    if (!i$.hasNext()) {
                                        target.setIfNoneMatch(ifNoneMatchList);
                                        return;
                                    }
                                    next = i$.next();
                                    if (!(next instanceof String)) break;
                                    ifNoneMatchList.add((String)next);
                                }
                                Class<?> clazz = next != null ? next.getClass() : null;
                                throw new IllegalArgumentException("Expected String value for 'If-None-Match' header value, but received: " + clazz);
                            }
                            if (LAST_MODIFIED.equalsIgnoreCase(name)) {
                                if (value instanceof Date) {
                                    target.setLastModified(((Date)value).getTime());
                                    return;
                                }
                                if (value instanceof Number) {
                                    target.setLastModified(((Number)value).longValue());
                                    return;
                                }
                                if (value instanceof String) {
                                    target.setLastModified(Long.parseLong((String)value));
                                    return;
                                }
                                Class<?> clazz = value != null ? value.getClass() : null;
                                throw new IllegalArgumentException("Expected Date, Number, or String value for 'Last-Modified' header value, but received: " + clazz);
                            }
                            if (LOCATION.equalsIgnoreCase(name)) {
                                if (value instanceof URI) {
                                    target.setLocation((URI)value);
                                    return;
                                }
                                if (value instanceof String) {
                                    try {
                                        target.setLocation(new URI((String)value));
                                        return;
                                    }
                                    catch (URISyntaxException e) {
                                        throw new IllegalArgumentException(e);
                                    }
                                }
                                Class<?> clazz = value != null ? value.getClass() : null;
                                throw new IllegalArgumentException("Expected URI or String value for 'Location' header value, but received: " + clazz);
                            }
                            if (PRAGMA.equalsIgnoreCase(name)) {
                                if (value instanceof String) {
                                    target.setPragma((String)value);
                                    return;
                                }
                                Class<?> clazz = value != null ? value.getClass() : null;
                                throw new IllegalArgumentException("Expected String value for 'Pragma' header value, but received: " + clazz);
                            }
                            if (value instanceof String) {
                                target.set(name, (String)value);
                                return;
                            }
                            if (value instanceof String[]) {
                                String[] arr$ = (String[])value;
                                int len$ = arr$.length;
                                int i$ = 0;
                                while (i$ < len$) {
                                    String next = arr$[i$];
                                    target.add(name, next);
                                    ++i$;
                                }
                                return;
                            }
                            if (!(value instanceof Iterable)) {
                                String convertedValue = this.convertToString(value);
                                if (StringUtils.hasText((String)convertedValue)) {
                                    target.set(name, convertedValue);
                                    return;
                                }
                                logger.warn((Object)("Header '" + name + "' with value '" + value + "' will not be set since it is not a String and no Converter " + "is available. Consider registering a Converter with ConversionService (e.g., <int:converter>)"));
                                return;
                            }
                            break block85;
                        }
                        Collection values4 = (Collection)value;
                        if (CollectionUtils.isEmpty((Collection)values4)) return;
                        ArrayList<MediaType> acceptableMediaTypes = new ArrayList<MediaType>();
                        Iterator i$ = values4.iterator();
                        while (true) {
                            if (!i$.hasNext()) {
                                target.setAccept(acceptableMediaTypes);
                                return;
                            }
                            type = i$.next();
                            if (type instanceof MediaType) {
                                acceptableMediaTypes.add((MediaType)type);
                                continue;
                            }
                            if (!(type instanceof String)) break;
                            acceptableMediaTypes.addAll(MediaType.parseMediaTypes((String)((String)type)));
                        }
                        Class<?> clazz = type != null ? type.getClass() : null;
                        throw new IllegalArgumentException("Expected MediaType or String value for 'Accept' header value, but received: " + clazz);
                    }
                    Collection values5 = (Collection)value;
                    if (CollectionUtils.isEmpty((Collection)values5)) return;
                    ArrayList<Charset> acceptableCharsets = new ArrayList<Charset>();
                    Iterator i$ = values5.iterator();
                    while (true) {
                        if (!i$.hasNext()) {
                            target.setAcceptCharset(acceptableCharsets);
                            return;
                        }
                        charset = i$.next();
                        if (charset instanceof Charset) {
                            acceptableCharsets.add((Charset)charset);
                            continue;
                        }
                        if (!(charset instanceof String)) break;
                        acceptableCharsets.add(Charset.forName((String)charset));
                    }
                    Class<?> clazz = charset != null ? charset.getClass() : null;
                    throw new IllegalArgumentException("Expected Charset or String value for 'Accept-Charset' header value, but received: " + clazz);
                }
                ArrayList<Charset> acceptableCharsets = new ArrayList<Charset>();
                Object[] arr$ = values = ObjectUtils.toObjectArray((Object)value);
                int len$ = arr$.length;
                int i$ = 0;
                while (true) {
                    if (i$ >= len$) {
                        target.setAcceptCharset(acceptableCharsets);
                        return;
                    }
                    Object charset = arr$[i$];
                    if (charset instanceof Charset) {
                        acceptableCharsets.add((Charset)charset);
                    } else if (charset instanceof String) {
                        acceptableCharsets.add(Charset.forName((String)charset));
                    }
                    ++i$;
                }
            }
            Collection values = (Collection)value;
            if (CollectionUtils.isEmpty((Collection)values)) return;
            HashSet<HttpMethod> allowedMethods = new HashSet<HttpMethod>();
            Iterator i$ = values.iterator();
            while (true) {
                if (!i$.hasNext()) {
                    target.setAllow(allowedMethods);
                    return;
                }
                method = i$.next();
                if (method instanceof HttpMethod) {
                    allowedMethods.add((HttpMethod)method);
                    continue;
                }
                if (!(method instanceof String)) break;
                allowedMethods.add(HttpMethod.valueOf((String)((String)method)));
            }
            Class<?> clazz = method != null ? method.getClass() : null;
            throw new IllegalArgumentException("Expected HttpMethod or String value for 'Allow' header value, but received: " + clazz);
        }
        Iterator i$ = ((Iterable)value).iterator();
        while (i$.hasNext()) {
            Object next = i$.next();
            String convertedValue = null;
            convertedValue = next instanceof String ? (String)next : this.convertToString(value);
            if (StringUtils.hasText((String)convertedValue)) {
                target.add(name, (String)next);
                continue;
            }
            logger.warn((Object)("Element of the header '" + name + "' with value '" + value + "' will not be set since it is not a String and no Converter " + "is available. Consider registering a Converter with ConversionService (e.g., <int:converter>)"));
        }
    }

    private Object getHttpHeader(HttpHeaders source, String name) {
        if (ACCEPT.equalsIgnoreCase(name)) {
            return source.getAccept();
        }
        if (ACCEPT_CHARSET.equalsIgnoreCase(name)) {
            return source.getAcceptCharset();
        }
        if (ALLOW.equalsIgnoreCase(name)) {
            return source.getAllow();
        }
        if (CACHE_CONTROL.equalsIgnoreCase(name)) {
            String cacheControl = source.getCacheControl();
            return StringUtils.hasText((String)cacheControl) ? cacheControl : null;
        }
        if (CONTENT_LENGTH.equalsIgnoreCase(name)) {
            long contentLength = source.getContentLength();
            return contentLength > -1L ? Long.valueOf(contentLength) : null;
        }
        if (CONTENT_TYPE.equalsIgnoreCase(name)) {
            return source.getContentType();
        }
        if (DATE.equalsIgnoreCase(name)) {
            long date = source.getDate();
            return date > -1L ? Long.valueOf(date) : null;
        }
        if (ETAG.equalsIgnoreCase(name)) {
            String eTag = source.getETag();
            return StringUtils.hasText((String)eTag) ? eTag : null;
        }
        if (EXPIRES.equalsIgnoreCase(name)) {
            long expires = source.getExpires();
            return expires > -1L ? Long.valueOf(expires) : null;
        }
        if (IF_NONE_MATCH.equalsIgnoreCase(name)) {
            return source.getIfNoneMatch();
        }
        if (IF_UNMODIFIED_SINCE.equalsIgnoreCase(name)) {
            long unmodifiedSince = source.getIfNotModifiedSince();
            return unmodifiedSince > -1L ? Long.valueOf(unmodifiedSince) : null;
        }
        if (LAST_MODIFIED.equalsIgnoreCase(name)) {
            long lastModified = source.getLastModified();
            return lastModified > -1L ? Long.valueOf(lastModified) : null;
        }
        if (LOCATION.equalsIgnoreCase(name)) {
            return source.getLocation();
        }
        if (PRAGMA.equalsIgnoreCase(name)) {
            String pragma = source.getPragma();
            return StringUtils.hasText((String)pragma) ? pragma : null;
        }
        return source.get((Object)name);
    }

    private void setMessageHeader(Map<String, Object> target, String name, Object value) {
        if (ObjectUtils.isArray((Object)value)) {
            Object[] values = ObjectUtils.toObjectArray((Object)value);
            if (!ObjectUtils.isEmpty((Object[])values)) {
                if (values.length == 1) {
                    target.put(name, values);
                } else {
                    target.put(name, values[0]);
                }
            }
        } else if (value instanceof Collection) {
            Collection values = (Collection)value;
            if (!CollectionUtils.isEmpty((Collection)values)) {
                if (values.size() == 1) {
                    target.put(name, values.iterator().next());
                } else {
                    target.put(name, values);
                }
            }
        } else if (value != null) {
            target.put(name, value);
        }
    }

    private String convertToString(Object value) {
        if (this.conversionService != null && this.conversionService.canConvert(TypeDescriptor.forObject((Object)value), TypeDescriptor.valueOf(String.class))) {
            return (String)this.conversionService.convert(value, String.class);
        }
        return null;
    }

    public static DefaultHttpHeaderMapper outboundMapper() {
        DefaultHttpHeaderMapper mapper = new DefaultHttpHeaderMapper();
        mapper.setOutboundHeaderNames(HTTP_REQUEST_HEADER_NAMES);
        mapper.setInboundHeaderNames(HTTP_RESPONSE_HEADER_NAMES);
        return mapper;
    }

    public static DefaultHttpHeaderMapper inboundMapper() {
        DefaultHttpHeaderMapper mapper = new DefaultHttpHeaderMapper();
        mapper.setInboundHeaderNames(HTTP_REQUEST_HEADER_NAMES);
        mapper.setOutboundHeaderNames(HTTP_RESPONSE_HEADER_NAMES);
        return mapper;
    }
}

