/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.http.config;

import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.http.inbound.CrossOrigin;
import org.springframework.integration.http.inbound.HttpRequestHandlingController;
import org.springframework.integration.http.inbound.HttpRequestHandlingMessagingGateway;
import org.springframework.integration.http.inbound.RequestMapping;
import org.springframework.integration.http.support.DefaultHttpHeaderMapper;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class HttpInboundEndpointParser
extends AbstractSingleBeanDefinitionParser {
    private final boolean expectReply;

    public HttpInboundEndpointParser(boolean expectReply) {
        this.expectReply = expectReply;
    }

    protected String getBeanClassName(Element element) {
        return element.hasAttribute("view-name") || element.hasAttribute("view-expression") ? HttpRequestHandlingController.class.getName() : HttpRequestHandlingMessagingGateway.class.getName();
    }

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        String id = super.resolveId(element, definition, parserContext);
        if (!this.expectReply && !element.hasAttribute("channel")) {
            id = id + ".adapter";
        }
        if (!StringUtils.hasText((String)id)) {
            id = BeanDefinitionReaderUtils.generateBeanName((BeanDefinition)definition, (BeanDefinitionRegistry)parserContext.getRegistry());
        }
        return id;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        List headerElements;
        builder.addConstructorArgValue((Object)this.expectReply);
        String inputChannelAttributeName = this.getInputChannelAttributeName();
        String inputChannelRef = element.getAttribute(inputChannelAttributeName);
        if (!StringUtils.hasText((String)inputChannelRef)) {
            if (this.expectReply) {
                parserContext.getReaderContext().error("a '" + inputChannelAttributeName + "' reference is required", (Object)element);
            } else {
                inputChannelRef = IntegrationNamespaceUtils.createDirectChannel((Element)element, (ParserContext)parserContext);
            }
        }
        builder.addPropertyReference("requestChannel", inputChannelRef);
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"error-channel");
        BeanDefinition payloadExpressionDef = IntegrationNamespaceUtils.createExpressionDefIfAttributeDefined((String)"payload-expression", (Element)element);
        if (payloadExpressionDef != null) {
            builder.addPropertyValue("payloadExpression", (Object)payloadExpressionDef);
        }
        if (!CollectionUtils.isEmpty((Collection)(headerElements = DomUtils.getChildElementsByTagName((Element)element, (String)"header")))) {
            ManagedMap headerElementsMap = new ManagedMap();
            for (Element headerElement : headerElements) {
                String name = headerElement.getAttribute("name");
                BeanDefinition headerExpressionDef = IntegrationNamespaceUtils.createExpressionDefIfAttributeDefined((String)"expression", (Element)headerElement);
                if (headerExpressionDef == null) continue;
                headerElementsMap.put((Object)name, (Object)headerExpressionDef);
            }
            builder.addPropertyValue("headerExpressions", (Object)headerElementsMap);
        }
        if (this.expectReply) {
            IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"reply-channel");
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"request-timeout");
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"reply-timeout");
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"extract-reply-payload");
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"reply-key");
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"convert-exceptions");
        } else {
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"send-timeout", (String)"requestTimeout");
        }
        BeanDefinition expressionDef = IntegrationNamespaceUtils.createExpressionDefinitionFromValueOrExpression((String)"view-name", (String)"view-expression", (ParserContext)parserContext, (Element)element, (boolean)false);
        if (expressionDef != null) {
            builder.addPropertyValue("viewExpression", (Object)expressionDef);
        }
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"errors-key");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"error-code");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"message-converters");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"merge-with-default-converters");
        String headerMapper = element.getAttribute("header-mapper");
        String mappedRequestHeaders = element.getAttribute("mapped-request-headers");
        String mappedResponseHeaders = element.getAttribute("mapped-response-headers");
        boolean hasMappedRequestHeaders = StringUtils.hasText((String)mappedRequestHeaders);
        boolean hasMappedResponseHeaders = StringUtils.hasText((String)mappedResponseHeaders);
        if (StringUtils.hasText((String)headerMapper)) {
            if (hasMappedRequestHeaders || hasMappedResponseHeaders) {
                parserContext.getReaderContext().error("Neither 'mappped-request-headers' or 'mapped-response-headers' attributes are allowed when a 'header-mapper' has been specified.", parserContext.extractSource((Object)element));
            }
            builder.addPropertyReference("headerMapper", headerMapper);
        } else {
            BeanDefinitionBuilder headerMapperBuilder = BeanDefinitionBuilder.genericBeanDefinition(DefaultHttpHeaderMapper.class);
            headerMapperBuilder.setFactoryMethod("inboundMapper");
            if (hasMappedRequestHeaders) {
                headerMapperBuilder.addPropertyValue("inboundHeaderNames", (Object)mappedRequestHeaders);
            }
            if (hasMappedResponseHeaders) {
                headerMapperBuilder.addPropertyValue("outboundHeaderNames", (Object)mappedResponseHeaders);
            }
            builder.addPropertyValue("headerMapper", (Object)headerMapperBuilder.getBeanDefinition());
        }
        BeanDefinition requestMappingDef = this.createRequestMapping(element);
        builder.addPropertyValue("requestMapping", (Object)requestMappingDef);
        Element crossOriginElement = DomUtils.getChildElementByTagName((Element)element, (String)"cross-origin");
        if (crossOriginElement != null) {
            String[] attributes;
            BeanDefinitionBuilder crossOriginBuilder = BeanDefinitionBuilder.genericBeanDefinition(CrossOrigin.class);
            for (String crossOriginAttribute : attributes = new String[]{"origin", "allowed-headers", "exposed-headers", "max-age", "method"}) {
                IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)crossOriginBuilder, (Element)crossOriginElement, (String)crossOriginAttribute);
            }
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)crossOriginBuilder, (Element)crossOriginElement, (String)"allow-credentials", (boolean)true);
            builder.addPropertyValue("crossOrigin", (Object)crossOriginBuilder.getBeanDefinition());
        }
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"request-payload-type", (String)"requestPayloadType");
        BeanDefinition statusCodeExpressionDef = IntegrationNamespaceUtils.createExpressionDefIfAttributeDefined((String)"status-code-expression", (Element)element);
        if (statusCodeExpressionDef != null) {
            builder.addPropertyValue("statusCodeExpression", (Object)statusCodeExpressionDef);
        }
    }

    private String getInputChannelAttributeName() {
        return this.expectReply ? "request-channel" : "channel";
    }

    private BeanDefinition createRequestMapping(Element element) {
        BeanDefinitionBuilder requestMappingDefBuilder = BeanDefinitionBuilder.genericBeanDefinition(RequestMapping.class);
        String methods = element.getAttribute("supported-methods");
        if (StringUtils.hasText((String)methods)) {
            requestMappingDefBuilder.addPropertyValue("methods", (Object)methods.toUpperCase());
        }
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)requestMappingDefBuilder, (Element)element, (String)"path", (String)"pathPatterns");
        Element requestMappingElement = DomUtils.getChildElementByTagName((Element)element, (String)"request-mapping");
        if (requestMappingElement != null) {
            for (String requestMappingAttribute : new String[]{"params", "headers", "consumes", "produces"}) {
                IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)requestMappingDefBuilder, (Element)requestMappingElement, (String)requestMappingAttribute);
            }
        }
        return requestMappingDefBuilder.getRawBeanDefinition();
    }
}

