/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.http.inbound;

import org.springframework.http.HttpMethod;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestMethod;

public class RequestMapping {
    private String[] pathPatterns;
    private HttpMethod[] methods = new HttpMethod[]{HttpMethod.GET, HttpMethod.POST};
    private String[] params = new String[0];
    private String[] headers = new String[0];
    private String[] consumes = new String[0];
    private String[] produces = new String[0];

    public void setPathPatterns(String ... pathPatterns) {
        Assert.notEmpty((Object[])pathPatterns, (String)"at least one path pattern is required");
        this.pathPatterns = pathPatterns;
    }

    public String[] getPathPatterns() {
        return this.pathPatterns;
    }

    public void setMethods(HttpMethod ... supportedMethods) {
        Assert.notEmpty((Object[])supportedMethods, (String)"at least one supported methods is required");
        this.methods = supportedMethods;
    }

    public HttpMethod[] getMethods() {
        return this.methods;
    }

    public void setParams(String ... params) {
        Assert.notEmpty((Object[])params, (String)"at least one param is required");
        this.params = params;
    }

    public String[] getParams() {
        return this.params;
    }

    public void setHeaders(String ... headers) {
        Assert.notEmpty((Object[])headers, (String)"at least one header is required");
        this.headers = headers;
    }

    public String[] getHeaders() {
        return this.headers;
    }

    public void setConsumes(String ... consumes) {
        Assert.notEmpty((Object[])consumes, (String)"at least one consume value is required");
        this.consumes = consumes;
    }

    public String[] getConsumes() {
        return this.consumes;
    }

    public void setProduces(String ... produces) {
        Assert.notEmpty((Object[])produces, (String)"at least one produce value is required");
        this.produces = produces;
    }

    public String[] getProduces() {
        return this.produces;
    }

    public RequestMethod[] getRequestMethods() {
        RequestMethod[] requestMethods = new RequestMethod[this.methods.length];
        for (int i = 0; i < this.methods.length; ++i) {
            requestMethods[i] = RequestMethod.valueOf((String)this.methods[i].name());
        }
        return requestMethods;
    }
}

