/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.connection;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.SmartLifecycle;
import org.springframework.core.serializer.Deserializer;
import org.springframework.core.serializer.Serializer;
import org.springframework.integration.MessagingException;
import org.springframework.integration.ip.tcp.connection.ConnectionFactory;
import org.springframework.integration.ip.tcp.connection.TcpConnection;
import org.springframework.integration.ip.tcp.connection.TcpConnectionInterceptor;
import org.springframework.integration.ip.tcp.connection.TcpConnectionInterceptorFactory;
import org.springframework.integration.ip.tcp.connection.TcpConnectionInterceptorFactoryChain;
import org.springframework.integration.ip.tcp.connection.TcpListener;
import org.springframework.integration.ip.tcp.connection.TcpMessageMapper;
import org.springframework.integration.ip.tcp.connection.TcpNioConnection;
import org.springframework.integration.ip.tcp.connection.TcpSender;
import org.springframework.integration.ip.tcp.serializer.ByteArrayCrLfSerializer;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConnectionFactory
implements ConnectionFactory,
Runnable,
SmartLifecycle {
    protected Log logger = LogFactory.getLog(this.getClass());
    protected static final int DEFAULT_REPLY_TIMEOUT = 10000;
    protected String host;
    protected int port;
    protected TcpListener listener;
    protected TcpSender sender;
    protected int soTimeout;
    private int soSendBufferSize;
    private int soReceiveBufferSize;
    private boolean soTcpNoDelay;
    private int soLinger = -1;
    private boolean soKeepAlive;
    private int soTrafficClass = -1;
    private Executor taskExecutor;
    private boolean privateExecutor;
    protected Deserializer<?> deserializer = new ByteArrayCrLfSerializer();
    protected Serializer<?> serializer = new ByteArrayCrLfSerializer();
    protected TcpMessageMapper mapper = new TcpMessageMapper();
    protected boolean singleUse;
    protected int poolSize = 5;
    protected volatile boolean active;
    protected TcpConnectionInterceptorFactoryChain interceptorFactoryChain;
    private boolean lookupHost = true;
    private List<TcpConnection> connections = new LinkedList<TcpConnection>();
    protected final Object lifecycleMonitor = new Object();

    protected void setSocketAttributes(Socket socket) throws SocketException {
        if (this.soTimeout >= 0) {
            socket.setSoTimeout(this.soTimeout);
        }
        if (this.soSendBufferSize > 0) {
            socket.setSendBufferSize(this.soSendBufferSize);
        }
        if (this.soReceiveBufferSize > 0) {
            socket.setReceiveBufferSize(this.soReceiveBufferSize);
        }
        socket.setTcpNoDelay(this.soTcpNoDelay);
        if (this.soLinger >= 0) {
            socket.setSoLinger(true, this.soLinger);
        }
        if (this.soTrafficClass >= 0) {
            socket.setTrafficClass(this.soTrafficClass);
        }
        socket.setKeepAlive(this.soKeepAlive);
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }

    public int getSoReceiveBufferSize() {
        return this.soReceiveBufferSize;
    }

    public void setSoReceiveBufferSize(int soReceiveBufferSize) {
        this.soReceiveBufferSize = soReceiveBufferSize;
    }

    public int getSoSendBufferSize() {
        return this.soSendBufferSize;
    }

    public void setSoSendBufferSize(int soSendBufferSize) {
        this.soSendBufferSize = soSendBufferSize;
    }

    public boolean isSoTcpNoDelay() {
        return this.soTcpNoDelay;
    }

    public void setSoTcpNoDelay(boolean soTcpNoDelay) {
        this.soTcpNoDelay = soTcpNoDelay;
    }

    public int getSoLinger() {
        return this.soLinger;
    }

    public void setSoLinger(int soLinger) {
        this.soLinger = soLinger;
    }

    public boolean isSoKeepAlive() {
        return this.soKeepAlive;
    }

    public void setSoKeepAlive(boolean soKeepAlive) {
        this.soKeepAlive = soKeepAlive;
    }

    public int getSoTrafficClass() {
        return this.soTrafficClass;
    }

    public void setSoTrafficClass(int soTrafficClass) {
        this.soTrafficClass = soTrafficClass;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public void registerListener(TcpListener listener) {
        Assert.isNull((Object)this.listener, (String)(this.getClass().getName() + " may only be used by one inbound adapter"));
        this.listener = listener;
    }

    public void registerSender(TcpSender sender) {
        Assert.isNull((Object)this.sender, (String)(this.getClass().getName() + " may only be used by one outbound adapter"));
        this.sender = sender;
    }

    public void setTaskExecutor(Executor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public void setDeserializer(Deserializer<?> deserializer) {
        this.deserializer = deserializer;
    }

    public void setSerializer(Serializer<?> serializer) {
        this.serializer = serializer;
    }

    public void setMapper(TcpMessageMapper mapper) {
        this.mapper = mapper;
    }

    public boolean isSingleUse() {
        return this.singleUse;
    }

    public void setSingleUse(boolean singleUse) {
        this.singleUse = singleUse;
    }

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    public void setInterceptorFactoryChain(TcpConnectionInterceptorFactoryChain interceptorFactoryChain) {
        this.interceptorFactoryChain = interceptorFactoryChain;
    }

    public void setLookupHost(boolean lookupHost) {
        this.lookupHost = lookupHost;
    }

    public boolean isLookupHost() {
        return this.lookupHost;
    }

    public abstract void close();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (!this.active) {
                this.active = true;
                this.getTaskExecutor().execute(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Executor getTaskExecutor() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (!this.active) {
                throw new MessagingException("Connection Factory not started");
            }
            if (this.taskExecutor == null) {
                this.privateExecutor = true;
                this.taskExecutor = Executors.newFixedThreadPool(this.poolSize);
            }
            return this.taskExecutor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.active = false;
        this.close();
        Object object = this.connections;
        synchronized (object) {
            Iterator<TcpConnection> iterator = this.connections.iterator();
            while (iterator.hasNext()) {
                TcpConnection connection = iterator.next();
                connection.close();
                iterator.remove();
            }
        }
        object = this.lifecycleMonitor;
        synchronized (object) {
            if (this.privateExecutor) {
                ExecutorService executorService = (ExecutorService)this.taskExecutor;
                executorService.shutdown();
                try {
                    if (!executorService.awaitTermination(10L, TimeUnit.SECONDS)) {
                        this.logger.debug((Object)"Forcing executor shutdown");
                        executorService.shutdownNow();
                        if (!executorService.awaitTermination(10L, TimeUnit.SECONDS)) {
                            this.logger.debug((Object)"Executor failed to shutdown");
                        }
                    }
                }
                catch (InterruptedException e) {
                    executorService.shutdownNow();
                    Thread.currentThread().interrupt();
                }
                finally {
                    this.taskExecutor = null;
                    this.privateExecutor = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TcpConnection wrapConnection(TcpConnection connection) throws Exception {
        try {
            if (this.interceptorFactoryChain == null) {
                TcpConnection tcpConnection = connection;
                return tcpConnection;
            }
            TcpConnectionInterceptorFactory[] interceptorFactories = this.interceptorFactoryChain.getInterceptorFactories();
            if (interceptorFactories == null) {
                TcpConnection tcpConnection = connection;
                return tcpConnection;
            }
            for (TcpConnectionInterceptorFactory factory : interceptorFactories) {
                TcpConnectionInterceptor wrapper = factory.getInterceptor();
                wrapper.setTheConnection(connection);
                if (this.listener == null) {
                    connection.registerListener(wrapper);
                }
                if (this.sender == null) {
                    connection.registerSender(wrapper);
                }
                connection = wrapper;
            }
            TcpConnection tcpConnection = connection;
            return tcpConnection;
        }
        finally {
            this.addConnection(connection);
        }
    }

    protected void processNioSelections(int selectionCount, final Selector selector, ServerSocketChannel server, Map<SocketChannel, TcpNioConnection> connections) throws IOException {
        long now = 0L;
        if (this.soTimeout > 0) {
            Iterator<SocketChannel> it = connections.keySet().iterator();
            now = System.currentTimeMillis();
            while (it.hasNext()) {
                SocketChannel channel = it.next();
                if (!channel.isOpen()) {
                    this.logger.debug((Object)"Removing closed channel");
                    it.remove();
                    continue;
                }
                TcpNioConnection connection = connections.get(channel);
                if (now - connection.getLastRead() <= (long)this.soTimeout) continue;
                this.logger.warn((Object)("Timing out TcpNioConnection " + this.port + " : " + connection.getConnectionId()));
                connection.timeout();
            }
        }
        this.harvestClosedConnections();
        if (this.logger.isTraceEnabled()) {
            if (this.host == null) {
                this.logger.trace((Object)("Port " + this.port + " SelectionCount: " + selectionCount));
            } else {
                this.logger.trace((Object)("Host " + this.host + " port " + this.port + " SelectionCount: " + selectionCount));
            }
        }
        if (selectionCount > 0) {
            Set<SelectionKey> keys = selector.selectedKeys();
            Iterator<SelectionKey> iterator = keys.iterator();
            while (iterator.hasNext()) {
                final SelectionKey key = iterator.next();
                iterator.remove();
                if (!key.isValid()) {
                    this.logger.debug((Object)"Selection key no longer valid");
                    continue;
                }
                if (key.isReadable()) {
                    try {
                        key.interestOps(key.interestOps() - key.readyOps());
                        final TcpNioConnection connection = (TcpNioConnection)key.attachment();
                        connection.setLastRead(System.currentTimeMillis());
                        this.taskExecutor.execute(new Runnable(){

                            public void run() {
                                try {
                                    connection.readPacket();
                                }
                                catch (Exception e) {
                                    if (connection.isOpen()) {
                                        AbstractConnectionFactory.this.logger.error((Object)("Exception on read " + connection.getConnectionId() + " " + e.getMessage()));
                                        connection.close();
                                    }
                                    AbstractConnectionFactory.this.logger.debug((Object)"Connection closed");
                                }
                                if (key.channel().isOpen()) {
                                    key.interestOps(1);
                                    selector.wakeup();
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        if (e instanceof CancelledKeyException) {
                            this.logger.debug((Object)"Exception on readable key", (Throwable)e);
                            continue;
                        }
                        this.logger.error((Object)"Exception on readable key", (Throwable)e);
                    }
                    continue;
                }
                if (key.isAcceptable()) {
                    try {
                        this.doAccept(selector, server, now);
                    }
                    catch (Exception e) {
                        this.logger.error((Object)"Exception accepting new connection", (Throwable)e);
                    }
                    continue;
                }
                this.logger.error((Object)("Unexpected key: " + key));
            }
        }
    }

    protected void doAccept(Selector selector, ServerSocketChannel server, long now) throws IOException {
        throw new UnsupportedOperationException("Nio server factory must override this method");
    }

    public int getPhase() {
        return 0;
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addConnection(TcpConnection connection) {
        List<TcpConnection> list = this.connections;
        synchronized (list) {
            if (!this.active) {
                connection.close();
                return;
            }
            this.connections.add(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void harvestClosedConnections() {
        List<TcpConnection> list = this.connections;
        synchronized (list) {
            Iterator<TcpConnection> iterator = this.connections.iterator();
            while (iterator.hasNext()) {
                TcpConnection connection = iterator.next();
                if (connection.isOpen()) continue;
                iterator.remove();
            }
        }
    }
}

