/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.connection;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Map;
import org.springframework.integration.ip.tcp.connection.AbstractServerConnectionFactory;
import org.springframework.integration.ip.tcp.connection.TcpConnection;
import org.springframework.integration.ip.tcp.connection.TcpNioConnection;

public class TcpNioServerConnectionFactory
extends AbstractServerConnectionFactory {
    protected ServerSocketChannel serverChannel;
    protected boolean usingDirectBuffers;
    protected Map<SocketChannel, TcpNioConnection> connections = new HashMap<SocketChannel, TcpNioConnection>();
    private Selector selector;

    public TcpNioServerConnectionFactory(int port) {
        super(port);
    }

    public void run() {
        block5: {
            if (this.listener == null) {
                this.logger.info((Object)"No listener bound to server connection factory; will not read; exiting...");
                return;
            }
            try {
                this.serverChannel = ServerSocketChannel.open();
                this.logger.info((Object)("Listening on port " + this.port));
                this.serverChannel.configureBlocking(false);
                if (this.localAddress == null) {
                    this.serverChannel.socket().bind(new InetSocketAddress(this.port), Math.abs(this.poolSize));
                } else {
                    InetAddress whichNic = InetAddress.getByName(this.localAddress);
                    this.serverChannel.socket().bind(new InetSocketAddress(whichNic, this.port), Math.abs(this.poolSize));
                }
                Selector selector = Selector.open();
                this.serverChannel.register(selector, 16);
                this.listening = true;
                this.selector = selector;
                this.doSelect(this.serverChannel, selector);
            }
            catch (IOException e) {
                this.close();
                this.listening = false;
                if (!this.active) break block5;
                this.logger.error((Object)"Error on ServerSocketChannel", (Throwable)e);
                this.active = false;
            }
        }
    }

    private void doSelect(ServerSocketChannel server, Selector selector) throws IOException, ClosedChannelException, SocketException {
        while (this.active) {
            int selectionCount = selector.select(this.soTimeout);
            this.processNioSelections(selectionCount, selector, server, this.connections);
        }
    }

    protected void doAccept(Selector selector, ServerSocketChannel server, long now) throws IOException {
        this.logger.debug((Object)"New accept");
        SocketChannel channel = server.accept();
        channel.configureBlocking(false);
        Socket socket = channel.socket();
        this.setSocketAttributes(socket);
        TcpNioConnection connection = this.createTcpNioConnection(channel);
        if (connection == null) {
            return;
        }
        connection.setTaskExecutor(this.getTaskExecutor());
        connection.setLastRead(now);
        this.connections.put(channel, connection);
        channel.register(selector, 1, connection);
    }

    private TcpNioConnection createTcpNioConnection(SocketChannel socketChannel) {
        try {
            TcpNioConnection connection = new TcpNioConnection(socketChannel, true, this.isLookupHost());
            connection.setUsingDirectBuffers(this.usingDirectBuffers);
            TcpConnection wrappedConnection = this.wrapConnection(connection);
            this.initializeConnection(wrappedConnection, socketChannel.socket());
            return connection;
        }
        catch (Exception e) {
            this.logger.error((Object)"Failed to establish new incoming connection", (Throwable)e);
            return null;
        }
    }

    public boolean isRunning() {
        return this.active;
    }

    public void close() {
        if (this.selector != null) {
            this.selector.wakeup();
        }
        if (this.serverChannel == null) {
            return;
        }
        try {
            this.serverChannel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.serverChannel = null;
    }

    public void setUsingDirectBuffers(boolean usingDirectBuffers) {
        this.usingDirectBuffers = usingDirectBuffers;
    }
}

