/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp;

import java.net.ServerSocket;
import org.springframework.integration.Message;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.integration.ip.tcp.connection.AbstractClientConnectionFactory;
import org.springframework.integration.ip.tcp.connection.AbstractConnectionFactory;
import org.springframework.integration.ip.tcp.connection.AbstractServerConnectionFactory;
import org.springframework.integration.ip.tcp.connection.ConnectionFactory;
import org.springframework.integration.ip.tcp.connection.TcpListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TcpReceivingChannelAdapter
extends MessageProducerSupport
implements TcpListener {
    protected ServerSocket serverSocket;
    protected ConnectionFactory clientConnectionFactory;
    protected ConnectionFactory serverConnectionFactory;

    @Override
    public boolean onMessage(Message<?> message) {
        this.sendMessage(message);
        return false;
    }

    protected void doStart() {
    }

    protected void doStop() {
    }

    public void setConnectionFactory(AbstractConnectionFactory connectionFactory) {
        if (connectionFactory instanceof AbstractClientConnectionFactory) {
            this.clientConnectionFactory = connectionFactory;
        } else {
            this.serverConnectionFactory = connectionFactory;
        }
        connectionFactory.registerListener(this);
    }

    public boolean isListening() {
        if (this.serverConnectionFactory == null) {
            return false;
        }
        if (this.serverConnectionFactory instanceof AbstractServerConnectionFactory) {
            return ((AbstractServerConnectionFactory)this.serverConnectionFactory).isListening();
        }
        return false;
    }

    public String getComponentType() {
        return "ip:tcp-inbound-channel-adapter";
    }
}

