/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.serializer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.springframework.integration.ip.tcp.serializer.AbstractByteArraySerializer;
import org.springframework.integration.ip.tcp.serializer.SoftEndOfStreamException;

public class ByteArrayCrLfSerializer
extends AbstractByteArraySerializer {
    public byte[] deserialize(InputStream inputStream) throws IOException {
        int n;
        byte[] buffer;
        block3: {
            buffer = new byte[this.maxMessageSize];
            n = 0;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Available to read:" + inputStream.available()));
            }
            do {
                int bite;
                if ((bite = inputStream.read()) < 0 && n == 0) {
                    throw new SoftEndOfStreamException("Stream closed between payloads");
                }
                this.checkClosure(bite);
                if (n > 0 && bite == 10 && buffer[n - 1] == 13) break block3;
                buffer[n++] = (byte)bite;
            } while (n < this.maxMessageSize);
            throw new IOException("CRLF not found before max message length: " + this.maxMessageSize);
        }
        byte[] assembledData = new byte[n - 1];
        System.arraycopy(buffer, 0, assembledData, 0, n - 1);
        return assembledData;
    }

    public void serialize(byte[] bytes, OutputStream outputStream) throws IOException {
        outputStream.write(bytes);
        outputStream.write(13);
        outputStream.write(10);
        outputStream.flush();
    }
}

